#!/usr/bin/python
#
# netinfo-graph.py - CGI script to serve up a Netinfo performance graph
#
# (c) 2013 Todd Shadburn <tshadburn@opencomputingsolutions.com>
#
# Licensed under the GNU GPL version 2
#


import rrdtool, os, sys, cgi, tempfile

# debug
#import cgitb
#cgitb.enable()


def performance_data_graph(filepath, hostname, servicename, rrdtype, duration):
	if '.' in hostname:
		host, domain = hostname.split('.', 1)
	else:
		host = hostname
		domain = 'unknown'
	svc = str(servicename).replace("/", "~")
	svc2 = str(svc).replace(":", "\:")
	rrdfile = "/var/lib/netinfo/rrd/" + domain + "/" + host + "/" + rrdtype + "__" + str(svc2) + ".rrd"
	if rrdtype == "syscpu":
		args =  ["-t", str(host) + " - CPU Utilization",
			"-v", "percent",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:u=" + str(rrdfile) + ":user:AVERAGE",
			"VDEF:umin=u,MINIMUM",
			"VDEF:umax=u,MAXIMUM",
			"VDEF:uavg=u,AVERAGE",
			"LINE1:u#00FF00:user     ",
			"GPRINT:umin:min\: %6.3lf    ",
			"GPRINT:umax:max\: %6.3lf    ",
			"GPRINT:uavg:avg\: %6.3lf    \\l",
			"DEF:s=" + str(rrdfile) + ":system:AVERAGE",
			"VDEF:smin=s,MINIMUM",
			"VDEF:smax=s,MAXIMUM",
			"VDEF:savg=s,AVERAGE",
			"LINE1:s#0000FF:system   ",
			"GPRINT:smin:min\: %6.3lf    ",
			"GPRINT:smax:max\: %6.3lf    ",
			"GPRINT:savg:avg\: %6.3lf    \\l",
			"DEF:i=" + str(rrdfile) + ":iowait:AVERAGE",
			"VDEF:imin=i,MINIMUM",
			"VDEF:imax=i,MAXIMUM",
			"VDEF:iavg=i,AVERAGE",
			"LINE1:i#FF0000:iowait   ",
			"GPRINT:imin:min\: %6.3lf    ",
			"GPRINT:imax:max\: %6.3lf    ",
			"GPRINT:iavg:avg\: %6.3lf    \\l",
			"COMMENT:	 \\l",
			"COMMENT:	 \\l"]

	elif rrdtype == "sysvm":
		args =  ["-t",  str(host) + " - Virtual Memory Utilization",
			"-v", "bytes",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:mt=" + str(rrdfile) + ":memtotal:AVERAGE",
			"VDEF:mtmax=mt,MAXIMUM",
			"VDEF:mtavg=mt,AVERAGE",
			"LINE1:mt#FF0000:memtotal   ",
			"GPRINT:mtmax:max\: %18.3lf   ",
			"GPRINT:mtavg:avg\: %18.3lf\\l",
			"DEF:mc=" + str(rrdfile) + ":memcached:AVERAGE",
			"VDEF:mcmax=mc,MAXIMUM",
			"VDEF:mcavg=mc,AVERAGE",
			"LINE1:mc#00FF00:memcache   ",
			"GPRINT:mcmax:max\: %18.3lf   ",
			"GPRINT:mcavg:avg\: %18.3lf\\l",
			"DEF:ma=" + str(rrdfile) + ":memactive:AVERAGE",
			"VDEF:mamax=ma,MAXIMUM",
			"VDEF:maavg=ma,AVERAGE",
			"LINE1:ma#0000FF:memactive  ",
			"GPRINT:mamax:max\: %18.3lf   ",
			"GPRINT:maavg:avg\: %18.3lf\\l",
			"DEF:st=" + str(rrdfile) + ":swaptotal:AVERAGE",
			"VDEF:stmax=st,MAXIMUM",
			"VDEF:stavg=st,AVERAGE",
			"LINE1:st#008080:swaptotal  ",
			"GPRINT:stmax:max\: %18.3lf   ",
			"GPRINT:stavg:avg\: %18.3lf\\l",
			"DEF:sf=" + str(rrdfile) + ":swapfree:AVERAGE",
			"VDEF:sfmin=sf,MINIMUM",
			"VDEF:sfavg=sf,AVERAGE",
			"LINE1:sf#804040:swapfree   ",
			"GPRINT:sfmin:min\: %18.3lf   ",
			"GPRINT:sfavg:avg\: %18.3lf\\l"]

	elif rrdtype == "filesystem":
		fs, mount = servicename.split(':', 1)
		svc = str(fs).replace("~", "/")
		args =  ["-t",  str(host) + " - " + str(svc) + " - Filesystem Utilization",
			"-v", "Percent",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:pu=" + str(rrdfile) + ":pctused:AVERAGE",
			"VDEF:pumin=pu,MINIMUM",
			"VDEF:pumax=pu,MAXIMUM",
			"LINE2:pu#0000FF:used   ",
			"GPRINT:pumin:  min\:  %6.3lf    ",
			"GPRINT:pumax:max\:  %6.3lf\\l",
			"DEF:pw=" + str(rrdfile) + ":pctwarn:AVERAGE",
			"VDEF:pwlast=pw,LAST",
			"LINE2:pw#FFFF00:warning  ",
			"GPRINT:pwlast:curr\: %6.3lf    \\l",
			"DEF:pc=" + str(rrdfile) + ":pctcrit:AVERAGE",
			"VDEF:pclast=pc,LAST",
			"LINE2:pc#FF0000:critical ",
			"GPRINT:pclast:curr\: %6.3lf    \\l"]

	elif rrdtype == "interface":
		args =  ["-t",  str(host) + " - " + str(servicename) + " - Interface Statistics",
			"-v", "per second",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:rxbs=" + str(rrdfile) + ":rxbytes:AVERAGE",
			"VDEF:rxbsmax=rxbs,MAXIMUM",
			"VDEF:rxbsavg=rxbs,AVERAGE",
			"LINE1:rxbs#FF0000:rx bytes   ",
			"GPRINT:rxbsmax:max\: %15.3lf   ",
			"GPRINT:rxbsavg:avg\: %15.3lf\\l",
			"DEF:txbs=" + str(rrdfile) + ":txbytes:AVERAGE",
			"VDEF:txbsmax=txbs,MAXIMUM",
			"VDEF:txbsavg=txbs,AVERAGE",
			"LINE1:txbs#0000FF:tx bytes   ",
			"GPRINT:txbsmax:max\: %15.3lf   ",
			"GPRINT:txbsavg:avg\: %15.3lf\\l",
			"DEF:rxps=" + str(rrdfile) + ":rxpkts:AVERAGE",
			"VDEF:rxpsmax=rxps,MAXIMUM",
			"VDEF:rxpsavg=rxps,AVERAGE",
			"LINE1:rxps#800000:rx pkts    ",
			"GPRINT:rxpsmax:max\: %15.3lf   ",
			"GPRINT:rxpsavg:avg\: %15.3lf\\l",
			"DEF:txps=" + str(rrdfile) + ":txpkts:AVERAGE",
			"VDEF:txpsmax=txps,MAXIMUM",
			"VDEF:txpsavg=txps,AVERAGE",
			"LINE1:txps#000080:tx pkts    ",
			"GPRINT:txpsmax:max\: %15.3lf   ",
			"GPRINT:txpsavg:avg\: %15.3lf\\l"]

	elif rrdtype == "diskstat":
		args =  ["-t",  str(host) + " - " + str(servicename) + " - I/O Statistics",
			"-v", "Rate",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:rdss=" + str(rrdfile) + ":rdssec:AVERAGE",
			"VDEF:rdssmax=rdss,MAXIMUM",
			"VDEF:rdssavg=rdss,AVERAGE",
			"LINE1:rdss#FF0000:rdsect/sec    ",
			"GPRINT:rdssmax:max\: %12.3lf   ",
			"GPRINT:rdssavg:avg\: %12.3lf\\l",
			"DEF:rdsm=" + str(rrdfile) + ":rdsmerged:AVERAGE",
			"VDEF:rdsmmax=rdsm,MAXIMUM",
			"VDEF:rdsmavg=rdsm,AVERAGE",
			"LINE2:rdsm#600000:rdsmerged/sec ",
			"GPRINT:rdsmmax:max\: %12.3lf   ",
			"GPRINT:rdsmavg:avg\: %12.3lf\\l",
			"DEF:wrss=" + str(rrdfile) + ":wrssec:AVERAGE",
			"VDEF:wrssmax=wrss,MAXIMUM",
			"VDEF:wrssavg=wrss,AVERAGE",
			"LINE1:wrss#0000FF:wrsect/sec    ",
			"GPRINT:wrssmax:max\: %12.3lf   ",
			"GPRINT:wrssavg:avg\: %12.3lf\\l",
			"DEF:wrsm=" + str(rrdfile) + ":wrsmerged:AVERAGE",
			"VDEF:wrsmmax=wrsm,MAXIMUM",
			"VDEF:wrsmavg=wrsm,AVERAGE",
			"LINE2:wrsm#000060:wrsmerged/sec ",
			"GPRINT:wrsmmax:max\: %12.3lf   ",
			"GPRINT:wrsmavg:avg\: %12.3lf\\l"]

	elif rrdtype == "gauge":
		args =  ["-t",  str(host) + " - " + str(servicename) + " - Gauge",
			"-v", "Value",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:pu=" + str(rrdfile) + ":value:AVERAGE",
			"VDEF:pumin=pu,MINIMUM",
			"VDEF:pumax=pu,MAXIMUM",
			"LINE2:pu#0000FF:used   ",
			"GPRINT:pumin:  min\:  %6.3lf    ",
			"GPRINT:pumax:max\:  %6.3lf\\l",
			"DEF:pw=" + str(rrdfile) + ":warnmax:AVERAGE",
			"VDEF:pwlast=pw,LAST",
			"LINE2:pw#FFFF00:warning  ",
			"GPRINT:pwlast:curr\: %6.3lf    \\l",
			"DEF:pc=" + str(rrdfile) + ":critmax:AVERAGE",
			"VDEF:pclast=pc,LAST",
			"LINE2:pc#FF0000:critical ",
			"GPRINT:pclast:curr\: %6.3lf    \\l"]

	elif rrdtype == "latency":
		args =  ["-t",  str(host) + " - " + str(servicename) + " - Gauge",
			"-v", "Value",
			"-c", "BACK#202020",
			"-c", "CANVAS#000000",
			"-c", "SHADEA#808080",
			"-c", "SHADEB#808080",
			"-c", "FONT#A0A0A0",
			"-c", "AXIS#00B000",
			"-c", "MGRID#00B000",
			"-c", "ARROW#00B000",
			"DEF:pu=" + str(rrdfile) + ":resptime:AVERAGE",
			"VDEF:pumin=pu,MINIMUM",
			"VDEF:pumax=pu,MAXIMUM",
			"LINE2:pu#0000FF:used   ",
			"GPRINT:pumin:  min\:  %6.3lf    ",
			"GPRINT:pumax:max\:  %6.3lf\\l",
			"DEF:pw=" + str(rrdfile) + ":warntime:AVERAGE",
			"VDEF:pwlast=pw,LAST",
			"LINE2:pw#FFFF00:warning  ",
			"GPRINT:pwlast:curr\: %6.3lf    \\l",
			"DEF:pc=" + str(rrdfile) + ":crittime:AVERAGE",
			"VDEF:pclast=pc,LAST",
			"LINE2:pc#FF0000:critical ",
			"GPRINT:pclast:curr\: %6.3lf    \\l"]

	rc = rrdtool.graph(
		filepath,
		"--imgformat", "PNG",
		"--end", "now",
		"--start", "end-" + str(duration) + "s",
		"--width", "400",
		"--height", "100",
		*args)
	return rc



form = cgi.FieldStorage()
hostname = form.getfirst("hostname", "citasvcct7int01.home.opencomputingsolutions.com")
#service = form.getfirst("service", "SYSCPU")
service = form.getfirst("service", "testgauge")
duration = int(form.getfirst("duration", "0"))

if service == 'SYSCPU':
	svctype = 'syscpu'
elif service == 'SYSVM':
	svctype = 'sysvm'
elif 'MOUNT' in service:
	svctype = 'filesystem'
elif 'eth' in service:
	svctype = 'interface'
elif 'bond' in service:
	svctype = 'interface'
elif 'dm-' in service:
	svctype = 'diskstat'
elif 'sd' in service:
	svctype = 'diskstat'
elif 'hd' in service:
	svctype = 'diskstat'
elif 'vd' in service:
	svctype = 'diskstat'
elif 'HTTP' in service:
	svctype = 'gauge'
elif 'testgauge' in service:
	svctype = 'latency'

tfd,tname = tempfile.mkstemp(suffix=".png", dir='/tmp')
rc = performance_data_graph(tname, hostname, service, svctype, duration)

print "Content-Type: image/png"

if not rc:
	print "Content-Length: 0"
	print
	sys.exit(2)
tf = os.fdopen(tfd, "rb")
os.unlink(tname)
tf.seek(0, 2)
print "Content-Length: " + str(tf.tell())
tf.seek(0)
print

while True:
	buffer = tf.read(4096)
	if buffer:
		sys.stdout.write(buffer)
	else:
		break
tf.close()
sys.exit(0)


