#!/usr/bin/python
#
# netinfo-graph.py - CGI script to serve up a Netinfo performance graph
#
# (c) 2013 Todd Shadburn <tshadburn@opencomputingsolutions.com>
#
# Licensed under the GNU GPL version 2
#


import os, sys, cgi

# debug
import cgitb
cgitb.enable()


form = cgi.FieldStorage()
hostname = form.getfirst("hostname", "ubuntu11106402.unknown")
service = form.getfirst("service", "SYSCPU")
if 'duration' in form:
	duration = int(form.getfirst("duration", "0"))
else:
	duration = 86400

url = "netinfo-graph.py?hostname=" + hostname + "&service=" + service + "&duration="

# Headers
print "Content-Type: text/html"
print

# body
print "<html>"
print "<head>"
print "<title>Performance: " + hostname + " " + service + "</title>"
print "</head>"
print "<body bgcolor=\"#808080\">"
print "<script type=\"text/javascript\">"
print "function update_image(duration){"
print "    var url = \"" + url + "\" + duration"
print "    document.getElementById('graph-image').src=url "
print "}"
print "</script>"
print "<h3>Performance: " + hostname + " " + service + "</h3>"

print "<p><form action="" method=\"POST\">"
print "<select id=\"graph-duration\" onchange=\"update_image(this.value);\">"
print "<option value=\"86400\">1-day</option>"
print "<option value=\"604800\">1-week</option>"
print "<option value=\"2678400\">1-month</option>"
print "<option value=\"31536000\">1-year</option>"
print "</select>"
print "</form></p>"

print "<p><img id=\"graph-image\" src=\"%s%s\" alt=\"graph\" /></p>" % (url, str(duration))
print "</body>"
print "<html>"

sys.exit(0)

