<?php
/*
 * admin.php - Admin source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';
include 'html.table.class.inc';
include 'userattribute.dbtable.inc';
include 'trapfilter.dbtable.inc';
include 'trapfiltermatch.dbtable.inc';

include 'alertrule.dbtable.class.inc';
include 'alertrulematch.dbtable.class.inc';
include 'alertruleaction.dbtable.class.inc';

include 'contact.dbtable.class.inc';
include 'oncallschedule.dbtable.class.inc';
include 'calendar.class.inc';

include 'client.dbtable.class.inc';
include 'clientprocess.dbtable.class.inc';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (-1);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}


display_navmenu ();


$pagemenu = array ();
if (user_has_access_right ('AdminUserEdit')) {
	$pagemenu['useraccesslist'] = 'User_Access';
}
if (user_has_access_right ('AdminView')) {
	$pagemenu['trapfilterlist'] = 'Trap_Filters';
	$pagemenu['alertrulelist'] = 'Alert_Rules';
}
#if (user_has_access_right ('AdminOncallEdit')) {
#	$pagemenu['oncallcalendar'] = 'Oncall_Calendar';
#	$pagemenu['oncallschedulelist'] = 'Oncall_Schedule';
#	$pagemenu['contactlist'] = 'Contacts';
#}
if (user_has_access_right ('AdminClientEdit')) {
	$pagemenu['clientlist'] = 'Clients';
}
render_page_menu ($pagemenu);


/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if ($_GET['view'] == "") {
		print "<tr><td><font color='white'><h4>";
		print "This is the administration page.</h4></font></td></td>";

	} else if ($_GET['view'] == "useraccesslist") {
		display_user_access_list ();

	/* trap filter */
	} else if ($_GET['view'] == "trapfilterlist") {
		unset ($_SESSION['tf_id']);
		display_trapfilter_list ();

	} else if ($_GET['view'] == "trapfilteredit") {
		display_trapfilter ("", "");

	} else if ($_GET['view'] == "trapfilterdelete") {
		$rcr = delete_trapfilter ();
		display_trapfilter_list ();

	} else if ($_GET['view'] == "trapfilterclone") {
		$rcr = clone_trapfilter ();
		display_trapfilter_list ();

	} else if ($_GET['view'] == "trapfiltermatchlist") {
		unset ($_SESSION['tfm_id']);
		display_trapfiltermatch_list ();

	} else if ($_GET['view'] == "trapfiltermatchedit") {
		display_trapfiltermatch ("", "");

	} else if ($_GET['view'] == "trapfiltermatchdelete") {
		$rcr = delete_trapfiltermatch ();
		display_trapfilter ();

		
	/* alert rule */
	} else if ($_GET['view'] == "alertrulelist") {
		unset ($_SESSION['ar_id']);
		display_alertrule_list ();

	} else if ($_GET['view'] == "alertruleedit") {
		display_alertrule ();


	/* contact/oncall */
	} else if ($_GET['view'] == "contactlist") {
		unset ($_SESSION['c_id']);
		display_contact_list ();

	} else if ($_GET['view'] == "contactedit") {
		display_contact ("", "");

	} else if ($_GET['view'] == "contactdelete") {
		$rcr = delete_contact ();
		display_contact_list ();

	} else if ($_GET['view'] == "oncallcalendar") {
		display_oncall_calendar ();

	} else if ($_GET['view'] == "oncallschedulelist") {
		unset ($_SESSION['os_id']);
		display_oncall_schedule_list ("", "");

	} else if ($_GET['view'] == "oncallscheduleedit") {
		display_oncall_schedule ("", "");

	} else if ($_GET['view'] == "oncallscheduledelete") {
		$rcr = delete_oncall_schedule ();
		display_oncall_schedule_list ();


	/* client */
	} else if ($_GET['view'] == "clientlist") {
		unset ($_SESSION['c_id']);
		display_client_list ();

	} else if ($_GET['view'] == "clientedit") {
		display_client ("", "");

	} else if ($_GET['view'] == "clientdelete") {
		$rcr = delete_client ();
		display_client_list ();

	} else if ($_GET['view'] == "clientclone") {
		$rcr = clone_client ();
		display_client_list ();

	} else if ($_GET['view'] == "clientprocesslist") {
		unset ($_SESSION['cp_id']);
		display_clientprocess_list ();

	} else if ($_GET['view'] == "clientprocessedit") {
		display_clientprocess ("", "");

	} else if ($_GET['view'] == "clientprocessdelete") {
		$rcr = delete_clientprocess ();
		display_client ();

		
	/* unknown */
	} else {
		print "<tr><td><font color='white'><h4>";
		print "This page is not finished yet.</h4></font></td></td>";
		#session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	/* trapfilters */
	} else if ($_SESSION['page'] == "trapfilterlist") {
		if (isset ($_POST["addfilter"])) {
			display_trapfilter ();
		} else {
			display_trapfilter_list ();
		}

	} else if ($_SESSION['page'] == "trapfilteredit") {
		$sevid = $_SESSION['AlertSeverityId'];
		$classid = $_SESSION['AlertClassId'];
		$tftable = new TrapFilterDbTableClass ();
		$data = $tftable->OnlyColumns ($_POST);
		$data['tf_class'] = $classid[$data['tf_class']];
		$data['tf_severity'] = $sevid[$data['tf_severity']];
		if (isset ($_POST['addfilter'])) {
			unset ($data['tf_id']);
			$rcr = $tftable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $tftable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $tftable->PostInsertSetPkey ($data);
					$_SESSION['tf_id'] = $data['tf_id'];
				}
			}
			display_trapfilter ($data, $rcr);
		} else if (isset ($_POST['updatefilter']) && isset ($_SESSION['tf_id'])) {
			if ($_SESSION['tf_id'] != $_POST['tf_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $tftable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $tftable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['tf_id'] = $data['tf_id'];
					}
				}
			}
			display_trapfilter ($data, $rcr);

		} else if (isset ($_POST["addfiltermatch"])) {
			display_trapfiltermatch ("", "");

		} else {
			display_trapfilter ();
		}

	} else if ($_SESSION['page'] == "trapfiltermatchedit") {
		$tfmtable = new TrapFilterMatchDbTableClass ();
		$data = $tfmtable->OnlyColumns ($_POST);
		if (isset ($_POST['addfiltermatch'])) {
			unset ($data['tfm_id']);
			$data['tfm_tf_id'] = $_SESSION['tf_id'];
			$rcr = $tfmtable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $tfmtable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $tfmtable->PostInsertSetPkey ($data);
					$_SESSION['tfm_id'] = $data['tfm_id'];
				}
			}
			display_trapfiltermatch ($data, $rcr);
		} else if (isset ($_POST['updatefiltermatch']) && isset ($_SESSION['tfm_id'])) {
			if ($_SESSION['tfm_id'] != $_POST['tfm_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				unset ($data['tfm_tf_id']);
				$rcr = $tfmtable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $tfmtable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['tfm_id'] = $data['tfm_id'];
					}
				}
			}
			display_trapfiltermatch ($data, $rcr);
		} else {
			display_trapfiltermatch ("", "");
		}

	/* alertrules */
	} else if ($_SESSION['page'] == "alertrulelist") {
		if (isset ($_POST["addalertrule"])) {
			display_alertrule ();
		} else {
			display_alertrule_list ();
		}

	} else if ($_SESSION['page'] == "alertruleedit") {
		$yesnoid = array ('False' => 0, 'True' => 1);
		$artable = new AlertRuleDbTableClass ();
		$data = $artable->OnlyColumns ($_POST);
		$data['ar_active'] = $yesnoid[$data['ar_active']];
		if (isset ($_POST['addalertrule'])) {
			unset ($data['ar_id']);
			$rcr = $artable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $artable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $artable->PostInsertSetPkey ($data);
					$_SESSION['ar_id'] = $data['ar_id'];
				}
			}
			display_alertrule ($data, $rcr);
		} else if (isset ($_POST['updatealertrule']) && isset ($_SESSION['ar_id'])) {
			if ($_SESSION['ar_id'] != $_POST['ar_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $artable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $artable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['ar_id'] = $data['ar_id'];
					}
				}
			}
			display_alertrule ($data, $rcr);

		} else if (isset ($_POST["addalertrulematch"])) {
			display_alertrulematch ();

		} else {
			display_alertrule ();
		}

	/* contacts */
	} else if ($_SESSION['page'] == "contactlist") {
		if (isset ($_POST["addcontact"])) {
			display_contact ();
		} else {
			display_contact_list ();
		}

	} else if ($_SESSION['page'] == "contactedit") {
		$ctable = new ContactDbTableClass ();
		$data = $ctable->OnlyColumns ($_POST);
		if (isset ($_POST['addcontact'])) {
			unset ($data['c_id']);
			$rcr = $ctable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $ctable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $ctable->PostInsertSetPkey ($data);
					$_SESSION['c_id'] = $data['c_id'];
				}
			}
			display_contact ($data, $rcr);
		} else if (isset ($_POST['updatecontact']) && isset ($_SESSION['c_id'])) {
			if ($_SESSION['c_id'] != $_POST['c_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $ctable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $ctable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['c_id'] = $data['c_id'];
					}
				}
			}
			display_contact ($data, $rcr);
		} else {
			display_contact ();
		}

	} else if ($_SESSION['page'] == "oncallschedulelist") {
		if (isset ($_POST["addoncallschedule"])) {
			display_oncall_schedule ("", "");
		} else {
			display_oncall_schedule_list ("", "");
		}

	} else if ($_SESSION['page'] == "oncallscheduleedit") {
		$ostable = new ONcallScheduleDbTableClass ();
		$data = $ostable->OnlyColumns ($_POST);
		if (isset ($_POST['addoncallschedule'])) {
			unset ($data['os_id']);
			$rcr = $ostable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$ctable = new ContactDbTableClass ();
				$ctable->SetWhere ("c_username = '" . $_POST['c_username'] . "'");
				$cdata = $ctable->GetPageData (1);
				$r = $cdata[0];
				if (isset ($r['c_id'])) {
					$data['os_c_id'] = $r['c_id'];
					$rcr = $ostable->InsertRecord ($data);
					if ($rcr[0] == 0) {
						$data = $ostable->PostInsertSetPkey ($data);
						$_SESSION['os_id'] = $data['os_id'];
					}
				} else {
					# No contact found
					$rcr[0] = 1;
					$rcr[1] = array ("That contact username is invalid. Try again.");
				}
			}
			display_oncall_schedule ($data, $rcr);
		} else if (isset ($_POST['updateoncallschedule']) && isset ($_SESSION['os_id'])) {
			if ($_SESSION['os_id'] != $_POST['os_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $ostable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$ctable = new ContactDbTableClass ();
					$ctable->SetWhere ("c_username = '" . $_POST['c_username'] . "'");
					$cdata = $ctable->GetPageData (1);
					$r = $cdata[0];
					if (isset ($r['c_id'])) {
						$data['os_c_id'] = $r['c_id'];
						$rcr = $ostable->UpdateRecord ($data);
						if ($rcr[0] == 0) {
							$_SESSION['os_id'] = $data['os_id'];
						}
					} else {
						# No contact found
						$rcr[0] = 1;
						$rcr[1] = array ("That contact username is invalid. Try again.");
					}
				}
			}
			display_oncall_schedule ($data, $rcr);
		} else {
			display_oncall_schedule ("", "");
		}

	/* client */
	} else if ($_SESSION['page'] == "clientlist") {
		if (isset ($_POST["addclient"])) {
			display_client ();
		} else {
			display_client_list ();
		}

	} else if ($_SESSION['page'] == "clientedit") {
		$truefalse = array ('False' => 0, 'True' => 1);
		$ctable = new ClientDbTableClass ();
		$data = $ctable->OnlyColumns ($_POST);
		$data['c_active'] = $truefalse[$data['c_active']];
		if (isset ($_POST['addclient'])) {
			unset ($data['c_id']);
			$rcr = $ctable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $ctable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $ctable->PostInsertSetPkey ($data);
					$_SESSION['c_id'] = $data['c_id'];
				}
			}
			display_client ($data, $rcr);
		} else if (isset ($_POST['updateclient']) && isset ($_SESSION['c_id'])) {
			if ($_SESSION['c_id'] != $_POST['c_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $ctable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $ctable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['c_id'] = $data['c_id'];
					}
				}
			}
			display_client ($data, $rcr);

		} else if (isset ($_POST["addclientprocess"])) {
			display_clientprocess ();

		} else {
			display_client ();
		}

	} else if ($_SESSION['page'] == "clientprocessedit") {
		$cptable = new ClientProcessDbTableClass ();
		$data = $cptable->OnlyColumns ($_POST);
		if (isset ($_POST['addclientprocess'])) {
			unset ($data['cp_id']);
			$data['cp_c_id'] = $_SESSION['c_id'];
			$rcr = $cptable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $cptable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $cptable->PostInsertSetPkey ($data);
					$_SESSION['cp_id'] = $data['cp_id'];
				}
			}
			display_clientprocess ($data, $rcr);
		} else if (isset ($_POST['updateclientprocess']) && isset ($_SESSION['cp_id'])) {
			if ($_SESSION['cp_id'] != $_POST['cp_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				unset ($data['cp_c_id']);
				$rcr = $cptable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $cptable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['cp_id'] = $data['cp_id'];
					}
				}
			}
			display_clientprocess ($data, $rcr);
		} else {
			display_clientprocess ();
		}

	/* unknown */
	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";

/*** Free resources */
mysql_close ($conn);

return 0;


/************************************************************************/
/* Render the UserAccessList page					*/
/************************************************************************/
function display_user_access_list ()
{
	if (user_check_access_right ('AdminUserEdit')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("User Access List");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Action',
				'width' => 60,
				'dataname' => '_actions'));
	$t->AddColumn (array ('displayname' => 'Username',
				'width' => 120,
				'dataname' => 'ua_username'));
	$t->AddColumn (array ('displayname' => 'Access',
				'width' => "80%",
				'dataname' => 'ua_value'));
	$uatable = new UserAttributeDbTableClass ();
	$uatable->SetWhere ("ua_attribute = 'ACCESSRIGHT'");
	$d = $uatable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$row['_actions'] = "<input type='checkbox' name='accessid' value='" . $row['ua_id'] . "'>";
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p><input type='submit' name='removeaccess' value='Remove Access'>&nbsp";
	print "<p><input type='submit' name='addaccess' value='Add Access'>&nbsp";
	print "</form>";
	session_set_page ("useraccesslist");
	return;
}


function display_trapfilter_list ()
{
	if (user_check_access_right ('AdminView')) {
		access_denied_page();
		return 1;
	}

	$can_edit = 0;
	if (!user_check_access_right ('AdminTrapEdit')) {
		$can_edit = 1;
	}

	$sev = $_SESSION['AlertSeverity'];
	$class = $_SESSION['AlertClass'];

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Trap Filters");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'tf_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'tf_name'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'tf_desc'));
	$t->AddColumn (array ('displayname' => 'Trap OID',
				'dataname' => 'tf_trapoid'));
	$t->AddColumn (array ('displayname' => 'Class',
				'dataname' => 'tf_class'));
	$t->AddColumn (array ('displayname' => 'Severity',
				'dataname' => 'tf_severity'));
	$t->AddColumn (array ('displayname' => 'Order',
				'dataname' => 'tf_order'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$tftable = new TrapFilterDbTableClass ();
	$rcr = $tftable->SetOrderBy ("tf_trapoid,tf_order asc");
	$tftable->SetPageRows (200);
	$d = $tftable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$fid = $row['tf_id'];
		$row['tf_severity'] = $sev[$row['tf_severity']];
		$row['tf_class'] = $class[$row['tf_class']];
		$o = "<a href='?view=trapfilteredit&fid=$fid'>Edit</a>";
		if ($can_edit == 1) {
			$o .= "&nbsp<a href='?view=trapfilterdelete&fid=$fid'>Delete</a>";
			$o .= "&nbsp<a href='?view=trapfilterclone&fid=$fid'>Clone</a>";
		}
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	if ($can_edit == 1) {
		print "<p><input type='submit' name='addfilter' value='Add Filter'>";
	}
	print "</form>";
	session_set_page ("trapfilterlist");
	return;
}


function display_trapfilter ($filterdata, $errors)
{
	if (user_check_access_right ('AdminView')) {
		access_denied_page();
		return 1;
	}

	$can_edit = 0;
	if (!user_check_access_right ('AdminTrapEdit')) {
		$can_edit = 1;
	}

	$sev = $_SESSION['AlertSeverity'];
	$class = $_SESSION['AlertClass'];

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	print "<b><a href='?view=trapfilterlist'>Filter List</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['fid']) && is_valid_integer ($_GET['fid'])) {
			$fid = $_GET['fid'];
			$_SESSION['tf_id'] = $fid;
		} else {
			unset ($_SESSION['tf_id']);
		}
	} else {
		if (isset ($_POST['addfilter'])) {
			if (isset ($filterdata) && isset ($filterdata['tf_id'])) {
				$fid = $filterdata['tf_id'];
			}
		} else if (isset ($_POST['updatefilter'])) {
				$fid = $_SESSION['tf_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($fid)) {
		$title = "Trap Filter (New)";
	} else {
		$title = "Trap Filter (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'tf_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'tf_name'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'tf_desc'));
	$t->AddColumn (array ('displayname' => 'Trap OID',
				'dataname' => 'tf_trapoid'));
	$t->AddColumn (array ('displayname' => 'Class',
				'dataname' => 'tf_class'));
	$t->AddColumn (array ('displayname' => 'Severity',
				'dataname' => 'tf_severity'));
	$t->AddColumn (array ('displayname' => 'Object',
				'dataname' => 'tf_object'));
	$t->AddColumn (array ('displayname' => 'Unique ID',
				'dataname' => 'tf_uniqueid'));
	$t->AddColumn (array ('displayname' => 'Marks Recovery (0/1)',
				'dataname' => 'tf_markrecover'));
	$t->AddColumn (array ('displayname' => 'Always Unique (0/1)',
				'dataname' => 'tf_unique'));
	$t->AddColumn (array ('displayname' => 'Order',
				'dataname' => 'tf_order'));
	$t->AddColumn (array ('displayname' => 'Actions',
				'dataname' => 'tf_msg'));
	if (is_valid_integer ($fid)) {
		$tftable = new TrapFilterDbTableClass ();
		$tftable->SetWhere ("tf_id = $fid");
		$pd = $tftable->GetPageData (1);
		$d = $pd[0];
		$d['tf_msg'] = stripslashes ($d['tf_msg']);
	} else {
		if (isset($filterdata) && is_array ($filterdata)) {
			$d = $filterdata;
		} else {
			$d = array ();
		}
	}
	#$fid = $row['tf_id'];
	$row = trapfilter_row_editable_render  ($d);
	$o = "<a href='?view=trapfilteredit&fid=$fid'>Edit</a>";
	if ($can_edit == 1) {
		$o .= "&nbsp<a href='?view=trapfilterdelete&fid=$fid'>Delete</a>";
	}
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if ($can_edit == 1) {
		if (is_valid_integer ($fid)) {
			print "<p align='left'><input type='submit' name='updatefilter' value='Update Filter'>";
		} else {
			print "<p align='left'><input type='submit' name='addfilter' value='Add Filter'>";
		}
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("trapfilteredit");
	if (is_valid_integer ($fid)) {
		print "<p>&nbsp</p>\n";
		display_trapfiltermatch_list ($fid);
	}
	return;
}


function trapfilter_row_editable_render ($row)
{
	$sev = $_SESSION['AlertSeverity'];
	$class = $_SESSION['AlertClass'];
	$o = array ();
	$o['tf_id'] = "<input type='text' name='tf_id' size='10' readonly value='" . $row['tf_id'] . "'>";
	$o['tf_name'] = "<input type='text' name='tf_name' size='60' value='" . $row['tf_name'] . "'>";
	$o['tf_desc'] = "<input type='text' name='tf_desc' size='60' value='" . $row['tf_desc'] . "'>";
	$o['tf_trapoid'] = "<input type='text' name='tf_trapoid' size='80' value='" . $row['tf_trapoid'] . "'>";
	$o['tf_class'] = html_select_button ('tf_class', $class, $class[$row['tf_class']]);
	$o['tf_severity'] = html_select_button ('tf_severity', $sev, $sev[$row['tf_severity']]);
	$o['tf_object'] = "<input type='text' name='tf_object' value='" . $row['tf_object'] . "'>";
	$o['tf_uniqueid'] = "<input type='text' name='tf_uniqueid' size='10' value='" . $row['tf_uniqueid'] . "'>";
	$o['tf_markrecover'] = "<input type='text' name='tf_markrecover' size='2' value='" . $row['tf_markrecover'] . "'>";
	$o['tf_unique'] = "<input type='text' name='tf_unique' size='10' value='" . $row['tf_unique'] . "'>";
	$o['tf_order'] = "<input type='text' name='tf_order' size='10' value='" . $row['tf_order'] . "'>";
	$o['tf_msg'] = "<input type='text' name='tf_msg' size='140' value='" . $row['tf_msg'] . "'>";
	return $o;
}


function delete_trapfilter ()
{
	$rcr = array (0, "");
	if (isset($_GET['fid']) && is_valid_integer ($_GET['fid'])) {
		$tftable = new TrapFilterDbTableClass ();
		$rcr = $tftable->DeleteRecordByPkey ($_GET['fid']);
	}
	return $rcr;
}


function clone_trapfilter ()
{
	$rcr = array (0, "");
	if (isset($_GET['fid']) && is_valid_integer ($_GET['fid'])) {
		$fid = $_GET['fid'];
		$tftable = new TrapFilterDbTableClass ();
		$tfmtable = new TrapFilterMatchDbTableClass ();
		### Clone the trapfilter ###
		$tftable->SetWhere ("tf_id = $fid");
		$tfd = $tftable->GetPageData (1);
		$d = $tfd[0];
		$d['tf_name'] .= "(copy)";	
		$d['tf_desc'] .= " (copy)";	
		$d['tf_order'] += 1000;	
		unset ($d['tf_id']);
		$rcr = $tftable->InsertRecord ($d);
		if ($rcr[0] != 0) {
			return $rcr;
		}
		$d = $tftable->PostInsertSetPkey ($d);
		$nfid = $d['tf_id'];
		### Clone the trapfiltermatch ###
		$tfmtable->SetWhere ("tfm_tf_id = $fid");
		$rows = $tfmtable->GetNumRows ();
		$tfmtable->SetPageRows ($rows);
		$d = $tfmtable->GetPageData (1);
		if (!is_array ($d)) {
			$d = array ();
		}
		foreach ($d as $tfm) {
			unset ($tfm['tfm_id']);
			$tfm['tfm_tf_id'] = $nfid;
			$rcr = $tfmtable->InsertRecord ($tfm);
			if ($rcr[0] != 0) {
				return $rcr;
			}
		}
	}
	return $rcr;
}


function display_trapfiltermatch_list ($tf_id)
{
	if (user_check_access_right ('AdminView')) {
		access_denied_page();
		return 1;
	}

	$can_edit = 0;
	if (!user_check_access_right ('AdminTrapEdit')) {
		$can_edit = 1;
	}

	if (!is_valid_integer ($tf_id)) {
		return 2;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Filter Matches");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'tfm_id'));
	$t->AddColumn (array ('displayname' => 'OID',
				'dataname' => 'tfm_oid'));
	$t->AddColumn (array ('displayname' => 'Comparator',
				'dataname' => 'tfm_comparator'));
	$t->AddColumn (array ('displayname' => 'Value',
				'dataname' => 'tfm_value'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$tfmtable = new TrapFilterMatchDbTableClass ();
	$tfmtable->SetWhere ("tfm_tf_id = $tf_id");
	$d = $tfmtable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$fmid = $row['tfm_id'];
		$o = "<a href='?view=trapfiltermatchedit&fmid=$fmid'>Edit</a>";
		if ($can_edit == 1) {
			$o .= "&nbsp<a href='?view=trapfiltermatchdelete&fmid=$fmid'>Delete</a>";
		}
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	if ($can_edit == 1) {
		print "<p align='left'><input type='submit' name='addfiltermatch' value='Add Filter Match'>";
	}
	print "</form>";
	return;
}


function trapfiltermatch_row_editable_render ($row)
{
	$comparator = array ("", "=", "!=", ">", ">=", "<", "<=", "regex", "!regex");
	$o = array ();
	$o['tfm_id'] = "<input type='text' name='tfm_id' size='10' readonly value='" . $row['tfm_id'] . "'>";
	$o['tfm_oid'] = "<input type='text' name='tfm_oid' size='64' value='" . $row['tfm_oid'] . "'>";
	$o['tfm_comparator'] = html_select_button ('tfm_comparator', $comparator, $row['tfm_comparator']);
	$o['tfm_value'] = "<input type='text' name='tfm_value' size='64' value='" . $row['tfm_value'] . "'>";
	return $o;
}



function display_trapfiltermatch ($filterdata, $errors)
{
	if (user_check_access_right ('AdminView')) {
		access_denied_page();
		return 1;
	}

	$can_edit = 0;
	if (!user_check_access_right ('AdminTrapEdit')) {
		$can_edit = 1;
	}

	$comparator = array ("", "=", "!=", ">", ">=", "<", "<=", "regex", "!regex");

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	$fid = $_SESSION['tf_id'];
	print "<b><a href='?view=trapfilteredit&fid=$fid'>Back To Filter</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['fmid']) && is_valid_integer ($_GET['fmid'])) {
			$fmid = $_GET['fmid'];
			$_SESSION['tfm_id'] = $fmid;
		} else {
			unset ($_SESSION['tfm_id']);
		}
	} else {
		if (isset ($_POST['addfiltermatch'])) {
			if (isset ($filterdata)) {
				$fmid = $filterdata['tfm_id'];
			}
		} else if (isset ($_POST['updatefiltermatch'])) {
				$fmid = $_SESSION['tfm_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($fmid)) {
		$title = "Filter Match (New)";
	} else {
		$title = "Filter Match (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'tfm_id'));
	$t->AddColumn (array ('displayname' => 'OID',
				'dataname' => 'tfm_oid'));
	$t->AddColumn (array ('displayname' => 'Comparator',
				'dataname' => 'tfm_comparator'));
	$t->AddColumn (array ('displayname' => 'Value',
				'dataname' => 'tfm_value'));
	if (is_valid_integer ($fmid)) {
		$tfmtable = new TrapFilterMatchDbTableClass ();
		$tfmtable->SetWhere ("tfm_id = $fmid");
		$pd = $tfmtable->GetPageData (1);
		$d = $pd[0];
	} else {
		if (isset($filterdata)) {
			$d = $filterdata;
		} else {
			$d = array ();
		}
	}
	#$fid = $row['tf_id'];
	$row = trapfiltermatch_row_editable_render  ($d);
	if ($can_edit == 1) {
		$o = "<a href='?view=trapfiltermatchedit&fmid=$fmid'>Edit</a>";
		$o .= "&nbsp<a href='?view=trapfiltermatchdelete&fmid=$fmid'>Delete</a>";
	}
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if ($can_edit == 1) {
		if (is_valid_integer ($fmid)) {
			print "<p align='left'><input type='submit' name='updatefiltermatch' value='Update Filter Match'>";
		} else {
			print "<p align='left'><input type='submit' name='addfiltermatch' value='Add Filter Match'>";
		}
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("trapfiltermatchedit");
	return;
}


function delete_trapfiltermatch ()
{
	$rcr = array (0, "");
	if (isset($_GET['fmid']) && is_valid_integer ($_GET['fmid'])) {
		$tfmtable = new TrapFilterMatchDbTableClass ();
		$rcr = $tfmtable->DeleteRecordByPkey ($_GET['fmid']);
	}
	return $rcr;
}


function display_alertrule_list ()
{
	if (user_check_access_right ('Admin')) {
		access_denied_page();
		return 1;
	}

	$truefalse = array ("False", "True");

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Alert Rule");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'ar_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'ar_name'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'ar_desc'));
	$t->AddColumn (array ('displayname' => 'Active',
				'dataname' => 'ar_active'));
	$t->AddColumn (array ('displayname' => 'Order',
				'dataname' => 'ar_order'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$artable = new AlertRuleDbTableClass ();
	$d = $artable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$ar_id = $row['ar_id'];
		$row['ar_active'] = $truefalse[$row['ar_active']];
		$o = "<a href='?view=alertruleedit&ar_id=$ar_id'>Edit</a>";
		$o .= "&nbsp<a href='?view=alertruledelete&ar_id=$ar_id'>Delete</a>";
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p><input type='submit' name='addalertrule' value='Add Rule'>";
	print "</form>";
	session_set_page ("alertrulelist");
	return;
}


function display_alertrule ($ardata, $errors)
{
	if (user_check_access_right ('Admin')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	print "<b><a href='?view=alertrulelist'>Alert Rule List</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['ar_id']) && is_valid_integer ($_GET['ar_id'])) {
			$ar_id = $_GET['ar_id'];
			$_SESSION['ar_id'] = $ar_id;
		} else {
			unset ($_SESSION['ar_id']);
		}
	} else {
		if (isset ($_POST['addalertrule'])) {
			if (isset ($ardata)) {
				$ar_id = $ardata['ar_id'];
			}
		} else if (isset ($_POST['updatealertrule'])) {
				$ar_id = $_SESSION['ar_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($ar_id)) {
		$title = "Alert Rule (New)";
	} else {
		$title = "Alert Rule (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'ar_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'ar_name'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'ar_desc'));
	$t->AddColumn (array ('displayname' => 'Active',
				'dataname' => 'ar_active'));
	$t->AddColumn (array ('displayname' => 'Order',
				'dataname' => 'ar_order'));
	if (is_valid_integer ($ar_id)) {
		$artable = new AlertRuleDbTableClass ();
		$artable->SetWhere ("ar_id = $ar_id");
		$pd = $artable->GetPageData (1);
		$d = $pd[0];
	} else {
		if (isset($ardata)) {
			$d = $ardata;
		} else {
			$d = array ();
		}
	}
	$row = alertrule_row_editable_render  ($d);
	$o = "<a href='?view=alertruleedit&ar_id=$ar_id'>Edit</a>";
	$o .= "&nbsp<a href='?view=alertruledelete&ar_id=$ar_id'>Delete</a>";
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($ar_id)) {
		print "<p align='left'><input type='submit' name='updatealertrule' value='Update Rule'>";
	} else {
		print "<p align='left'><input type='submit' name='addalertrule' value='Add Rule'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("alertruleedit");
	if (is_valid_integer ($ar_id)) {
		print "<p>&nbsp</p>\n";
		display_alertrulematch_list ($ar_id);
	}
	return;
}


function alertrule_row_editable_render ($row)
{
	#$comparator = array ("", "=", "!=", ">", ">=", "<", "<=", "regex", "!regex");
	$truefalse = array ("False", "True");
	$o = array ();
	$o['ar_id'] = "<input type='text' name='ar_id' size='10' readonly value='" . $row['ar_id'] . "'>";
	$o['ar_name'] = "<input type='text' name='ar_name' size='32' value='" . $row['ar_name'] . "'>";
	$o['ar_desc'] = "<input type='text' name='ar_desc' size='64' value='" . $row['ar_desc'] . "'>";
	$o['ar_active'] = html_select_button ('ar_active', $truefalse, $truefalse[$row['ar_active']]);
	$o['ar_order'] = "<input type='text' name='ar_order' size='5' value='" . $row['ar_order'] . "'>";
	return $o;
}


function display_contact_list ()
{
	if (user_check_access_right ('AdminOncallEdit')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Contacts");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'c_group'));
	$t->AddColumn (array ('displayname' => 'Work#',
				'dataname' => 'c_workphone'));
	$t->AddColumn (array ('displayname' => 'Cell#',
				'dataname' => 'c_cellphone'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$ctable = new ContactDbTableClass ();
	$rcr = $ctable->SetOrderBy ("c_username asc");
	$ctable->SetPageRows (75);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$c_id = $row['c_id'];
		$o = "<a href='?view=contactedit&c_id=$c_id'>Edit</a>";
		$o .= "&nbsp<a href='?view=contactdelete&c_id=$c_id'>Delete</a>";
		#$o .= "&nbsp<a href='?view=contactclone&c_id=$c_id'>Clone</a>";
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p><input type='submit' name='addcontact' value='Add Contact'>";
	print "</form>";
	session_set_page ("contactlist");
	return;
}


function display_contact ($cdata, $errors)
{
	if (user_check_access_right ('AdminOncallEdit')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	print "<b><a href='?view=contactlist'>Contact List</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['c_id']) && is_valid_integer ($_GET['c_id'])) {
			$c_id = $_GET['c_id'];
			$_SESSION['c_id'] = $c_id;
		} else {
			unset ($_SESSION['c_id']);
		}
	} else {
		if (isset ($_POST['addcontact'])) {
			if (isset ($cdata)) {
				$c_id = $cdata['c_id'];
			}
		} else if (isset ($_POST['updatecontact'])) {
				$c_id = $_SESSION['c_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($c_id)) {
		$title = "Contact (New)";
	} else {
		$title = "Contact (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Email',
				'dataname' => 'c_email'));
	$t->AddColumn (array ('displayname' => 'Work Phone',
				'dataname' => 'c_workphone'));
	$t->AddColumn (array ('displayname' => 'Cell Phone',
				'dataname' => 'c_cellphone'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'c_group'));
	if (is_valid_integer ($c_id)) {
		$ctable = new ContactDbTableClass ();
		$ctable->SetWhere ("c_id = $c_id");
		$pd = $ctable->GetPageData (1);
		$d = $pd[0];
	} else {
		if (isset($cdata)) {
			$d = $cdata;
		} else {
			$d = array ();
		}
	}
	$row = contact_row_editable_render  ($d);
	$o = "<a href='?view=contactedit&c_id=$c_id'>Edit</a>";
	$o .= "&nbsp<a href='?view=contactdelete&c_id=$c_id'>Delete</a>";
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($c_id)) {
		print "<p align='left'><input type='submit' name='updatecontact' value='Update Contact'>";
	} else {
		print "<p align='left'><input type='submit' name='addcontact' value='Add Contact'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("contactedit");
	return;
}


function contact_row_editable_render ($row)
{
	$o = array ();
	$o['c_id'] = "<input type='text' name='c_id' size='10' readonly value='" . $row['c_id'] . "'>";
	$o['c_username'] = "<input type='text' name='c_username' size='64' value='" . $row['c_username'] . "'>";
	$o['c_name'] = "<input type='text' name='c_name' size='64' value='" . $row['c_name'] . "'>";
	$o['c_group'] = "<input type='text' name='c_group' size='32' value='" . $row['c_group'] . "'>";
	$o['c_email'] = "<input type='text' name='c_email' size='128' value='" . $row['c_email'] . "'>";
	$o['c_workphone'] = "<input type='text' name='c_workphone' size='20' value='" . $row['c_workphone'] . "'>";
	$o['c_cellphone'] = "<input type='text' name='c_cellphone' size='20' value='" . $row['c_cellphone'] . "'>";
	return $o;
}


function delete_contact ()
{
	$rcr = array (0, "");
	if (isset($_GET['c_id']) && is_valid_integer ($_GET['c_id'])) {
		$ctable = new ContactDbTableClass ();
		$rcr = $ctable->DeleteRecordByPkey ($_GET['c_id']);
	}
	return $rcr;
}


function display_oncall_schedule_list ()
{
	if (user_check_access_right ('AdminOncallEdit')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Oncall Schedule");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'os_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'os_group'));
	$t->AddColumn (array ('displayname' => 'Level',
				'dataname' => 'os_level'));
	$t->AddColumn (array ('displayname' => 'Start Date/Time',
				'dataname' => 'os_starttime'));
	$t->AddColumn (array ('displayname' => 'End Date/Time',
				'dataname' => 'os_endtime'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));

	$d = array ();
	$sql = "select os_id,c_username,os_group,os_level,os_starttime,os_endtime";
	$sql .= " from oncall_schedule, contact";
	$sql .= " where c_id = os_c_id";
	$sql .= " order by os_starttime desc";
	$sql .= " limit 50";
	$result = mysql_query ($sql);
	if ($result) {
		while ($row = mysql_fetch_assoc ($result)) {
			$d[] = $row;
		}
		mysql_free_result ($result);
	} else {
		print "<p>SQL failure: sql='$sql'</p>";
	}

	$td = array ();
	foreach ($d as $row) {
		$os_id = $row['os_id'];
		$o = "<a href='?view=oncallscheduleedit&os_id=$os_id'>Edit</a>";
		$o .= "&nbsp<a href='?view=oncallscheduledelete&os_id=$os_id'>Delete</a>";
		#$o .= "&nbsp<a href='?view=oncallscheduleclone&os_id=$os_id'>Clone</a>";
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p><input type='submit' name='addoncallschedule' value='Add Oncall Schedule'>";
	print "</form>";
	session_set_page ("oncallschedulelist");
	return;
}


function display_oncall_schedule ($cdata, $errors)
{
	if (user_check_access_right ('AdminOncallEdit')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr>";
	print "<td class='hostTitle'><b><a href='?view=oncallcalendar'>Oncall Calendar</a></b></td>";
	print "<td class='hostTitle'><b><a href='?view=oncallschedulelist'>Oncall Schedule</a></b></td>";
	print "></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['os_id']) && is_valid_integer ($_GET['os_id'])) {
			$os_id = $_GET['os_id'];
			$_SESSION['os_id'] = $os_id;
		} else {
			unset ($_SESSION['os_id']);
		}
	} else {
		if (isset ($_POST['addoncallschedule'])) {
			if (isset ($cdata)) {
				$os_id = $cdata['os_id'];
			}
		} else if (isset ($_POST['updateoncallschedule'])) {
				$os_id = $_SESSION['os_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($os_id)) {
		$title = "Oncall Schedule (New)";
	} else {
		$title = "Oncall Schedule (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'os_id'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'os_group'));
	$t->AddColumn (array ('displayname' => 'Contact',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Level',
				'dataname' => 'os_level'));
	$t->AddColumn (array ('displayname' => 'Start Date/Time',
				'dataname' => 'os_starttime'));
	$t->AddColumn (array ('displayname' => 'End Date/Time',
				'dataname' => 'os_endtime'));
	if (is_valid_integer ($os_id)) {
		$sql = "select os_id,c_username,os_group,os_level,os_starttime,os_endtime";
		$sql .= " from oncall_schedule, contact";
		$sql .= " where c_id = os_c_id";
		$sql .= " and os_id = $os_id";
		$result = mysql_query ($sql);
		if ($result) {
			if ($row = mysql_fetch_assoc ($result)) {
				$d = $row;
			} else {
				$d = array ();
			}
			mysql_free_result ($result);
		} else {
			print "<p>SQL failure: sql='$sql'</p>";
		}
		#$ostable = new OncallScheduleDbTableClass ();
		#$ostable->SetWhere ("os_id = $os_id");
		#$pd = $ostable->GetPageData (1);
		#$d = $pd[0];
	} else {
		if (isset($cdata)) {
			$d = $cdata;
		} else {
			$d = array ();
		}
	}
	$row = oncall_schedule_row_editable_render  ($d);
	$o = "<a href='?view=oncallscheduleedit&os_id=$os_id'>Edit</a>";
	$o .= "&nbsp<a href='?view=oncallscheduledelete&os_id=$os_id'>Delete</a>";
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($os_id)) {
		print "<p align='left'><input type='submit' name='updateoncallschedule' value='Update Oncall Schdule'>";
	} else {
		print "<p align='left'><input type='submit' name='addoncallschedule' value='Add Oncall Schedule'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("oncallscheduleedit");
	return;
}


function oncall_schedule_row_editable_render ($row)
{
	$o = array ();
	$o['os_id'] = "<input type='text' name='os_id' size='10' readonly value='" . $row['os_id'] . "'>";
	$o['c_username'] = "<input type='text' name='c_username' size='64' value='" . $row['c_username'] . "'>";
	$o['os_group'] = "<input type='text' name='os_group' size='32' value='" . $row['os_group'] . "'>";
	$o['os_level'] = "<input type='text' name='os_level' size='3' value='" . $row['os_level'] . "'>";
	$o['os_starttime'] = "<input type='text' name='os_starttime' size='20' value='" . $row['os_starttime'] . "'>";
	$o['os_endtime'] = "<input type='text' name='os_endtime' size='20' value='" . $row['os_endtime'] . "'>";
	return $o;
}


function delete_oncall_schedule ()
{
	$rcr = array (0, "");
	if (isset($_GET['os_id']) && is_valid_integer ($_GET['os_id'])) {
		$ostable = new OncallScheduleDbTableClass ();
		$rcr = $ostable->DeleteRecordByPkey ($_GET['os_id']);
	}
	return $rcr;
}


function display_oncall_calendar ()
{
	if (user_check_access_right ('AdminOncallEdit')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";

	$cal = new Calendar ();
	$cal->set_class_title ("hostTitle");
	$cal->set_class_table ("tableList");
	$cal->set_class_table_header ("hostHeader");
	$cal->set_id_day_blank ("calendarDayBlank");
	$cal->set_id_day_unused ("calendarDayUnused");
	$cal->set_id_day_current ("calendarDayCurrent");

	if (isset ($_GET['month']) && isset ($_GET['year'])) {
		if (is_valid_integer ($_GET['month'])
			&& $_GET['month'] >= 1
			&& $_GET['month'] <= 12) {
			$month = $_GET['month'];
		}
		if (is_valid_integer ($_GET['year'])
			&& $_GET['year'] >= 1900) {
			$year = $_GET['year'];
		}
	} else {
		$lt = localtime (time (), TRUE);
		$month = $lt['tm_mon'] + 1;
		$year = $lt['tm_year'] + 1900;
	}
	
	$mt = mktime (0, 0, 0, $month, 1, $year);
	$month_days = date ("t", $mt);
	$month_name = date ("M", $mt);
	$cal->set_title ("$month_name $year");
	$data = array ();
	for ($i=1 ; $i<$month_days ; $i++) {
		$d = sprintf ("%04d-%02d-%02d", $year, $month, $i);
		$sql = "select os_id,c_username,os_level,os_group,os_starttime";
		$sql .= " from contact,oncall_schedule";
		$sql .= " where c_id = os_c_id";
		$sql .= " and date(os_starttime) <= '$d'";
		$sql .= " and date(os_endtime) >= '$d'";
		$sql .= " and dayofmonth(os_endtime) != $i";
		$sql .= " order by os_level,os_starttime asc";
		$result = mysql_query ($sql);
		if ($result) {
			$d = "";
			while ($row = mysql_fetch_assoc ($result)) {
				$d .= "<a href='" . $_SERVER['PHP_SELF'] . "?view=oncallscheduleedit&os_id=" . $row['os_id'] . "'>";
				$d .= $row['os_group'] . ":" . $row['c_username'] . " - Level " . $row['os_level'];
				$d .= "</a><br>";
				$data[$i] = $d;
			}
			mysql_free_result ($result);
		}
	}
	$py = $year;
	$pm = $month - 1;
	if ($pm == 0) {
		$pm = 12;
		$py -= 1;
	}
	$ny = $year;
	$nm = $month + 1;
	if ($nm == 13) {
		$nm = 1;
		$ny += 1;
	}
	$data['_backward_link'] = $_SERVER['PHP_SELF'] . "?view=oncallcalendar&year=$py&month=$pm";
	$data['_forward_link'] = $_SERVER['PHP_SELF'] . "?view=oncallcalendar&year=$ny&month=$nm";
	$cal->render_small ($month, $year, $data);
	print "</form>";
	session_set_page ("trapfilterlist");
	return;
}



/*
 * client/clientprocess handling functions
*/
function display_client_list ()
{
	if (user_check_access_right ('AdminClientEdit')) {
		access_denied_page();
		return 1;
	}

	$truefalse = array (0 => 'False', 1 => 'True');

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Clients");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Symbol',
				'dataname' => 'c_symbol'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Active',
				'dataname' => 'c_active'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$ctable = new ClientDbTableClass ();
	$rcr = $ctable->SetOrderBy ("c_symbol asc");
	$ctable->SetPageRows (120);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$cid = $row['c_id'];
		$row['c_active'] = $truefalse[$row['c_active']];
		$o = "<a href='?view=clientedit&cid=$cid'>Edit</a>";
		$o .= "&nbsp<a href='?view=clientdelete&cid=$cid'>Delete</a>";
		$o .= "&nbsp<a href='?view=clientclone&cid=$cid'>Clone</a>";
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p><input type='submit' name='addclient' value='Add Client'>";
	print "</form>";
	session_set_page ("clientlist");
	return;
}


function display_client ($filterdata, $errors)
{
	if (user_check_access_right ('AdminClientEdit')) {
		access_denied_page();
		return 1;
	}

	$truefalse = array (0 => 'False', 1 => 'True');

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	print "<b><a href='?view=clientlist'>Client List</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['cid']) && is_valid_integer ($_GET['cid'])) {
			$cid = $_GET['cid'];
			$_SESSION['c_id'] = $cid;
		} else {
			unset ($_SESSION['c_id']);
		}
	} else {
		if (isset ($_POST['addclient'])) {
			if (isset ($filterdata) && isset ($filterdata['c_id'])) {
				$cid = $filterdata['c_id'];
			}
		} else if (isset ($_POST['updateclient'])) {
				$cid = $_SESSION['c_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($cid)) {
		$title = "Client (New)";
	} else {
		$title = "Client (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Symbol',
				'dataname' => 'c_symbol'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Active',
				'dataname' => 'c_active'));
	if (is_valid_integer ($cid)) {
		$ctable = new ClientDbTableClass ();
		$ctable->SetWhere ("c_id = $cid");
		$pd = $ctable->GetPageData (1);
		$d = $pd[0];
		$d['c_name'] = stripslashes ($d['c_name']);
	} else {
		if (isset($filterdata) && is_array ($filterdata)) {
			$d = $filterdata;
		} else {
			$d = array ();
		}
	}
	$row = client_row_editable_render  ($d);
	$o = "<a href='?view=clientedit&cid=$cid'>Edit</a>";
	$o .= "&nbsp<a href='?view=clientdelete&cid=$cid'>Delete</a>";
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($cid)) {
		print "<p align='left'><input type='submit' name='updateclient' value='Update Client'>";
	} else {
		print "<p align='left'><input type='submit' name='addclient' value='Add Client'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("clientedit");
	if (is_valid_integer ($cid)) {
		print "<p>&nbsp</p>\n";
		display_clientprocess_list ($cid);
	}
	return;
}


function client_row_editable_render ($row)
{
	$truefalse = array (0 => 'False', 1 => 'True');
	$o = array ();
	$o['c_id'] = "<input type='text' name='c_id' size='10' readonly value='" . $row['c_id'] . "'>";
	$o['c_symbol'] = "<input type='text' name='c_symbol' size='8' value='" . $row['c_symbol'] . "'>";
	$o['c_name'] = "<input type='text' name='c_name' size='64' value='" . $row['c_name'] . "'>";
	$o['c_active'] = html_select_button ('c_active', $truefalse, $truefalse[$row['c_active']]);
	return $o;
}


function delete_client ()
{
	$rcr = array (0, "");
	if (isset($_GET['cid']) && is_valid_integer ($_GET['cid'])) {
		$ctable = new ClientDbTableClass ();
		$rcr = $ctable->DeleteRecordByPkey ($_GET['cid']);
	}
	return $rcr;
}


function clone_client ()
{
	$rcr = array (0, "");
	if (isset($_GET['cid']) && is_valid_integer ($_GET['cid'])) {
		$cid = $_GET['cid'];
		$ctable = new ClientDbTableClass ();
		$cptable = new ClientProcessDbTableClass ();
		### Clone the client ###
		$ctable->SetWhere ("c_id = $cid");
		$cd = $ctable->GetPageData (1);
		$d = $cd[0];
		$d['c_symbol'] .= "(copy)";	
		$d['c_name'] .= " (copy)";	
		unset ($d['c_id']);
		$rcr = $ctable->InsertRecord ($d);
		if ($rcr[0] != 0) {
			return $rcr;
		}
		$d = $ctable->PostInsertSetPkey ($d);
		$ncid = $d['c_id'];
		### Clone the clientprocess ###
		$cptable->SetWhere ("cp_c_id = $cid");
		$rows = $cptable->GetNumRows ();
		$cptable->SetPageRows ($rows);
		$d = $cptable->GetPageData (1);
		if (!is_array ($d)) {
			$d = array ();
		}
		foreach ($d as $cp) {
			unset ($cp['cp_id']);
			$cp['cp_c_id'] = $ncid;
			$rcr = $cptable->InsertRecord ($cp);
			if ($rcr[0] != 0) {
				return $rcr;
			}
		}
	}
	return $rcr;
}


function display_clientprocess_list ($c_id)
{
	if (user_check_access_right ('AdminClientEdit')) {
		access_denied_page();
		return 1;
	}

	if (!is_valid_integer ($c_id)) {
		return 2;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Client Processes");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'cp_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'cp_name'));
	$t->AddColumn (array ('displayname' => 'Object',
				'dataname' => 'cp_object'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'cp_desc'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$cptable = new ClientProcessDbTableClass ();
	$cptable->SetWhere ("cp_c_id = $c_id");
	$d = $cptable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$cpid = $row['cp_id'];
		$o = "<a href='?view=clientprocessedit&cpid=$cpid'>Edit</a>";
		$o .= "&nbsp<a href='?view=clientprocessdelete&cpid=$cpid'>Delete</a>";
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	print "<p align='left'><input type='submit' name='addclientprocess' value='Add Client Process'>";
	print "</form>";
	return;
}


function clientprocess_row_editable_render ($row)
{
	$o = array ();
	$o['cp_id'] = "<input type='text' name='cp_id' size='10' readonly value='" . $row['cp_id'] . "'>";
	$o['cp_name'] = "<input type='text' name='cp_name' size='64' value='" . $row['cp_name'] . "'>";
	$o['cp_object'] = "<input type='text' name='cp_object' size='64' value='" . $row['cp_object'] . "'>";
	$o['cp_desc'] = "<input type='text' name='cp_desc' size='64' value='" . $row['cp_desc'] . "'>";
	return $o;
}



function display_clientprocess ($filterdata, $errors)
{
	if (user_check_access_right ('AdminClientEdit')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	$cid = $_SESSION['c_id'];
	print "<b><a href='?view=clientedit&cid=$cid'>Back To Client</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['cpid']) && is_valid_integer ($_GET['cpid'])) {
			$cpid = $_GET['cpid'];
			$_SESSION['cp_id'] = $cpid;
		} else {
			unset ($_SESSION['cp_id']);
		}
	} else {
		if (isset ($_POST['addclientprocess'])) {
			if (isset ($filterdata)) {
				$cpid = $filterdata['cp_id'];
			}
		} else if (isset ($_POST['updateclientprocess'])) {
				$cpid = $_SESSION['cp_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($cpid)) {
		$title = "Client Process (New)";
	} else {
		$title = "Client Process (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'cp_id'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'cp_name'));
	$t->AddColumn (array ('displayname' => 'Object',
				'dataname' => 'cp_object'));
	$t->AddColumn (array ('displayname' => 'Description',
				'dataname' => 'cp_desc'));
	if (is_valid_integer ($cpid)) {
		$cptable = new ClientProcessDbTableClass ();
		$cptable->SetWhere ("cp_id = $cpid");
		$pd = $cptable->GetPageData (1);
		$d = $pd[0];
	} else {
		if (isset($filterdata)) {
			$d = $filterdata;
		} else {
			$d = array ();
		}
	}
	$row = clientprocess_row_editable_render  ($d);
	$o = "<a href='?view=clientprocessedit&cpid=$cpid'>Edit</a>";
	$o .= "&nbsp<a href='?view=clientprocessdelete&cpid=$cpid'>Delete</a>";
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($cpid)) {
		print "<p align='left'><input type='submit' name='updateclientprocess' value='Update Client Process'>";
	} else {
		print "<p align='left'><input type='submit' name='addclientprocess' value='Add Client Process'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("clientprocessedit");
	return;
}


function delete_clientprocess ()
{
	$rcr = array (0, "");
	if (isset($_GET['cpid']) && is_valid_integer ($_GET['cpid'])) {
		$cptable = new ClientProcessDbTableClass ();
		$rcr = $cptable->DeleteRecordByPkey ($_GET['cpid']);
	}
	return $rcr;
}










?>


