<?php
/*
 * calendar.class.inc - Calendar class source file
 *
 * (c) 2009 Todd Shadburn
 *
 * Licensed under the GNU GPL version 2
 *
*/


class Calendar
{
	var $classDiv;
	var $classTable;
	var $idTableRow;
	var $idTableHeader;
	var $idBlankDay;
	var $idUnusedDay;
	var $idCurrentDay;
	var $month;
	var $year;
	var $title;
	var $classTitle;


function set_title ($name)
{
	$this->title = $name;
	return;
}


function set_class_title ($name)
{
	$this->classTitle = $name;
	return;
}


function set_class_table ($name)
{
	$this->classTable = $name;
	return;
}


function set_id_table_row ($name)
{
	$this->idTableRow = $name;
	return;
}


function set_class_table_header ($name)
{
	$this->classTableHeader = $name;
	return;
}


function set_id_day_blank ($name)
{
	$this->idBlankDay = $name;
	return;
}


function set_id_day_unused ($name)
{
	$this->idUnusedDay = $name;
	return;
}


function set_id_day_current ($name)
{
	$this->idCurrentDay = $name;
	return;
}


function render_small($month, $year, $data)
{
	print "<table class='$this->classTable'>\n";

	$mt = mktime (0, 0, 0, $month, 1, $year);
	$wd_first = date ("w", $mt);
	$month_days = date ("t", $mt);
	$inmonth = 0;

	# Title row
	print "<tr>\n";
	print "<td class='$this->classTitle' colspan='7'><center>";
	if (isset ($data['_backward_link'])) {
		print "<a href='" . $data['_backward_link'] . "'>&lt</a>";
	}
	print $this->title;
	if (isset ($data['_forward_link'])) {
		print "<a href='" . $data['_forward_link'] . "'>&gt</a>";
	}
	print "</center></td>\n";
	print "</tr>\n";

	# Header row
	print "<tr>\n";
	print "<th class='$this->classTableHeader'>S</th>\n";
	print "<th class='$this->classTableHeader'>M</th>\n";
	print "<th class='$this->classTableHeader'>T</th>\n";
	print "<th class='$this->classTableHeader'>W</th>\n";
	print "<th class='$this->classTableHeader'>T</th>\n";
	print "<th class='$this->classTableHeader'>F</th>\n";
	print "<th class='$this->classTableHeader'>S</th>\n";
	print "</tr>\n";

	$day = 1;
	while ($day <= $month_days) {
		print "<tr id='$this->idTableRow'>\n";

		for ($wd=0 ; $wd<7 ; $wd++) {
			if (!$inmonth) {
				if ($wd == $wd_first) {
					$inmonth = 1;
				} else {
					print "<td id='$this->idUnusedDay'>";
					print "&nbsp</td>\n";
				}
			}
			if ($inmonth) {
				if ($day <= $month_days) {
					if (!isset($data[$day])) {
						$data[$day] = "&nbsp";
					}
					print "<td id='$this->idBlankDay' style='vertical-align:top'>";
					print "<div style='position:relative;'><b>$day</b></div>";
					print "<div style='position:relative;'>" . $data[$day] . "</div>";
					print "</td>\n";
					$day++;
				} else {
					$inmonth = 0;
					print "<td id='$this->idUnusedDay'>";
					print "&nbsp</td>\n";
				}
			}
		}

		print "</tr>\n";
	}

	print "</table>\n";
	return;
}


} //class

?>
