<?php
/*
 * client-status.php - client status source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';
include 'html.table.class.inc';

include 'alertdata.dbtable.class.inc';
include 'client.dbtable.class.inc';
include 'clientprocess.dbtable.class.inc';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (300);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

display_navmenu ();
if (user_check_access_right ('ClientView')) {
	access_denied_page();
	return 1;
}

$pagemenu = array ( 'clientlist' => 'Client_Overview'
		);
render_page_menu ($pagemenu);

/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if ($_GET['view'] == "") {
		display_client_list_2 ();

	} else if ($_GET['view'] == "clientlist") {
		display_client_list_2 ();

	} else if ($_GET['view'] == "clientoverview") {
		display_client_overview ();

	} else if ($_GET['view'] == "clientprocessdetail") {
		display_client_process_detail ();

/*
	} else if ($_GET['view'] == "trapfilterlist") {
		unset ($_SESSION['tf_id']);
		display_trapfilter_list ();

	} else if ($_GET['view'] == "trapfilteredit") {
		display_trapfilter ("", "");
*/
	} else {
		print "<tr><td><font color='white'><h4>";
		print "This page is not finished yet.</h4></font></td></td>";
		#session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	} else if ($_SESSION['page'] == "clientlist") {
			display_client_list ();

	} else if ($_SESSION['page'] == "clientoverview") {
			display_client_overview ();

/*
	} else if ($_SESSION['page'] == "trapfilteredit") {
		$sevid = $_SESSION['AlertSeverityId'];
		$classid = $_SESSION['AlertClassId'];
		$tftable = new TrapFilterDbTableClass ();
		$data = $tftable->OnlyColumns ($_POST);
		$data['tf_class'] = $classid[$data['tf_class']];
		$data['tf_severity'] = $sevid[$data['tf_severity']];
		if (isset ($_POST['addfilter'])) {
			unset ($data['tf_id']);
			$rcr = $tftable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $tftable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $tftable->PostInsertSetPkey ($data);
					$_SESSION['tf_id'] = $data['tf_id'];
				}
			}
			display_trapfilter ($data, $rcr);
		} else if (isset ($_POST['updatefilter']) && isset ($_SESSION['tf_id'])) {
			if ($_SESSION['tf_id'] != $_POST['tf_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $tftable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $tftable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['tf_id'] = $data['tf_id'];
					}
				}
			}
			display_trapfilter ($data, $rcr);

		} else if (isset ($_POST["addfiltermatch"])) {
			display_trapfiltermatch ();

		} else {
			display_trapfilter ();
		}
*/
	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";

/*** Free resources */
mysql_close ($conn);

return 0;


/************************************************************************/
/* Render the ClientList page						*/
/************************************************************************/
function display_client_list ()
{
	if (user_check_access_right ('ClientView')) {
		access_denied_page();
		return 1;
	}

	print "<tr><td>\n";
	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";

	$dt = new HtmlTableClass ();
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'label'));
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'field'));
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'button'));
	$td = array ();
	$td[] = array ('label' => "<font color='white'>Date:</font>",
			'field' => "<input type='text' size='10' name='client_process_date' value=''>",
			'button' => "<input type='submit' name='b_client_data' value='Go'>");
	$dt->Render ($td);
	print "</form>";
	print "</td></tr>\n";

	print "<tr><td>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Client Status");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$ctable = new ClientDbTableClass ();
	$rcr = $ctable->SetOrderBy ("c_name asc");
	$ctable->SetPageRows (75);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$cid = $row['c_id'];
		$o = "<a href='?view=clientoverview&cid=$cid'>" . $row['c_name'] . "</a>";
		$row['c_name'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	session_set_page ("clientlist");
	return;
}


/************************************************************************/
/* Render the ClientList page						*/
/************************************************************************/
function display_client_list_2 ()
{
	if (user_check_access_right ('ClientView')) {
		access_denied_page();
		return 1;
	}

	/*** Alert Status Box ***/
	print "<tr>";
	print "<td align=left valign=top width=33%>";
	print "<TABLE CLASS='infoBox' BORDER=1 CELLSPACING=0 CELLPADDING=0>";
	print "<TR><TD CLASS='infoBox'>";
	print "<DIV CLASS='infoBoxTitle'>Current Status</DIV>";
	print "Last Updated: " . date("l, F j, Y g:i:s A T") . "<BR>";
	#print "Updated every 90 seconds<br>";
	print "</TD></TR>";
	print "</TABLE>";
	print "</td></tr>";

	# Display the Date form
	#print "<tr><td>\n";
	#print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	#$dt = new HtmlTableClass ();
	#$dt->AddColumn (array ('displayname' => '',
	#			'dataname' => 'label'));
	#$dt->AddColumn (array ('displayname' => '',
	#			'dataname' => 'field'));
	#$dt->AddColumn (array ('displayname' => '',
	#			'dataname' => 'button'));
	#$td = array ();
	#$td[] = array ('label' => "<font color='white'>Date:</font>",
	#		'field' => "<input type='text' size='10' name='client_process_date' value=''>",
	#		'button' => "<input type='submit' name='b_client_data' value='Go'>");
	#$dt->Render ($td);
	#print "</form>";
	#print "</td></tr>\n";

	# Display the client overview table
	print "<tr><td>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Client Status");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Name',
				'width' => 40,
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Date Roll',
				'width' => 150,
				'dataname' => 'c_dateroll'));
	$t->AddColumn (array ('displayname' => 'Daily Processing',
				'width' => 150,
				'dataname' => 'c_daily'));
	$ctable = new ClientDbTableClass ();
	$sql = "c_active = 1";
	$ctable->SetWhere ($sql);
	$rcr = $ctable->SetOrderBy ("c_name asc");
	$ctable->SetPageRows (75);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		# c_name
		$c_id = $row['c_id'];
		$o = "<a href='?view=clientoverview&cid=$c_id'>" . $row['c_name'] . "</a>";
		$row['c_name'] = $o;
		$row['_class_c_name'] = "grayStatus";
		$a = client_get_process_state_field ($c_id, 'dateroll');
		$row['c_dateroll'] = $a['content'];
		$row['_class_c_dateroll'] = $a['class'];
		$row['valign'] = "middle";
		$a = client_get_process_state_field ($c_id, 'daily');
		$row['c_daily'] = $a['content'];
		$row['_class_c_daily'] = $a['class'];
		$row['valign'] = "middle";
		$td[] = $row;
	}
	$t->Render ($td);

	session_set_page ("clientlist");
	return;
}


function client_get_process_state_field ($c_id, $cp_name)
{
	$a = array ();
	$sql = "select a_id,a_state,ad_type,ad_timestamp,ad_data,cp_desc";
	$sql .= " from alert,alert_data,client_process";
	$sql .= " where a_id = ad_a_id ";
	$sql .= " and a_object = cp_object";
	
	# added 2009-06-15 to limit the # of alert records
	$sql .= " and a_class = 6 ";

	# added 2009-06-18 to use the cp_latest_a_id field, which will use the alert.a_id unique index
	$sql .= " and a_id = cp_latest_a_id ";

	$sql .= " and cp_name = '$cp_name'";
	$sql .= " and cp_c_id = $c_id";

	#$sql .= " order by ad_timestamp desc limit 1";
	$sql .= " order by ad_id desc limit 1";

	$result = mysql_query ($sql);
	if ($result) {
		$row = mysql_fetch_assoc ($result);
		if ($row !== FALSE) {
			if ($row['ad_type'] == 4 || $row['ad_type'] == 20 || $row['ad_type'] == 30) {
				$row['class'] = 'greenStatus';
			} else if ($row['ad_type'] == 21 || $row['ad_type'] == 31) {
				$row['class'] = 'yellowStatus';
			} else if ($row['ad_type'] == 22 || $row['ad_type'] == 32) {
				$row['class'] = 'redStatus';
			}

			if ($row['a_state'] == 4 || $row['ad_type'] == 20) {
				$row['cp_desc'] = "Completed @ " . $row['ad_timestamp'];
				$row['class'] = 'greenStatus';
			} else if ($row['ad_type'] == 21) {
				$row['cp_desc'] = "Completed with warnings @ " . $row['ad_timestamp'];
				$row['class'] = 'yellowStatus';
			} else if ($row['a_state'] == 1 || $row['a_state'] == 2) {
				if ($row['ad_type'] == 22) {
					$row['cp_desc'] = "Failed";
					$row['class'] = 'redStatus';
				} else {
					$row['cp_desc'] = "Running";
					$row['class'] = 'blueStatus';
					if ($row['ad_type'] == 32) {
						$row['cp_desc'] .= " - <font color='#800000'>Last step failed</font>";
						#$row['cp_desc'] .= $row['ad_data'];
					}
				}
			} else if ($row['a_state'] == 5) {
					$row['cp_desc'] = "Awaiting next execution";
					$row['class'] = 'unknownStatus';
			}

			# Show a button
			$pref = $_SESSION['preferences'];
			$setname = $pref['icon_set'];
			$iconsets = $GLOBALS['icon_sets'];
			$icon = $iconsets[$setname];
			if (!is_array($icon)) {
				$icon = $iconsets['LED'];
				#$icon = array (
				#                'green' => 'led-green.png',
				#        'yellow' => 'led-yellow.png',
				#        'red' => 'led-red.png',
				#        'orange' => 'led-orange.png',
				#        'blue' => 'led-blue.png'
				#);

			}
			if ($row['class'] == 'greenStatus') {
				$row['cp_desc'] = "<a href='?view=clientprocessdetail&a_id=" .
							$row['a_id'] . "'><img border='0' src='" . 
							$icon['green'] . "'></a>&nbsp " . $row['cp_desc'];
			} else if ($row['class'] == 'yellowStatus') {
				$row['cp_desc'] = "<a href='?view=clientprocessdetail&a_id=" . 
							$row['a_id'] . "'><img border='0' src='" . 
							$icon['yellow'] . "'></a>&nbsp " . $row['cp_desc'];
			} else if ($row['class'] == 'redStatus') {
				$row['cp_desc'] = "<a href='?view=clientprocessdetail&a_id=" . 
							$row['a_id'] . "'><img border='0' src='" . 
							$icon['red'] . "'></a>&nbsp " . $row['cp_desc'];
			} else if ($row['class'] == 'blueStatus') {
				$row['cp_desc'] = "<a href='?view=clientprocessdetail&a_id=" . 
							$row['a_id'] . "'><img border='0' src='" . 
							$icon['blue'] . "'></a>&nbsp " . $row['cp_desc'];
			} else {
				$row['cp_desc'] = "<img src='" . $icon['orange'] . "'>&nbsp " . $row['cp_desc'];
			}
			$row['class'] = "grayStatus";
			
			$a = array ('content' => $row['cp_desc'],
					'class' => $row['class']);
		} else {
			$a = array ('content' => "<img src='" . $icon['orange'] . "'>&nbsp N/A",
				'class' => 'grayStatus');
		}
		mysql_free_result ($result);
	} else {
		$a = array ('content' => "<img src='" . $icon['orange'] . "'>&nbsp N/A",
				'class' => 'grayStatus');
	}
	return $a;
}


/************************************************************************/
/************************************************************************/
/* Render the ClientOverview page					*/
/************************************************************************/
function display_client_overview ()
{
	if (user_check_access_right ('ClientView')) {
		access_denied_page();
		return 1;
	}

	$cpd = "";
	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['cid']) && is_valid_integer ($_GET['cid'])) {
			$cid = $_GET['cid'];
			$_SESSION['c_id'] = $cid;
			$_SESSION['c_name'] = client_name_from_id ($cid);
		} else {
			unset ($_SESSION['c_id']);
			return;
		}
	} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		if (isset ($_POST['client_process_date']) && is_valid_date ($_POST['client_process_date'])) {
			$cpd = $_POST['client_process_date'];
			$cid = $_SESSION['c_id'];
		} else {
			unset ($_SESSION['c_id']);
			return;
		}
	}

	print "<tr><td>\n";
	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";

	# Client Data table
	$dt = new HtmlTableClass ();
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'label'));
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'field'));
	$dt->AddColumn (array ('displayname' => '',
				'dataname' => 'button'));
	$td = array ();
	$td[] = array ('label' => "<font color='white'>Date:</font>",
			'field' => "<input type='text' size='10' name='client_process_date' value='$cpd'>",
			'button' => "<input type='submit' name='b_client_data' value='Go'>");
	$dt->Render ($td);
	print "</form>";
	print "</td></tr>\n";

	# Client process status table
	print "<tr><td>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Client Process Status - " . $_SESSION['c_name']);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Name',
				'width' => 120,
				'dataname' => 'cp_name'));
	$t->AddColumn (array ('displayname' => 'Timestamp',
				'width' => 80,
				'dataname' => 'ad_timestamp'));
	$t->AddColumn (array ('displayname' => 'Latest Message',
				'width' => 500,
				'dataname' => 'ad_data'));

	# Get the list of client processes
	$ctable = new ClientProcessDbTableClass ();
	$sql = "cp_c_id = $cid";
	$ctable->SetWhere ($sql);
	$rcr = $ctable->SetOrderBy ("cp_name asc");
	$ctable->SetPageRows (75);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}

	$td = array ();
	foreach ($d as $cp) {
		$sql = "select a_id,ad_timestamp,ad_type,ad_data";
		$sql .= " from alert,alert_data,client_process";
		$sql .= " where a_id = ad_a_id";
		$sql .= " and a_object = cp_object";

		/* added 2009-06-15 to limit the # of alert records */
		$sql .= " and a_class = 6";
		
		# added 2009-06-25 to use the cp_latest_a_id field, which will use the alert.a_id unique index
		$sql .= " and a_id = cp_latest_a_id ";

		$sql .= " and cp_name = '" . $cp['cp_name'] . "'";
		$sql .= " and cp_c_id = $cid";
		if ($cpd != "") {
			$sql .= " and date(a_alerttime) = '$cpd'";
		}
		$sql .= " order by ad_timestamp desc limit 1";
		#print "<p><font color='white'>sql='$sql'</font></p>";
		$result = mysql_query ($sql);
		if ($result) {
			while ($row = mysql_fetch_assoc ($result)) {
				if ($row['ad_type'] == 4 || $row['ad_type'] == 20 || $row['ad_type'] == 30) {
					$classcolor = 'infoSeverity';
				} else if ($row['ad_type'] == 21 || $row['ad_type'] == 31) {
					$classcolor = 'warningSeverity';
				} else if ($row['ad_type'] == 22 || $row['ad_type'] == 32) {
					$classcolor = 'criticalSeverity';
				}
				$o = "<a href='?view=clientprocessdetail&a_id=" . $row['a_id'] . "'>" . $cp['cp_desc'] . "</a>";
				$alertlink = "<a href='/netinfo/netinfo.php?view=alertdetail&a_id=" . $row['a_id'] . "'>View Alert</a>";
				$td[] = array ('cp_name' => $o,
						'ad_timestamp' => $row['ad_timestamp'],
						'ad_data' => $row['ad_data'] . " (" . $alertlink . ")",
						'_class' => $classcolor);
			}
			mysql_free_result ($result);
		}
	}
	$t->Render ($td);

	session_set_page ("clientoverview");
	return;
}


/************************************************************************/
/* Render the ClientProcessDetail page					*/
/************************************************************************/
function display_client_process_detail ()
{
	$adtid = $_SESSION['AlertDataTypeId'];
		
	if (user_check_access_right ('ClientView')) {
		access_denied_page();
		return 1;
	}

	$cpd = "";
	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['a_id']) && is_valid_integer ($_GET['a_id'])) {
			$a_id = $_GET['a_id'];
			$_SESSION['a_id'] = $a_id;
		} else {
			unset ($_SESSION['a_id']);
			return;
		}
	} else {
		return 1;
	}


	# Client process Detail table
	print "<tr><td>";
	$t = new HtmlTableClass ();
	$title = "Client Process Detail - " . $_SESSION['c_name'] . " - " . client_process_description_from_alertid ($a_id);
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Type',
				'width' => 120,
				'dataname' => 'ad_type'));
	$t->AddColumn (array ('displayname' => 'Timestamp',
				'width' => 80,
				'dataname' => 'ad_timestamp'));
	$t->AddColumn (array ('displayname' => 'Message',
				'width' => 500,
				'dataname' => 'ad_data'));

	$adtable = new AlertDataDbTableClass ();
	$sql = "ad_a_id = $a_id and ad_type in (1,4,20,21,22,28,30,31,32,38)";
	$adtable->SetWhere ($sql);
	$rcr = $adtable->SetOrderBy ("ad_id desc");
	$adtable->SetPageRows (75);
	$d = $adtable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}

	$td = array ();
	foreach ($d as $row) {
		if ($row['ad_type'] == 4 || $row['ad_type'] == 20 || $row['ad_type'] == 30) {
			$row['_class'] = 'infoSeverity';
		} else if ($row['ad_type'] == 21 || $row['ad_type'] == 31) {
			$row['_class'] = 'warningSeverity';
		} else if ($row['ad_type'] == 22 || $row['ad_type'] == 32) {
			$row['_class'] = 'criticalSeverity';
		}
		$row['ad_type'] = $adtid[$row['ad_type']];
		$td[] = $row;
	}
	$t->Render ($td);

	print "</td></tr>\n";

	session_set_page ("clientprocessdetail");
	return 0;
}


function client_name_from_id ($clientid)
{
	if (!is_valid_integer ($clientid)) {
		return "";
	}
	# Get the client name
	$ctable = new ClientDbTableClass ();
	$sql = "c_id = $clientid";
	$ctable->SetWhere ($sql);
	$ctable->SetPageRows (1);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		return "";
	}
	$row = $d[0];
	return $row['c_name'];
}


function client_process_description_from_alertid ($alertid)
{
	if (!is_valid_integer ($alertid)) {
		return "";
	}
	# Get the client process description
	$sql = "select cp_desc";
	$sql .= " from client_process,alert";
	$sql .= " where cp_object = a_object";
	$sql .= " and a_id = $alertid";
	$result = mysql_query ($sql);
	if ($result) {
		$row = mysql_fetch_assoc ($result);
		$name = $row['cp_desc'];
		mysql_free_result ($result);
		return $name;
	}
	return "";
}


?>


