<?php
/*
 * common-functions.php - Common functions
*/

#include_once 'userattribute.dbtable.inc';

/************************************************************************/
/* session_error							*/
/************************************************************************/
function session_error ()
{
        if (isset ($_COOKIE[session_name ()])) {
                setcookie (session_name (), '', time () - 42000, '/');
        }
        session_destroy ();
        print "<p><font color='red'>";
        print "It seems that an error occured during the processing ";
        print "of your request. This session has been terminated. Sorry...";
        print "</p>";
        return;
}


/************************************************************************/
/* session_end								*/
/************************************************************************/
function session_end ()
{
        if (isset ($_COOKIE[session_name ()])) {
                setcookie (session_name (), '', time () - 42000, '/');
        }
        session_destroy ();
        return;
}


/************************************************************************/
/* session_set_page							*/
/************************************************************************/
function session_set_page ($page)
{
	$_SESSION['lastpage'] = $_SESSION['page'];
	$_SESSION['page'] = $page;
	return;
}


/************************************************************************/
/* session_get_previous_page						*/
/************************************************************************/
function session_get_previous_page ()
{
	return $_SESSION['lastpage'];
}


/************************************************************************/
/* display_logon							*/
/************************************************************************/
function display_logon ($errmsg)
{
	page_header (-1);
	print "<tr><td>&nbsp</td></tr>";
	print "<tr><td>&nbsp</td></tr>";
	print "<tr><td>&nbsp</td></tr>";
	print "<tr><td align='center' valign='center' width='100%' height='300'>";

	print "<p><table class='logonTable' border='0' cellspacing='0' cellpadding='0'><tr><td width='100%' align='center' valign='middle'>";
	print "<form method='POST' action='netinfo.php'>";
	print "<table border='1' cellspacing='2' cellpadding='2'>";
	print "<tr>";
	print "<td colspan='2' class='logonTitle' align='center'><p></p><h4>System Logon</h4></td>\n";
	print "</tr>";
	print "<tr>";
	print "<td class='hostTitle'>Username:</td>\n";
	print "<td class='hostTitle'><input tabindex='1' type='text' name='username' length='20'></td>\n";
	print "</tr>";
	print "<tr>";
	print "<td class='hostTitle'>Password:</td>\n";
	print "<td class='hostTitle'><input tabindex='2' type='password' name='password' length='20'></td>\n";
	print "</tr>";
	print "<tr>";
	print "<td><input type='submit' name='logon' value='Logon'></td>\n";
	print "</tr>";
	print "</table>";
	print "<p><font color='red'>" . $errmsg . "</font></p>";
	print "</form>";
	print "</td></tr></table></p>";
	print "</td></tr>";
	return;
}


/************************************************************************/
/* alert_action								*/
/************************************************************************/
function alert_action($aid, $actionmsg)
{
	$msg = htmlentities ($actionmsg);
	$sql = sprintf ("insert into alert_action (aa_a_id,aa_timestamp,aa_user,aa_info) values (%d,NOW(),'%s','%s')",
			$aid,
			$_SESSION['username'],
			$msg);
	$result = mysql_query ($sql);
	if ($result == FALSE) {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	return;
}


/************************************************************************/
/* Page Header								*/
/************************************************************************/
function page_header ($refresh)
{
	if (session_is_registered ('preferences')) {
		$pref = $_SESSION['preferences'];
		if (isset ($pref['alert_view_display_skin'])) {
			$skin = $pref['alert_view_display_skin'];
		} else {
			$skin = "TAC";
		}
	} else {
		$skin = "TAC";
	}
	if ($refresh == "") {
		$refresh = 120;
	}
	print "<html><head>\n";
	print "<LINK REL='stylesheet' TYPE='text/css' HREF='stylesheets/$skin/common.css'>\n";
	print "<LINK REL='stylesheet' TYPE='text/css' HREF='stylesheets/$skin/alerts.css'>\n";
	if ($refresh != -1) {
		print "<META HTTP-EQUIV=Refresh CONTENT='" . $refresh . "'>\n";
	}
	print "<title>Netinfo Console</title>\n";
	print "</head>\n";
	print "<body class='pageBody'>\n";
	print "<table class='pageTable'>\n";
	return;
}


/************************************************************************/
/* Handle Authentication Attempt					*/
/************************************************************************/
function authenticate_user ($username, $token)
{
	$arc = 0;
	if ($username == "" || $token == "") {
		return 0;
	}
	if ($GLOBALS['ldap_enable'] == TRUE) {
		$lc = ldap_connect ("ldap://" . $GLOBALS['ldap_server']);
		if ($lc === FALSE) {
			#print "<p>DEBUG: ldap_connect: failed</p>";
			return 0;
		}
		#$token = addslashes ($token);
		$lb = ldap_bind ($lc, $username . "@" . $GLOBALS['ldap_domain'], $token);
		if ($lb === TRUE) {
			$arc = 1;
		}
		$rc = ldap_unbind ($lc);

		# If authentication failed, fall back to the backup server/domain
		if ($arc == 0) {
			$lc = ldap_connect ("ldap://" . $GLOBALS['backup_ldap_server']);
			if ($lc !== FALSE) {
				$lb = ldap_bind ($lc, $username . "@" . $GLOBALS['backup_ldap_domain'], $token);
				if ($lb === TRUE) {
					$arc = 1;
				}
				$rc = ldap_unbind ($lc);
			}
		}

	} else {
		/* not LDAP authentication */
		return 0;
	}
	return $arc;
}


/************************************************************************/
/* Create the session cache, if needed					*/
/************************************************************************/
function session_create_cache ()
{
	if (!session_is_registered ("ViewMaxAlerts")) {
		$_SESSION['ViewMaxAlerts'] = 3;
	}
	if (!session_is_registered ("ViewSortColumn")) {
		$_SESSION['ViewSortColumn'] = 1;
	}
	if (!session_is_registered ("ViewSortDirection")) {
		$_SESSION['ViewSortDirection'] = 'd';
	}
	if (!session_is_registered ("AlertClass")) {
		$sql = "select ac_id, ac_name from alert_class";
		#print "<p>DEBUG: sql='" . $sql . "'</p>\n";
		$result = mysql_query ($sql);
		if ($result) {
			while ($row = mysql_fetch_row ($result)) {
				$AlertClass[$row[0]] = $row[1];
				$AlertClassId[$row[1]] = $row[0];
			}
			mysql_free_result ($result);
			$_SESSION['AlertClass'] = $AlertClass;
			$_SESSION['AlertClassId'] = $AlertClassId;
		}
	}
	if (!session_is_registered ("AlertSeverity")) {
		$sql = "select as_id, as_name from alert_severity";
		#print "<p>DEBUG: sql='" . $sql . "'</p>\n";
		$result = mysql_query ($sql);
		if ($result) {
			while ($row = mysql_fetch_row ($result)) {
				$AlertSeverity[$row[0]] = $row[1];
				$AlertSeverityId[$row[1]] = $row[0];
			}
			mysql_free_result ($result);
			$_SESSION['AlertSeverity'] = $AlertSeverity;
			$_SESSION['AlertSeverityId'] = $AlertSeverityId;
		}
	}
	if (!session_is_registered ("AlertState")) {
		$sql = "select ast_id, ast_name from alert_state";
		#print "<p>DEBUG: sql='" . $sql . "'</p>\n";
		$result = mysql_query ($sql);
		if ($result) {
			while ($row = mysql_fetch_row ($result)) {
				$AlertState[$row[0]] = $row[1];
				$AlertStateId[$row[1]] = $row[0];
			}
			mysql_free_result ($result);
			$_SESSION['AlertState'] = $AlertState;
			$_SESSION['AlertStateId'] = $AlertStateId;
		}
	}
	if (!session_is_registered ("AlertDataType")) {
		$AlertDataType = array ("Reserved" => 0,
					"Event" => 1,
					"Note" => 2,
					"Acknowledged" => 3,
					"Cleared" => 4,
					"Resolved" => 5,
					"Data" => 6,
					"ProcBegin" => 28,
					"ProcEndSuccess" => 20,
					"ProcEndWarning" => 21,
					"ProcEndFailure" => 22,
					"StepBegin" => 38,
					"StepEndSuccess" => 30,
					"StepEndWarning" => 31,
					"StepEndFailure" => 32
					);
		foreach ($AlertDataType as $k => $v) {
			$AlertDataTypeId[$v] = $k;
		}
		$_SESSION['AlertDataType'] = $AlertDataType;
		$_SESSION['AlertDataTypeId'] = $AlertDataTypeId;
	}

	session_cache_user_rights ();

	if (!session_is_registered ("preferences")) {
		$pref = array ();
		$attriblist = "'alert_view_max_records','alert_view_display_state','alert_view_display_class','alert_view_display_sort','alert_view_display_skin','alert_view_display_severity','icon_set'";
		$uatable = new UserAttributeDbTableClass ();
		$username = $_SESSION['username'];
		$uatable->SetWhere ("ua_username = '$username' and ua_attribute in ($attriblist)");
		$d = $uatable->GetPageData (1);
		foreach ($d as $row) {
			$pref[$row['ua_attribute']] = $row['ua_value'];
		}

		# Set some defaults, if not found in the database
		if (!isset ($pref['alert_view_display_state'])) {
			$pref['alert_view_display_state'] = "New,New(Dups)";
		}
		if (!isset ($pref['alert_view_display_class'])) {
			$pref['alert_view_display_class'] = "Device,Network,System,Security,Performance,Application,Service,Environment";
		}
		if (!isset ($pref['icon_set'])) {
			$pref['icon_set'] = "LED";
		}
		if (!isset ($pref['alert_view_max_records'])) {
			$pref['alert_view_max_records'] = 25;
		}

		$pref['alert_view_display_state'] = explode (',', $pref['alert_view_display_state']);
		$pref['alert_view_display_class'] = explode (',', $pref['alert_view_display_class']);
		$_SESSION['preferences'] = $pref;
	}
	return;
}


/************************************************************************/
/*** Validate the session						*/
/************************************************************************/
function session_validate ()
{
	#If not authenticated, display the login page
	if (!session_is_registered ('authenticated')) {
	        if (!isset ($_POST['logon'])) {
	                display_logon ("");
	                session_set_page ('logon');
	                return FALSE;
	        }
	}
	return TRUE;
}


/************************************************************************/
/* render the NavMenu							*/
/************************************************************************/
function display_navmenu_orig ()
{
	$script =  array_pop (explode ("/", $_SERVER['PHP_SELF']));
	$NavItem = $GLOBALS['menu_page_array'];
#	$NavItem = array ('netinfo.php' => 'Alerts',
#			'reports-addgraphs.php' => 'Reporting',
#			'preferences.php' => 'Preferences',
#			'administration.php' => 'Administration',
#			'reports-sla.php' => 'SLA_Development',
#			'help.php' => 'Help',
#			'logout.php' => 'Logout');
									
	print "\n<tr><td><p>";
	print "<table class='navMenu' border='0' cellpadding='4' cellspacing='0'>\n";
	print "<tr>";
	if (!isset ($_GET['view'])) {
		$view = "alerts";
	} else {
		$view = $_GET['view'];
	}
	foreach ($NavItem as $key => $name) {
		if ($key == $script) {
			print "<td CLASS='navMenuCurrentTitle' width='140'>";
			print "<a href='" . $key . "'>" . $name . "</a></td>\n";
		} else {
			print "<td CLASS='navMenuTitle' width='140'>";
			print "<a href='" . $key . "'>" . $name . "</a></td>\n";
		}
	}
	print "<td CLASS='navMenuTitle' width='100%'>&nbsp</td>\n";
	print "</tr>";
	print "</table>";
	print "</td></tr>\n";
	#print "<tr><td><p>&nbsp</tr></td>";
	return;
}


/************************************************************************/
/* Create a DB connection						*/
/************************************************************************/
function db_connect ()
{
	$dbhost = $GLOBALS['db_hostname'] . ":" . $GLOBALS['db_port'];
	$dbname = $GLOBALS['db_name'];
	$dbuser = $GLOBALS['db_username'];
	$dbpass = $GLOBALS['db_password'];
	if ($dbhost == "" || $dbname == "" || $dbuser == "" || $dbpass == "") {
		return FALSE;
	}
	$conn = mysql_connect ($dbhost, $dbuser, $dbpass);
	if (!$conn) {
		print "<P>mysql_connect(): " . mysql_error () . "\n";
		return FALSE;
	}
	if (!mysql_select_db ($dbname)) {
		print "<P>mysql_select_db(): " . mysql_error () . "\n";
		mysql_close ($conn);
		return FALSE;
	}
	return $conn;
}


/************************************************************************/
/* alert_note								*/
/************************************************************************/
function alert_note($aid, $type, $message)
{
	$rc = 0;
	$msg = htmlentities ($message);
	$sql = sprintf ("insert into alert_data (%s) values (%d,NOW(),%d,'%s','%s')",
			"ad_a_id,ad_timestamp,ad_type,ad_name,ad_data",
			$aid,
			$type,
			$_SESSION['username'],
			mysql_real_escape_string ($msg));
	$result = mysql_query ($sql);
	if ($result == FALSE) {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
		$rc = 1;
	}
	return $rc;
}



/************************************************************************/
/* html_multiselect_button						*/
/************************************************************************/
function html_multiselect_button ($name, $items, $selected)
{
        $s = "<select multiple name='" . $name . "[]'>";
	foreach ($items as $value) {
                $s .= " <option ";
                if (is_array ($selected) && array_search ($value, $selected) !== FALSE) {
                        $s .= " selected value='" . $value . "'";
                }
                $s .= ">" . $value . "</option>";
        }
        $s .= "</select>";
        return $s;
}


/************************************************************************/
/* Render an Alert table given the SQL where clause specified		*/
/************************************************************************/
function display_alerts_table ($title, $sqlwhere, $detailslink)
{
	/*** Session Cache */
	#session_create_cache ();
	$AlertClass = $_SESSION['AlertClass'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$AlertState = $_SESSION['AlertState'];

	if ($title == "") {
		$title = "Alerts";
	}

	print "<tr><td><p>&nbsp";
	print "</tr></td>";

	/*** Alert List ***/
	$sql = "select a_id,a_alerttime,a_class,a_severity,a_state,a_hostname,a_object,a_message ";
	$sql .= "from alert ";
	$sql .= "where 1 = 1 ";
	if ($sqlwhere != "") {
		$sql .= "and " . $sqlwhere . " ";
	}
	$sql .= "order by 1 desc ";
	#if ($Preference['alert_view_max_records'] > 0) {
	#	$sql .= " limit " . $Preference['alert_view_max_records'];
	#}
	$result = mysql_query ($sql);
	if ($result) {
		print "<P>";
		print "<table class='tableList'>";
		print "<tr><th class='hostTitle' colspan='8'>" . $title . "</th></tr>\n";
		print "<tr>";
		print "<th class='hostHeader' width='40'>Actions</th>";
		print "<th class='hostHeader' width='110'>Timestamp</th>";
		print "<th class='hostHeader' width='50'>Class</th>";
		print "<th class='hostHeader' width='60'>Severity</th>";
		print "<th class='hostHeader' width='60'>State</th>";
		print "<th class='hostHeader' width='100'>Hostname</th>";
		print "<th class='hostHeader' width='80'>Object</th>";
		print "<th class='hostHeader' width='500'>Message</th></tr>\n";
		while ($row = mysql_fetch_row ($result)) {
			print "<tr>";
			$tclass = $AlertSeverity[$row[3]] . "Severity";
			if ($detailslink == TRUE) {
				$actionshtml = "<a href='?view=alertdetail&a_id=" . $row[0] . "'>Details</a>";
			} else {
				$actionshtml = "";
			}
			print "<td class='" . $tclass . "'>" . $actionshtml . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[1] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertClass[$row[2]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertSeverity[$row[3]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertState[$row[4]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[5] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[6] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[7] . "</td>\n";
			print "</tr>";
		}
		print "</table>\n";
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	return;
}


/************************************************************************/
/* session_cache_user_rights						*/
/************************************************************************/
function session_cache_user_rights ()
{
	$right = array ();
	$sql = sprintf ("select ua_value from user_attribute where ua_attribute = '%s' ",
			"ACCESSRIGHT");
	$sql .= sprintf (" and ua_username = '%s'", $_SESSION['username']);
	$result = mysql_query ($sql);
	if ($result) {
		while ($row = mysql_fetch_row ($result)) {
			$right[$row[0]] = TRUE;
		}
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		#print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	$_SESSION['accessrights'] = $right;

	# Cache menu pages
	$menu_item = $GLOBALS['menu_access_array'];
	$list = array ();
	#foreach ($right as $k => $v) {
	foreach ($menu_item as $k => $v) {
		if (isset ($right[$k])) {
			$list[$k] = $menu_item[$k];
		}
	}
	$_SESSION['menuaccess'] = $list;
	return;
}


/************************************************************************/
/* user_check_access_right						*/
/************************************************************************/
function user_check_access_right ($right)
{
	if (!isset ($_SESSION['accessrights'])) {
		return 1;
	}
	$list = $_SESSION['accessrights'];
	if ($list[$right] != TRUE) {
		#print "<tr><td><font color='white'><h4>";
		#print "You don't have authority to access this page.";
		#print "</h4></font></td></td>";
		return 1;
	}
	return 0;
}


/************************************************************************/
/* user_has_access_right						*/
/************************************************************************/
function user_has_access_right ($right)
{
	$access = 0;
	if (!isset ($_SESSION['accessrights'])) {
		return $access;
	}
	$list = $_SESSION['accessrights'];
	if (array_key_exists ($right, $list)) {
		if ($list[$right] == TRUE) {
			$access = 1;
		}
	}
	return $access;
}


/************************************************************************/
/* render a navigation menu						*/
/************************************************************************/
function render_page_menu ($menuitems)
{
	$script =  array_pop (explode ("/", $_SERVER['PHP_SELF']));
	print "\n<tr><td>";
	print "<table class='navMenu' border='0' cellpadding='2' cellspacing='0'>\n";
	print "<tr>\n";
	if (!isset ($_GET['view'])) {
		$view = "cover";
	} else {
		$view = $_GET['view'];
	}
	foreach ($menuitems as $key => $name) {
		if ($key == $view) {
			print "<td CLASS='navMenuCurrentTitle' >";
			print "<a href='" . $script . "?view=" . $key . "'>" . $name;
			print "</a></td>\n";
		} else {
			print "<td CLASS='navMenuTitle' >";
			print "<a href='" . $script . "?view=" . $key . "'>" . $name;
			print "</a></td>\n";
		}
	}
	print "<td CLASS='navMenuTitle' width='90%'>&nbsp</td>\n";
	print "</tr>\n";
	print "</table>\n";
	print "</td></tr>\n";
	print "<tr><td><p>&nbsp</tr></td>\n";
	return;
}


/************************************************************************/
/* html_select_button							*/
/************************************************************************/
function html_select_button ($name, $items, $selected)
{
	$s = "<select name='" . $name . "'>";
	foreach ($items as $value) {
		$s .= " <option ";
		if (strlen ($selected) > 0 && $value == $selected) {
			$s .= " selected value='" . $value . "'";
		}
		$s .= ">" . $value . "</option>";
	}
	$s .= "</select>";
	return $s;
}


/************************************************************************/
/* session_save_preferences						*/
/************************************************************************/
function session_save_preferences ()
{
	$uatable = new UserAttributeDbTableClass ();
	$prefs = $_SESSION['preferences'];
	$username = $_SESSION['username'];
	$rcr = $uatable->SetAttributes ($prefs);	
	return $rcr;
}



/************************************************************************/
/* Render a Diagnostic Alert table given the SQL where clause specified	*/
/************************************************************************/
function display_diagnostic_alerts_table ($title, $sqlwhere, $detailslink)
{
	/*** Session Cache */
	#session_create_cache ();
	$AlertClass = $_SESSION['AlertClass'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$AlertState = $_SESSION['AlertState'];

	if ($title == "") {
		$title = "Alerts";
	}

	print "<tr><td><p>&nbsp";
	print "</tr></td>";

	/*** Alert List ***/
	$sql = "select a_id,a_alerttime,a_class,a_severity,a_state,a_hostname,a_object,a_message,ad_data ";
	$sql .= "from alert, alert_data ";
	$sql .= "where 1 = 1 and alert_data.ad_a_id = alert.a_id and alert_data.ad_type = 5 ";
	if ($sqlwhere != "") {
		$sql .= "and " . $sqlwhere . " ";
	}
	$sql .= "order by 1 desc ";
	$sql .= " limit 30 ";
	$result = mysql_query ($sql);
	if ($result) {
		print "<P>";
		print "<table class='tableList'>";
		print "<tr><th class='hostTitle' colspan='8'>" . $title . "</th></tr>\n";
		print "<tr>";
		print "<th class='hostHeader' width='40'>Actions</th>";
		print "<th class='hostHeader' width='110'>Timestamp</th>";
		print "<th class='hostHeader' width='50'>Class</th>";
		print "<th class='hostHeader' width='60'>Severity</th>";
		print "<th class='hostHeader' width='60'>State</th>";
		print "<th class='hostHeader' width='100'>Hostname</th>";
		print "<th class='hostHeader' width='80'>Object</th>";
		print "<th class='hostHeader' width='500'>Resolution Message</th></tr>\n";
		while ($row = mysql_fetch_row ($result)) {
			print "<tr>";
			$tclass = $AlertSeverity[$row[3]] . "Severity";
			if ($detailslink == TRUE) {
				$actionshtml = "<a href='?view=alertdetail&a_id=" . $row[0] . "'>Details</a>";
			} else {
				$actionshtml = "";
			}
			print "<td class='" . $tclass . "'>" . $actionshtml . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[1] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertClass[$row[2]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertSeverity[$row[3]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertState[$row[4]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[5] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[6] . "</td>\n";
			print "<td class='" . $tclass . "'>" . stripslashes ($row[8]) . "</td>\n";
			print "</tr>";
		}
		print "</table>\n";
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	return;
}


/************************************************************************/
/* render the NavMenu							*/
/************************************************************************/
function display_navmenu ()
{
	$script =  array_pop (explode ("/", $_SERVER['PHP_SELF']));
	$NavItem = $GLOBALS['menu_page_array'];
	print "\n<tr><td><p>";
	print "<table class='navMenu' border='0' cellpadding='4' cellspacing='0'>\n";
	print "<tr>";
	if (!isset ($_GET['view'])) {
		$view = "alerts";
	} else {
		$view = $_GET['view'];
	}

	# Restricted-access Menu Items
	foreach ($_SESSION['menuaccess'] as $access => $page) {
		$name = $NavItem[$page];
		if ($page == $script) {
			print "<td CLASS='navMenuCurrentTitle' width='140'>";
			print "<a href='" . $page . "'>" . $name . "</a></td>\n";
		} else {
			print "<td CLASS='navMenuTitle' width='140'>";
			print "<a href='" . $page . "'>" . $name . "</a></td>\n";
		}
	}

	# All-access Menu Items
	foreach ($GLOBALS['menu_allaccess_array'] as $page => $name) {
		if ($page == $script) {
			print "<td CLASS='navMenuCurrentTitle' width='140'>";
			print "<a href='" . $page . "'>" . $name . "</a></td>\n";
		} else {
			print "<td CLASS='navMenuTitle' width='140'>";
			print "<a href='" . $page . "'>" . $name . "</a></td>\n";
		}
	}

	print "<td CLASS='navMenuTitle' width='100%'>&nbsp</td>\n";
	print "</tr>";
	print "</table>";
	print "</td></tr>\n";
	#print "<tr><td><p>&nbsp</tr></td>";
	return;
}



/************************************************************************/
/* Print 'access denied'						*/
/************************************************************************/
function access_denied_page()
{
	print "<tr><td><font color='white'><h4>";
	print "You don't have authority to access this page.";
	print "</h4></font></td></td>";
	return;
}



?>

