<?php


class DbTableClass
{
	var $tablename;
	var $pagerows;
	var $column;
	var $pkey;
	var $datarows;
	var $datapages;
	var $dataarray;
	var $errorarray;
	var $sqlwhere;
	var $sqlorder;
	var $insertid;


function DbTableClass ()
{
	$this->tablename	= "default";
	$this->pagerows		= 10;
	$this->column	= array ( 'column1' => array ('type' => "integer", 'len' => 0),
				'column2' => array ('type' => "varchar", 'len' => 16)
			);
	$this->pkey	= "column1";
	$this->sqlwhere = NULL;
	$this->sqlorder = NULL;
}


function SetPageRows ($rows)
{
	if ($rows < 1) {
		$this->pagerows = 1;
	} else {
		$this->pagerows = $rows;
	}
	return;
}


function SetWhere ($where)
{
	$this->dataarray = array ();
	if (empty ($where)) {
		$this->sqlwhere = NULL;
	} else {
		$this->sqlwhere = "WHERE $where";
	}
	$query = "SELECT COUNT(1) from $this->tablename $this->sqlwhere";
	$result = mysql_query ($query);
	if ($result) {
		$row = mysql_fetch_row ($result);
		$this->datarows = $row[0];
		mysql_free_result ($result);
	}
	if ($this->datarows > 0) {
		if ($this->pagerows > 0) {
			$this->datapages = ceil ($this->datarows / $this->pagerows);
		} else {
			$this->datapages = 1;
		}
	} else {
		$this->datarows = 0;
		$this->datapages = 0;
	}
	return;
}


function GetPageData ($pagenum)
{
	$this->dataarray = array ();
	if ($pagenum == "" or $pagenum <= "1") {
		$pagenum = 1;
	} elseif ($pagenum > $this->datapages) {
		$pagenum = $this->datapages;
	}
	if ($this->pagerows > 0) {
		$sql_limit = "LIMIT " . ($pagenum - 1) * $this->pagerows . "," . $this->pagerows;
	} else {
		$sql_limit = NULL;
	}
	if ($this->sqlorder != NULL) {
		$sql_order = "order by " . $this->sqlorder;
	} else {
		$sql_order = "";
	}
	$query = "SELECT * FROM $this->tablename $this->sqlwhere $sql_order $sql_limit";
	$result = mysql_query ($query);
	if ($result) {
		while ($row = mysql_fetch_assoc ($result)) {
			$this->dataarray[] = $row;
		}
		mysql_free_result ($result);
	} else {
		return;
	}
	return $this->dataarray;
}


function GetNumRows ()
{
	return $this->datarows;
}


function FreeResult ()
{
	$this->dataarray = array ();
	return;
}


function ValidateValues ($data)
{
	$rc = 0;
	$rcm = array ();
	foreach ($data as $c => $v) {
		if (!isset ($this->column[$c])) {
			$rc++;
			$rcm[] = "Unknown column '$c'";
			continue;
		}
		$t = $this->column[$c];
		switch ($t['type']) {
			case "int":
				if (!$this->is_valid_integer($v)) {
					$rc++;
					$rcm[] = "'$v' is not a valid integer";
				}
				break;
			case "varchar":
				if (strlen ($v) > $t['len']) {
					$rc++;
					$rcm[] = "'$v' is longer than allowed";
				}
				break;
			case "date":
				if (!$this->is_valid_date($v)) {
					$rc++;
					$rcm[] = "'$v' is not a valid date";
				}
				break;
			case "time":
				if (!$this->is_valid_time($v)) {
					$rc++;
					$rcm[] = "'$v' is not a valid time";
				}
				break;
			case "datetime":
			case "timestamp":
				if (!$this->is_valid_timestamp($v)) {
					$rc++;
					$rcm[] = "'$v' is not a valid datetime";
				}
				break;
		}
	}
	return array ($rc, $rcm);
}


function OnlyColumns ($data)
{
	$o = array ();
	foreach ($data as $c => $v) {
		if (isset ($this->column[$c])) {
			$o[$c] = $v;
		}
	}
	return $o;
}


function InsertRecord ($data)
{
	$rc = 0;
	$rcm = array ();
	if (count ($data) < 1) {
		return array (1, "Missing data values");
	}
	if (isset ($data[$this->pkey])) {
		return array (2, "Cannot insert with primary key value set");
	}
	$rcr = $this->ValidateValues ($data);	
	if ($rcr[0] != 0) {
		return $rcr;
	}
	$cols = array ();
	$cd = "";
	foreach ($data as $k => $v) {
		if (isset ($this->column[$k])) {
			$t = $this->column[$k];
			if ($t['type'] == "int") {
				$cd .= $v;
			} else {
				$cd .= "'" . mysql_real_escape_string ($v) . "'";
			}
			$cd .= ",";
			$cols[] = $k;
		}
	}
	$cd = rtrim ($cd, ",");
	$query = "INSERT INTO $this->tablename " .
		"(" . implode (",", $cols) . ")" .
		" values (" . $cd . ")";
	$result = mysql_query ($query);
	if ($result === TRUE) {
		$this->insertid = mysql_insert_id ();
	} else {
		$rc = mysql_errno ();
		$rcm[] = mysql_error (); 
	}
	return array ($rc, $rcm);
}


function UpdateRecord ($data)
{
	$rc = 0;
	$rcm = array ();
	if (count ($data) < 1) {
		return array (1, "Missing data values");
	}
	if (!isset ($data[$this->pkey])) {
		return array (2, "Cannot update without primary key value set");
	}
	$rcr = $this->ValidateValues ($data);	
	if ($rcr[0] != 0) {
		return $rcr;
	}

	$cd = "";
	foreach ($data as $k => $v) {
		if (isset ($this->column[$k]) && $k != $this->pkey) {
			$t = $this->column[$k];
			if ($t['type'] == "int") {
				$cd .= " $k = $v,";
			} else {
				$cd .= " $k = '" . mysql_real_escape_string ($v) . "',";
			}
		}
	}
	$cd = rtrim ($cd, ",");
	$pkval = $data[$this->pkey];
	$query = "UPDATE $this->tablename SET $cd WHERE $this->pkey = $pkval";
	$result = mysql_query ($query);
	if ($result !== TRUE) {
		$rc = mysql_errno ();
		$rcm[] = mysql_error (); 
	}
	return array ($rc, $rcm);
}


function DeleteRecordByPkey ($key)
{
	$rc = 0;
	$rcm = array ();
	if (!isset ($key) || !is_valid_integer ($key)) {
		$rc = 1;
		$rcm[] = "An invalid value was specified";
		return array ($rc, $rcm);
	}
	$query = "DELETE FROM $this->tablename WHERE $this->pkey = $key";
	$result = mysql_query ($query);
	if ($result !== TRUE) {
		$rc = mysql_errno ();
		$rcm[] = mysql_error (); 
	}
	return array ($rc, $rcm);
}


function is_valid_integer ($value)
{
	return preg_match ("/^\d+$/", $value);
}


function is_valid_date ($value)
{
	return preg_match ("/^\d\d\d\d-\d\d-\d\d$/", $value);
}


function is_valid_time ($value)
{
	return preg_match ("/^\d\d:\d\d:\d\d$/", $value);
}


function is_valid_timestamp ($value)
{
	return preg_match ("/^\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d$/", $value);
}


function PostInsertSetPkey ($data)
{
	$o = array ();
	$o[$this->pkey] = $this->insertid;
	return array_merge ($o, $data);
}

function SetOrderBy ($data)
{
	$rc = 0;
	$rcm = array ();
	$this->sqlorder = $data;
	return array ($rc, $rcm);
}


} // class

?>
