<?php

class HtmlTableClass
{

	var $title;
	var $titleclass;
	var $tableclass;
	var $headerclass;
	var $fieldclass;
	var $column;
	var $tableattr;

function HtmlTableClass ()
{
	$this->column = array ();
	$this->tableattr = array ();
	return;
}

function SetTitle ($title)
{
	$this->title = $title;
	return;
}

function SetTitleClass ($class)
{
	$this->titleclass = $class;
	return;
}

function SetTableAttribute ($name, $value)
{
	if ($name == "") {
		return;
	}
	$this->tableattr[$name] = $value;
	return;
}

function SetTableClass ($class)
{
	$this->tableattr['class'] = $class;
	return;
}

function SetHeaderClass ($class)
{
	$this->headerclass = $class;
	return;
}

function SetFieldClass ($class)
{
	$this->fieldclass = $class;
	return;
}

function AddColumn ($column)
{
	if (!isset ($column['displayname'])) {
		return 1;
	}
	if (!isset ($column['dataname'])) {
		return 1;
	}
	$this->column[] = $column;
	return;
}

function Render ($data)
{
	$a = "";
	foreach ($this->tableattr as $name => $value) {
		$a .= " $name='$value'";
	}
	print "<table $a>\n";
	if ($this->title != "") {
		if ($this->titleclass != "") {
			$a = "class='$this->titleclass'";
		} else {
			$a = "";
		}
		$cs = count ($this->column);
		print "\t<tr>\n";
		print "\t\t<th $a colspan='$cs'>$this->title</th>\n";
		print "\t</tr>\n";
	}
	print "\t<tr>\n";
	foreach ($this->column as $col) {
		if (isset ($col['class'])) {
			$c = $col['class'];
		} else {
			$c = $this->headerclass;
		}
		if (isset ($col['width'])) {
			$a = " width='" . $col['width'] . "'";
		}
		if (isset ($col['align'])) {
			$a .= " align='" . $col['align'] . "'";
		}
		if (isset ($col['valign'])) {
			$a .= " valign='" . $col['valign'] . "'";
		}
		if ($col['displayname'] != "") {
			print "\t\t<td class='$c' $a>";
			print $col['displayname'];
			print "</td>\n";
		}
	}
	print "\t</tr>\n";
	foreach ($data as $row) {
		print "\t<tr>\n";
		foreach ($this->column as $col) {
			if (isset ($row["_class_" . $col['dataname']])) {
				$ca = "class='" . $row["_class_" . $col['dataname']] . "'";
			} else if (isset ($row['_class'])) {
				$c = $row['_class'];
				$ca = "class='$c'";
			} else if (isset ($col['class'])) {
				$c = $col['class'];
				$ca = "class='$c'";
			} else if ($this->fieldclass != "") {
				$ca = "class='$this->fieldclass'";;
			} else {
				$ca = " ";
			}
			if (isset ($row['valign'])) {
				$ca .= " valign='" . $row['valign'] . "'";
			}
			if (isset ($col['align'])) {
				$ca .= " align='" . $col['align'] . "'";
			}
			if (isset ($col['valign'])) {
				$ca .= " valign='" . $col['valign'] . "'";
			}
			if (isset ($col['bgcolor'])) {
				$ca .= " bgcolor='" . $col['bgcolor'] . "'";
			}
			print "\t\t<td $ca>";
			print $row[$col['dataname']];
			print "</td>\n";
		}
		print "\t</tr>\n";
	}
	print "</table>\n";
	return;
}


function RenderVertical ($row)
{
	$a = "";
	foreach ($this->tableattr as $name => $value) {
		$a .= " $name='$value'";
	}
	print "<table $a>\n";
	if ($this->title != "") {
		if ($this->titleclass != "") {
			$a = "class='$this->titleclass'";
		} else {
			$a = "";
		}
		$cs = count ($this->column);
		print "\t<tr>\n";
		print "\t\t<th $a colspan='$cs'>$this->title</th>\n";
		print "\t</tr>\n";
	}
	foreach ($this->column as $col) {
		print "\t<tr>\n";
		/* Header column */
		if (isset ($col['class'])) {
			$c = $col['class'];
		} else {
			$c = $this->headerclass;
		}
		if (isset ($col['width'])) {
			$a .= " width='" . $col['width'] . "'";
		}
		print "\t\t<td class='$c' $a>";
		print $col['displayname'];
		print "</td>\n";
		/* Data Column */
		if (isset ($col['class'])) {
			$c = $col['class'];
			$ca = "class='$c'";
		} else if ($this->fieldclass != "") {
			$ca = "class='$this->fieldclass'";;
		} else {
			$ca = " ";
		}
		print "\t\t<td $ca>";
		print $row[$col['dataname']];
		print "</td>\n";
		print "\t</tr>\n";
	}
	print "</table>\n";
	return;
}


} // class


?>
