<?php
/*
 * netinfo-clientprocess.php - ClinetProcess WebServices using NuSOAP
*/

require_once ("lib/nusoap.php");

include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';

include 'alertdata.dbtable.class.inc';
include 'client.dbtable.class.inc';
include 'clientprocess.dbtable.class.inc';

#$logfile = "./netinfo-clientprocess.log";
#$lfd = fopen ($logfile, "a");

$namespace = "http://it.datascantech.com/netinfo";
$server = new soap_server ();
$server->configureWSDL ("clientprocess", $namespace);
$server->wsdl->schemaTargetNamespace = $namespace;


$server->wsdl->addComplexType (
		"ClientProcessDetailRequestType",
		"complexType",
		"struct",
		"all",
		"",
		array (
			"authUser" => array (
						"name" => "authUser",
						"type" => "xsd:string"
			),
			"authPassword" => array (
						"name" => "authPassword",
						"type" => "xsd:string"
			),
			"clientNumber" => array (
						"name" => "clientNumber",
						"type" => "xsd:string"
			),
			"processName" => array (
						"name" => "processName",
						"type" => "xsd:string"
			),
			"processDate" => array (
						"name" => "processDate",
						"type" => "xsd:string"
			)
		),
		array ()
	);

/*
$server->wsdl->addComplexType (
		"StringArrayType",
		"complexType",
		"array",
		"",
		"SOAP-ENC:Array",
		array (
			array (
				"ref" => "SOAP-ENC:arrayType",
				"wsdl:arrayType" => "xsd:string[]"
			)
		),
		"xsd:string"
	);
*/

$server->wsdl->addComplexType (
		"StringArrayType",
		"complexType",
		"array",
		"",
		"SOAP-ENC:Array",
		array (),
		array (
			array ( "ref" => "SOAP-ENC:arrayType",
				"wsdl:arrayType" => "xsd:string[]"
			)
		),
		"xsd:string"
	);


$server->wsdl->addComplexType (
		"ClientProcessDetailResponseType",
		"complexType",
		"struct",
		"all",
		"",
		array (
			"clientNumber" => array (
						"name" => "clientNumber",
						"type" => "xsd:string"
			),
			"processName" => array (
						"name" => "processName",
						"type" => "xsd:string"
			),
			"processDate" => array (
						"name" => "processDate",
						"type" => "xsd:string"
			),
			"processDetail" => array (
						"name" => "processDetail",
						"type" => "tns:StringArrayType"
			)
		),
		array ()
	);


$server->register ("getClientProcessDetailByDate",
		array (
			"authUser" => "xsd:string",
			"authPassword" => "xsd:string",
			"clientNumber" => "xsd:string",
			"processName" => "xsd:string",
			"processDate" => "xsd:string"
		),
		array ("return" => "tns:ClientProcessDetailResponseType"),
		$namespace,
		$namespace . "#getClientProcessDetailByDate",
		"rpc",
		"encoded",
		"Returns client process detail for a given date"
	);

$request = isSet ($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : "";
$server->service ($request);
#fclose ($lfd);
return;



function getClientProcessDetailByDate ($authUser, $authPassword, $clientNumber, $processName, $processDate)
{
	#if ($authUser != "cpview_user" || $authPassword != "!Vie3wer%") {
	if ($authUser != "cpview_user" || $authPassword != "!N0Vie3wer%") {
		return new soap_fault ("AUTHENTICATION", "Failed to authenticate you to the system. Contact the system administrator.");
	}

	if (!is_valid_date ($processDate)) {
		return new soap_fault ("PARAM", "The processDate value specified is not a valid date format.");
	}

	$conn = db_connect ();
	if ($conn == FALSE) {
		return new soap_fault ("DB", "Failed to connect to the database. Contact the system administrator.");
	}

	$clientNumber = mysql_real_escape_string ($clientNumber);
	$processName = mysql_real_escape_string ($processName);
	$processDate = mysql_real_escape_string ($processDate);
	
	# Validate the clientnumber
	$sql = "select c_id from client where c_symbol = '" . $clientNumber . "'";
	$result = mysql_query ($sql, $conn);
 	if ($result === FALSE) {
		mysql_close ($conn);
		return new soap_fault ("DB", "Failed to query the database. Contact the system administrator.");
	}
	$row = mysql_fetch_assoc ($result);
	mysql_free_result ($result);
	if (!isset ($row['c_id']) || $row['c_id'] == "") {
		mysql_close ($conn);
		return new soap_fault ("PARAM", "An invalid clientNumber was specified in the request.");
	}


	$dt = date ("Y-m-d", time ());

	# Retrieve the process data
	#log_message ("Executing SQL");
	$sql = "select a_id,ad_data";
	$sql .= " from alert,alert_data,client,client_process";
	if ($processDate == $dt) {
		$sql .= " where ad_a_id = a_id";
		$sql .= " and a_object = cp_object";
		$sql .= " and cp_c_id = c_id";
		$sql .= " and c_symbol = '" . $clientNumber . "'";
		$sql .= " and cp_name = '" . $processName . "'";
		$sql .= " and a_id = cp_latest_a_id";
		$sql .= " and ad_type in (20,21,22,29,30,31,32,39)";
	} else {
		$sql .= " where ad_a_id = a_id";
		$sql .= " and a_object = cp_object";
		$sql .= " and cp_c_id = c_id";
		$sql .= " and c_symbol = '" . $clientNumber . "'";
		$sql .= " and cp_name = '" . $processName . "'";
		$sql .= " and date(a_alerttime) = '" . $processDate . "'";
		$sql .= " and ad_type in (20,21,22,29,30,31,32,39)";
	}

	$result = mysql_query ($sql);
 	if ($result === FALSE) {
		mysql_close ($conn);
		return new soap_fault ("DB", "Failed to query the database. Contact the system administrator.");
	}
	$items = array ();
	while ($row = mysql_fetch_assoc ($result)) {
		$items[] = $row['ad_data'];
		#log_message ("item = '" . $row['ad_data'] . "'");
		
	}
	mysql_free_result ($result);
	$data = array (
		"clientNumber" => $clientNumber,
		"processName" => $processName,
		"processDate" => $processDate,
		"processDetail" => $items
	);
	mysql_close ($conn);
	return $data;
}


function log_message ($msg)
{
	global $lfd;
	$lt = localtime();
	fprintf ($lfd,
		"%04d-%02d-%02d %02d:%02d:%02d %s\n",
		$lt[5]+1900,
		$lt[4]+1,
		$lt[3],
		$lt[2],
		$lt[1],
		$lt[0],
		$msg);
	return;
}



?>
