<?php
/*
 * netinfo-image.php - Image Generation source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
#include 'page-functions.php';
include 'netinfo-config-variables.php';

#include 'alert.dbtable.class.inc';


header ('Content-type: image/png');

/*** If not authenticated, don't display the image*/
if (!session_is_registered ('authenticated')) {
	return 0;
}

# DST device mapping
$dst_map_ip = array (
		'ASA-5540' => '10.64.99.10',
		'ASP-FWSM' => '10.64.80.1',
		'MGMT-ASA' => '10.64.0.2'
);


# Number of items on the security graphs (default)
$graph_ip_items=15;
$graph_port_items=10;


# Image Defaults
$g_width = 380;
$g_height = 240;

$image = imagecreate ($g_width, $g_height);
$c_black = imagecolorallocate ($image, 0, 0, 0);
$c_white = imagecolorallocate ($image, 255, 255, 255);
$c_red = imagecolorallocate ($image, 255, 0, 0);
$c_green = imagecolorallocate ($image, 0, 255, 0);
$c_blue = imagecolorallocate ($image, 0, 0, 255);
$c_ltgrey = imagecolorallocate ($image, 200, 200, 200);


imagefill ($image, 0, 0, $c_white);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}


/*** Display the requested image */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if (isset($_GET['reportstartdate'])) {
		if (is_valid_date ($_GET['reportstartdate'])) {
			$report_start_date = $_GET['reportstartdate'];
		} else {
			imagepng ($image);
			imagedestroy ($image);
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_start_date = date ("Y-m-d", time());
	}
	if (isset($_GET['reportenddate'])) {
		if (is_valid_date ($_GET['reportenddate'])) {
			$report_end_date = $_GET['reportenddate'];
		} else {
			imagepng ($image);
			imagedestroy ($image);
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_end_date = $report_start_date;
	}
	if (isset($_GET['reporthostname'])) {
		if ($_GET['reporthostname'] != "") {
			$report_hostname = $_GET['reporthostname'];
		} else {
			imagepng ($image);
			imagedestroy ($image);
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_hostname = "";
	}

	if (isset($_GET['graphipitems']) && is_valid_integer ($_GET['graphipitems'])) {
		$graph_ip_items = $_GET['graphipitems'];
	}

	if (isset($_GET['graphportitems']) && is_valid_integer ($_GET['graphportitems'])) {
		$graph_port_items = $_GET['graphportitems'];
	}

	if (!isset($_GET['imagename']) || $_GET['imagename'] == "") {
		#print "<p>Report generation</p>\n";

	} else if ($_GET['imagename'] == "alertsbyclass") {
		generate_alertsbyclass ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertsbystate") {
		generate_alertsbystate ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertsbyseverity") {
		generate_alertsbyseverity ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbytcpport") {
		generate_alertstopscanbytcpport ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbyudpport") {
		generate_alertstopscanbyudpport ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbyaddress") {
		generate_alertstopscanbyaddress ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else {
		#session_error ();
	}
}

imagepng ($image);
imagedestroy ($image);
mysql_close ($conn);
return 0;


/************************************************************************/
/* Render the alertsbyclass image					*/
/************************************************************************/
function generate_alertsbyclass ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	
	$class = $_SESSION['AlertClass'];
	$sql = "select a_class as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_class";
	$result = mysql_query ($sql);
	if ($result) {
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			$r['title'] = $class[$r['title']];
			$row[] = $r;
			$total += $r['count'];
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	$rc = generate_bargraph_2axis ("Alerts by Class",
					$g_width,
					$g_height,
					"Alerts ($total)",
					$row);
	return $rc;
}



/************************************************************************/
/* Render the alertsbystate image					*/
/************************************************************************/
function generate_alertsbystate ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	
	$state = $_SESSION['AlertState'];
	$sql = "select a_state as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_state";
	$result = mysql_query ($sql);
	if ($result) {
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			$r['title'] = $state[$r['title']];
			$row[] = $r;
			$total += $r['count'];
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	$rc = generate_bargraph_2axis ("Alerts by State",
					$g_width,
					$g_height,
					"Alerts ($total)",
					$row);
	return $rc;
}


/************************************************************************/
/* Render the alertsbyseverity image				*/
/************************************************************************/
function generate_alertsbyseverity ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	
	$sev = $_SESSION['AlertSeverity'];
	$sql = "select a_severity as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_severity";
	$result = mysql_query ($sql);
	if ($result) {
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			$r['title'] = $sev[$r['title']];
			$row[] = $r;
			$total += $r['count'];
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	$rc = generate_bargraph_2axis ("Alerts by Severity",
					$g_width,
					$g_height,
					"Alerts ($total)",
					$row);
	return $rc;
}


/************************************************************************/
/* Render the alertstopscanbytcpport image				*/
/************************************************************************/
function generate_alertstopscanbytcpport ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_port_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/on tcp port ([0-9]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		$column = array ();
		foreach ($tarray as $n) {
			$column[] = $n;
			$count++;
			if ($count >= $graph_port_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	$title = "Top TCP Ports Scanned";
	if ($report_hostname != "") {
		$title .= " - $report_hostname";
	}
	$rc = generate_bargraph_2axis ($title,
					$g_width,
					$g_height,
					"Scans",
					$column);
	return $rc;
}


/************************************************************************/
/* Render the alertstopscanbyudpport image				*/
/************************************************************************/
function generate_alertstopscanbyudpport ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_port_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/on udp port ([0-9]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		$column = array ();
		foreach ($tarray as $n) {
			$column[] = $n;
			$count++;
			if ($count >= $graph_port_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	$title = "Top UDP Ports Scanned";
	if ($report_hostname != "") {
		$title .= " - $report_hostname";
	}
	$rc = generate_bargraph_2axis ($title,
					$g_width,
					$g_height,
					"Scans",
					$column);
	return $rc;
}


/************************************************************************/
/* Render the alertstopscanbyaddress image				*/
/************************************************************************/
function generate_alertstopscanbyaddress ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_ip_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/from ([0-9\.]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		$column = array ();
		foreach ($tarray as $n) {
			$column[] = $n;
			$count++;
			if ($count >= $graph_ip_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	$title = "Top Scans by Source IP";
	if ($report_hostname != "") {
		$title .= " - $report_hostname";
	}
	$rc = generate_bargraph_2axis_vertical ($title,
					$g_width,
					$g_height,
					"Scans",
					$column);
	return $rc;
}


/************************************************************************/
/* Render a two-axis bargraph image					*/
/************************************************************************/
function generate_bargraph_2axis ($title, $width, $height, $xlabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;


	# Graph defaults
	$xbase = 15;
	#$ybase = 360;
	$ybase = $height - 30;
	$x_interbar = 10;
	$space = 5;
	
	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	foreach ($column as $c) {
		$total += $c['count'];
		$count++;
	}

	# Calculate spacers, etc
	$iw = ($width - $xbase - $x_interbar - $x_interbar) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 75) {
		# Clamp the bar width
		$bw = 75;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;
		$h = $ybase * ($c['count'] / $total);
		$y = $ybase - $h;
		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $c_red);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column counter
		$tw = $f1s * strlen ($c['count']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				1,
				$sx,
				$ybase + $space,
				$c['count'],
				$c_black);

		# Draw the column title
		$tw = $f2s * strlen ($c['title']);
		if ($tw > $bw) {
			$tw = $bw;
		}
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				2,
				$sx,
				$height - ($x_interbar + $space), $c['title'],
				$c_black);
		$x += $bw;
	}

	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $x_interbar, $title, $c_black);

	# x-axis label
	$tw = $f1s * strlen ($xlabel);
	$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	imagestringup ($image, 2, $xbase - ($x_interbar + $space), $sy, $xlabel, $c_black);
	return 0;
}


/************************************************************************/
/* assoc_compare - Compare the 'count' values of two assoc arrays	*/
/************************************************************************/
function assoc_compare ($a, $b)
{
	if ($a['count'] == $b['count']) {
		return 0;
	}
	return ($a['count'] < $b['count']) ? -1 : 1;
}


/************************************************************************/
/* assoc_compare_r - (reverse)Compare the 'count' values of two assoc arrays	*/
/************************************************************************/
function assoc_compare_r ($a, $b)
{
	if ($a['count'] == $b['count']) {
		return 0;
	}
	return ($a['count'] > $b['count']) ? -1 : 1;
}


/************************************************************************/
/* Render a two-axis bargraph image with vertical bar labels		*/
/************************************************************************/
function generate_bargraph_2axis_vertical ($title, $width, $height, $xlabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;


	# Graph defaults
	$xbase = 15;
	#$ybase = 360;
	$ybase = $height - 30;
	$x_interbar = 10;
	$space = 5;
	$bar_y_clamp = ($x_interbar * 2) + $space;

	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	foreach ($column as $c) {
		$total += $c['count'];
		$count++;
	}

	# Calculate spacers, etc
	$iw = ($width - $xbase - $x_interbar - $x_interbar) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 25) {
		# Clamp the bar width
		$bw = 25;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;
		$h = ($ybase - $bar_y_clamp) * ($c['count'] / $total);
		$y = $ybase - $h;
		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $c_red);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column counter
		$tw = $f1s * strlen ($c['count']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				1,
				$sx,
				$ybase + $space,
				$c['count'],
				$c_black);

		# Draw the column title
		$tw = $f2s * strlen ($c['title']);
		if ($tw > ($h + $space + $space)) {
			$sy = $ybase - $h - $space;
		} else {
			$sy = $ybase - $space;
		}
		imagestringup ($image,
				2,
				$x + $bc - $space,
				$sy,
				$c['title'],
				$c_black);
		$x += $bw;
	}

	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $x_interbar, $title, $c_black);

	# x-axis label
	$tw = $f1s * strlen ($xlabel);
	$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	imagestringup ($image, 2, $xbase - ($x_interbar + $space), $sy, $xlabel, $c_black);
	return 0;
}


?>
