<?php
/*
 * netinfo-imagedata.php - Image Data generation source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
#include 'page-functions.php';
include 'netinfo-config-variables.php';

#include 'alert.dbtable.class.inc';


header ('Content-type: text/plain');

/*** If not authenticated, don't display the data */
if (!session_is_registered ('authenticated')) {
	return 0;
}

# DST device mapping
$dst_map_ip = array (
		'ASA-5540' => '10.64.99.10',
		'ASP-FWSM' => '10.64.80.1',
		'MGMT-ASA' => '10.64.0.2'
);


# Number of items on the security graphs (default)
$graph_ip_items=15;
$graph_port_items=10;


$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}


/*** Display the requested image */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if (isset($_GET['reportstartdate'])) {
		if (is_valid_date ($_GET['reportstartdate'])) {
			$report_start_date = $_GET['reportstartdate'];
		} else {
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_start_date = date ("Y-m-d", time());
	}
	if (isset($_GET['reportenddate'])) {
		if (is_valid_date ($_GET['reportenddate'])) {
			$report_end_date = $_GET['reportenddate'];
		} else {
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_end_date = $report_start_date;
	}
	if (isset($_GET['reporthostname'])) {
		if ($_GET['reporthostname'] != "") {
			$report_hostname = $_GET['reporthostname'];
		} else {
			mysql_close ($conn);
			return 1;
		}
	} else {
		$report_hostname = "";
	}
	if (isset($_GET['slareport_id'])) {
		if (is_valid_integer ($_GET['slareport_id'])) {
			$slareport_id = $_GET['slareport_id'];
		} else {
			mysql_close ($conn);
			return 1;
		}
	} else {
		$slareport_id = 1;
	}


	if (!isset($_GET['imagename']) || $_GET['imagename'] == "") {
		#print "<p>Report generation</p>\n";

	} else if ($_GET['imagename'] == "alertsbyclass") {
		generate_alertsbyclass ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertsbystate") {
		generate_alertsbystate ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertsbyseverity") {
		generate_alertsbyseverity ($report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbytcpport") {
		generate_alertstopscanbytcpport ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbyudpport") {
		generate_alertstopscanbyudpport ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "alertstopscanbyaddress") {
		generate_alertstopscanbyaddress ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else if ($_GET['imagename'] == "slareport_monthly") {
		generate_slareport_monthly_image ($slareport_id);

	} else if ($_GET['imagename'] == "alertdaterangebyday") {
		generate_alertdaterangebyday ($report_hostname,
					$report_start_date,
					$report_end_date);

	} else {
		#session_error ();
	}
}

mysql_close ($conn);
return 0;


/************************************************************************/
/* Render the alertsbyclass image					*/
/************************************************************************/
function generate_alertsbyclass ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;

	$class = $_SESSION['AlertClass'];
	$sql = "select a_class as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_class";
	$result = mysql_query ($sql);
	if ($result) {
		print "#AlertClass,Count\n";
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			print $class[$r['title']] . "," . $r['count'] . "\n";
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	return 0;
}



/************************************************************************/
/* Render the alertsbystate image					*/
/************************************************************************/
function generate_alertsbystate ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	
	$state = $_SESSION['AlertState'];
	$sql = "select a_state as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_state";
	$result = mysql_query ($sql);
	if ($result) {
		print "#AlertState,Count\n";
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			print $state[$r['title']] . "," . $r['count'] . "\n";
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	return 0;
}


/************************************************************************/
/* Render the alertsbyseverity image				*/
/************************************************************************/
function generate_alertsbyseverity ($report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	
	$sev = $_SESSION['AlertSeverity'];
	$sql = "select a_severity as 'title', count(*) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' group by a_severity";
	$result = mysql_query ($sql);
	if ($result) {
		print "#AlertSeverity,Count\n";
		$total = 0;
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			print $sev[$r['title']] . "," . $r['count'] . "\n";
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	return 0;
}


/************************************************************************/
/* Render the alertstopscanbytcpport image				*/
/************************************************************************/
function generate_alertstopscanbytcpport ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_port_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$title = "#TopTCPPortsScanned";
		if ($report_hostname != "") {
			$title .= " - $report_hostname";
		}
		print $title . "\n";
		print "#Port,Count\n";
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/on tcp port ([0-9]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		foreach ($tarray as $n) {
			print $n['title'] . "," . $n['count'] . "\n";
			$count++;
			if ($count >= $graph_port_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	return 0;
}


/************************************************************************/
/* Render the alertstopscanbyudpport image				*/
/************************************************************************/
function generate_alertstopscanbyudpport ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_port_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$title = "#TopUDPPortsScanned";
		if ($report_hostname != "") {
			$title .= " - $report_hostname";
		}
		print $title . "\n";
		print "#Port,Count\n";
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/on udp port ([0-9]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		foreach ($tarray as $n) {
			print $n['title'] . "," . $n['count'] . "\n";
			$count++;
			if ($count >= $graph_port_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	return 0;
}


/************************************************************************/
/* Render the alertstopscanbyaddress image				*/
/************************************************************************/
function generate_alertstopscanbyaddress ($report_hostname, $report_start_date, $report_end_date)
{
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	global $graph_ip_items;
	
	$sql = "select a_message as 'title' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$result = mysql_query ($sql);
	if ($result) {
		$title = "#TopScansByIPAddress";
		if ($report_hostname != "") {
			$title .= " - $report_hostname";
		}
		print $title . "\n";
		print "#IPAddress,Count\n";
		$row = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			if (preg_match ("/from ([0-9\.]+)/", $r['title'], $match) == 1) {
				$row[$match[1]]++;
			}
		}
		mysql_free_result ($result);
		$tarray = array ();
		foreach ($row as $n => $v) {
			$tarray[] = array ('title' => $n, 'count' => $v);
		}
		usort ($tarray, assoc_compare_r);
		$count = 0;
		foreach ($tarray as $n) {
			print $n['title'] . "," . $n['count'] . "\n";
			$count++;
			if ($count >= $graph_ip_items) {
				break;
			}
		}
	} else {
		return 1;
	}
	return 0;
}


/************************************************************************/
/* Render the alertdaterangebyday image				*/
/************************************************************************/
function generate_alertdaterangebyday ($report_hostname, $report_start_date, $report_end_date)
{
	global $image;
	global $g_width;
	global $g_height;
	global $dst_map_ip;
	
	#$sql = "select dayofmonth(a_alerttime) as 'date', count(1) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	#$sql = "select date_format(a_alerttime, '%m-%d') as 'date', count(1) as 'count' from alert where date(a_alerttime) between date(date_sub(NOW(), INTERVAL 1 MONTH)) and date(NOW()) and a_class = 4 and a_object like '%scan%'";
	$sql = "select date_format(a_alerttime, '%m-%d') as 'date', count(1) as 'count' from alert where date(a_alerttime) between '$report_start_date' and '$report_end_date' and a_class = 4 and a_object like '%scan%'";
	if ($report_hostname != "") {
		$sql .= " and a_hostname = '$dst_map_ip[$report_hostname]'";
	}
	$sql .= " group by 1 asc";
	$result = mysql_query ($sql);
	if ($result) {
		$count = 0;
		$column = array ();
		while ($r = mysql_fetch_assoc ($result)) {
			$column[] = array ('title' => $r['date'], 'count' => $r['count']);
			$count++;
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}
	/* Discard the small image */
	imagedestroy ($image);
	
	/* Create a new image */
	$g_width = 50 + ($count * 16);
	if ($g_width < 400) {
		$g_width = 400;
	}
	$g_height = 240;
	$image = imagecreate ($g_width, $g_height);
	$c_black = imagecolorallocate ($image, 0, 0, 0);
	$c_white = imagecolorallocate ($image, 255, 255, 255);
	$c_red = imagecolorallocate ($image, 255, 0, 0);
	$c_green = imagecolorallocate ($image, 0, 255, 0);
	$c_blue = imagecolorallocate ($image, 0, 0, 255);
	$c_ltgrey = imagecolorallocate ($image, 200, 200, 200);
	imagefill ($image, 0, 0, $c_white);

	$title = "Scans - $report_start_date to $report_end_date";
	if ($report_hostname != "") {
		$title .= " - $report_hostname";
	}
	$rc = generate_bargraph_2axis_vertical_2 ($title,
					$g_width,
					$g_height,
					"Scans",
					$column);
	return $rc;
}


/************************************************************************/
/* Render a two-axis bargraph image					*/
/************************************************************************/
function generate_bargraph_2axis ($title, $width, $height, $xlabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;


	# Graph defaults
	$xbase = 15;
	#$ybase = 360;
	$ybase = $height - 30;
	$x_interbar = 10;
	$space = 5;
	
	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	foreach ($column as $c) {
		$total += $c['count'];
		$count++;
	}

	# Calculate spacers, etc
	$iw = ($width - $xbase - $x_interbar - $x_interbar) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 75) {
		# Clamp the bar width
		$bw = 75;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;
		$h = $ybase * ($c['count'] / $total);
		$y = $ybase - $h;
		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $c_red);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column counter
		$tw = $f1s * strlen ($c['count']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				1,
				$sx,
				$ybase + $space,
				$c['count'],
				$c_black);

		# Draw the column title
		$tw = $f2s * strlen ($c['title']);
		if ($tw > $bw) {
			$tw = $bw;
		}
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				2,
				$sx,
				$height - ($x_interbar + $space), $c['title'],
				$c_black);
		$x += $bw;
	}

	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $x_interbar, $title, $c_black);

	# x-axis label
	$tw = $f1s * strlen ($xlabel);
	$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	imagestringup ($image, 2, $xbase - ($x_interbar + $space), $sy, $xlabel, $c_black);
	return 0;
}


/************************************************************************/
/* assoc_compare - Compare the 'count' values of two assoc arrays	*/
/************************************************************************/
function assoc_compare ($a, $b)
{
	if ($a['count'] == $b['count']) {
		return 0;
	}
	return ($a['count'] < $b['count']) ? -1 : 1;
}


/************************************************************************/
/* assoc_compare_r - (reverse)Compare the 'count' values of two assoc arrays	*/
/************************************************************************/
function assoc_compare_r ($a, $b)
{
	if ($a['count'] == $b['count']) {
		return 0;
	}
	return ($a['count'] > $b['count']) ? -1 : 1;
}


/************************************************************************/
/* Render a two-axis bargraph image with vertical bar labels		*/
/************************************************************************/
function generate_bargraph_2axis_vertical ($title, $width, $height, $xlabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;


	# Graph defaults
	$xbase = 15;
	#$ybase = 360;
	$ybase = $height - 30;
	$x_interbar = 10;
	$space = 5;
	$bar_y_clamp = ($x_interbar * 2) + $space;

	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	foreach ($column as $c) {
		$total += $c['count'];
		$count++;
	}

	# Calculate spacers, etc
	$iw = ($width - $xbase - $x_interbar - $x_interbar) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 25) {
		# Clamp the bar width
		$bw = 25;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;
		$h = ($ybase - $bar_y_clamp) * ($c['count'] / $total);
		$y = $ybase - $h;
		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $c_red);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column counter
		$tw = $f1s * strlen ($c['count']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				1,
				$sx,
				$ybase + $space,
				$c['count'],
				$c_black);

		# Draw the column title
		$tw = $f2s * strlen ($c['title']);
		if ($tw > ($h + $space + $space)) {
			$sy = $ybase - $h - $space;
		} else {
			$sy = $ybase - $space;
		}
		imagestringup ($image,
				2,
				$x + $bc - $space,
				$sy,
				$c['title'],
				$c_black);
		$x += $bw;
	}

	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $x_interbar, $title, $c_black);

	# x-axis label
	$tw = $f1s * strlen ($xlabel);
	$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	imagestringup ($image, 2, $xbase - ($x_interbar + $space), $sy, $xlabel, $c_black);
	return 0;
}


/************************************************************************/
/* Render the slareport monthly image					*/
/************************************************************************/
function generate_slareport_monthly_image ($slareport_id)
{
	global $g_width;
	global $g_height;

	/*
	 * TODO: Pull the month/year from the sr_id
	*/
	$year = 2009;
	$month = 2;
	
	$monthdays = cal_days_in_month (CAL_GREGORIAN, $month, $year);
	$day = array ();

	/*
	 * Initially fill the array items to 100.00%
	*/
	$i = 1;
	while ($i <= $monthdays) {
		$date = sprintf ("%02d", $i);
		$day[$date] = 100.00;
		$i++;
	}

	/*
	 * Pull/calculate the daily uptime values
	*/
	$sql = "select dayofmonth(soi_starttime) as 'date', ((54000-sum(soi_seconds))/54000)*100.0 as 'uptime' from slareport_outage_item where soi_sr_id = $slareport_id and soi_visible = 1 group by 1";
	$result = mysql_query ($sql);
	if ($result) {
		$total = 0;
		while ($r = mysql_fetch_assoc ($result)) {
			$d = $r['date'];
			$day[$d] = sprintf ("%0.2f", $r['uptime']);
		}
		mysql_free_result ($result);
	} else {
		return 1;
	}

	$row = array ();
	$i = 1;
	foreach ($day as $date => $uptime) {
		$row[] = array ('title' => $date, 'count' => $uptime);
	}

	/*
	 * Generate the graph
	*/
	$title = "Daily SLA Level";
	$rc = generate_bargraph_2axis_sla ($title,
					700,
					250,
					"Uptime %",
					$row);
	return $rc;
}


/************************************************************************/
/* Render a two-axis bargraph image with vertical bar labels		*/
/************************************************************************/
function generate_bargraph_2axis_sla ($title, $width, $height, $ylabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;

	/* Discard the small image */
	imagedestroy ($image);
	
	/* Create a new image */
	$image = imagecreate ($width, $height);
	$c_black = imagecolorallocate ($image, 0, 0, 0);
	$c_white = imagecolorallocate ($image, 255, 255, 255);
	$c_red = imagecolorallocate ($image, 255, 0, 0);
	$c_green = imagecolorallocate ($image, 0, 255, 0);
	$c_blue = imagecolorallocate ($image, 0, 0, 255);
	$c_ltgrey = imagecolorallocate ($image, 200, 200, 200);
	imagefill ($image, 0, 0, $c_white);

	# Graph defaults
	$sla = 99.50;
	$maximum = 100.00;
	$xbase = 60;
	$ybottom = 30;
	$ybase = $height - $ybottom;
	$x_interbar = 2;
	$y_interbar = 10;
	$space = 5;
	$bar_y_clamp = (2 * $y_interbar) + $space;

	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	$minimum = $maximum;
	foreach ($column as $c) {
		$total += $c['count'];
		if ($c['count'] < $minimum) {
			$minimum = $c['count'];
		}
		$count++;
	}
	if ($minimum > $sla) {
		$minimum = $sla;
	}
	$minimum = floor ($minimum - 1.00);
	$range = $maximum - $minimum;
	$ypixrange = $ybase - $bar_y_clamp;
	$pixfactor = $ypixrange / $range;

	# Calculate spacers, etc
	$iw = ($width - $xbase - ($x_interbar * 3)) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 25) {
		# Clamp the bar width
		$bw = 25;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;

		if ($c['count'] > $sla) {
			$color = $c_green;
		} else {
			$color = $c_red;
		}
		
		$y = $bar_y_clamp + (($maximum - $c['count']) * $pixfactor);

		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $color);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column title
		$tw = $f1s * strlen ($c['title']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestring ($image,
				1,
				$sx,
				$ybase + $space,
				$c['title'],
				$c_black);

		# Draw the column counter
		$text = sprintf ("%0.2f %%", $c['count']);
		$tw = $f2s * strlen ($text);
		$h = $ybase - $y;
		if ($tw > ($h + $space + $space)) {
			$sy = $ybase - $h - $space;
		} else {
			$sy = $ybase - $space;
		}
		imagestringup ($image,
				2,
				$x + $bc - $space,
				$sy,
				$text,
				$c_black);
		$x += $bw;
	}

	# Draw the SLA line
	$y = $bar_y_clamp + (($maximum - $sla) * $pixfactor);
	#imageline ($image, $xbase, $y-1, $width - $space, $y-1, $c_red);
	imageline ($image, $xbase, $y, $width - $space, $y, $c_red);
	#imageline ($image, $xbase, $y+1, $width - $space, $y+1, $c_red);
	$f3s = imagefontwidth (3);
	$text = sprintf ("%0.2f %%", $sla);
	$tw = $f3s * strlen ($text);
	imagestring ($image, 3, $xbase - $tw - $space, $y - 5, $text, $c_red);

	# Draw the minimum line
	$y = $bar_y_clamp + (($maximum - $minimum) * $pixfactor);
	imageline ($image, $xbase, $y, $width - $space, $y, $c_black);
	$f3s = imagefontwidth (3);
	$text = sprintf ("%0.2f %%", $minimum);
	$tw = $f3s * strlen ($text);
	imagestring ($image, 3, $xbase - $tw - $space, $y - 5, $text, $c_black);


	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $y_interbar, $title, $c_black);

	# y-axis label
	$tw = $f3s * strlen ($ylabel);
	#$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	$sy = ($height/2) + ($tw/2) - ($ybottom/2);
	imagestringup ($image, 3, $xbase - (3 * $space), $sy, $ylabel, $c_black);
	return 0;
}


/************************************************************************/
/* Render a two-axis bargraph image with vertical bar labels		*/
/************************************************************************/
function generate_bargraph_2axis_vertical_2 ($title, $width, $height, $xlabel, $column)
{
	global $image;
	global $c_black;
	global $c_white;
	global $c_red;
	global $c_green;
	global $c_blue;
	global $c_ltgrey;


	# Graph defaults
	$xbase = 15;
	#$ybase = 360;
	$ybottom = 30;
	$ybase = $height - 40;
	$x_interbar = 5;
	$space = 5;
	$bar_y_clamp = ($x_interbar * 2) + $space;

	# Image background color
	imagefill ($image, 0, 0, $c_white);
	
	# Graph background color
	imagefilledrectangle ($image, $xbase+1, $ybase, $width - $space, $space, $c_ltgrey);

	# Scale counters
	$total = 0;
	$count = 0;
	$maximum = 0;
	foreach ($column as $c) {
		$total += $c['count'];
		if ($c['count'] > $maximum) {
			$maximum = $c['count'];
		}
		$count++;
	}
	$range = $maximum;
	$ypixrange = $ybase - $bar_y_clamp;
	$pixfactor = $ypixrange / $range;

	# Calculate spacers, etc
	$iw = ($width - $xbase - $x_interbar - $x_interbar) / $count;
	$bw = $iw - $x_interbar;
	if ($bw > 25) {
		# Clamp the bar width
		$bw = 25;
	}
	$bc = $bw / 2;
	$f1s = imagefontwidth (1);
	$f2s = imagefontwidth (2);

	# Draw the bargraph
	$x = $xbase;
	$i = 0;
	foreach ($column as $c) {
		# Draw the bar
		$i++;
		$x += $x_interbar;

		#$h = ($ybase - $bar_y_clamp) * ($c['count'] / $total);
		#$y = $ybase - $h;
		$y = $bar_y_clamp + (($maximum - $c['count']) * $pixfactor);

		imagefilledrectangle ($image, $x, $ybase, $x+$bw, $y, $c_red);
		imagerectangle ($image, $x, $ybase, $x+$bw, $y, $c_black);

		# Draw the column title 
		$tw = $f2s * strlen ($c['title']);
		$sx = (($bw - $tw) / 2) + $x;
		imagestringup ($image,
				2,
				$sx + $f2s + 2,
				$ybase + $space + $tw,
				$c['title'],
				$c_black);

		# Draw the column counter
		$tw = $f2s * strlen ($c['count']);
		$h = $ybase - $y;
		if ($tw > ($h + $space + $space)) {
			$sy = $ybase - $h - $space;
		} else {
			$sy = $ybase - $space;
		}
		imagestringup ($image,
				2,
				$x + $bc - $space,
				$sy,
				$c['count'],
				$c_black);
		$x += $bw;
	}

	# Graph borders
	imageline ($image, $xbase, $ybase+1, $width - $space, $ybase+1, $c_black);
	imageline ($image, $xbase, $ybase, $xbase, $space, $c_black);

	# Title
	$tw = $f1s * strlen ($title);
	$sx = (($width - $tw) / 2);
	imagestring ($image, 3, $sx - $space, $x_interbar, $title, $c_black);

	# y-axis label
	$tw = $f1s * strlen ($xlabel);
	#$sy = (($ybase - $tw) / 2) + ($height - $ybase);
	$sy = ($height/2) + ($tw/2) - ($ybottom/2);
	imagestringup ($image, 2, $xbase - (3 * $space), $sy, $xlabel, $c_black);
	return 0;
}


?>
