<?php


include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';
#include 'html.table.class.inc';

include 'alertdata.dbtable.class.inc';
include 'client.dbtable.class.inc';
include 'clientprocess.dbtable.class.inc';


$wsdlfile = "netinfo-webservices.wsdl";

if (isset($_GET['wsdl'])) {
	header ("Content-Type: text/xml");
	header ("Content-Length: text/xml" . filesize ($wsdlfile));
	ob_clean ();
	flush ();
	readfile ($wsdlfile);
	return 0;
}

#$conn = db_connect ();
#if ($conn == FALSE) {
#        print "<p>db_connect(): failed</p>\n";
#        return 2;
#}

ini_set("soap.wsdl_cache_enabled", "0"); 
$server = new SoapServer($wsdlfile); 
$server->addFunction("getAlertDetail"); 
$server->addFunction("oncallRequest"); 
$server->addFunction("getCPDetailByDate"); 
#$server->addFunction("getClientProcessDetailByDate"); 
$server->handle(); 


function getAlertDetail ($alertId)
{
	$val = "This is a test for AlertId# $alertId";
	return $val;
}


function oncallRequest ($requestor, $group, $hostname, $servicename, $message)
{
	$file = "/var/spool/oncall/message-$group-$hostname-$servicename-" . time ();
	$data = "ONCALL_REQUEST:$group:$hostname:$servicename:$requestor:$message\n";
	$pfd = fopen ($file, "w");
	if ($pfd === FALSE) {
		fault ("ERROR", "Failed to open spool file. Contact a system administrator.\n");
		return;
	}
	fwrite ($pfd, $data);
	fclose($pfd);
	return "The oncall request has been accepted.";
}

function getCPDetailByDate ($authuser)
{
	return "Username is $authuser";
}


function getClientProcessDetailByDate ($authuser, $authpassword, $clientnumber, $processname, $processdate)
{
	if ($authuser != "cpview_user" || $authpassword != "!Vie3wer%") {
		fault ("AUTHENTICATION", "Failed to authenticate you to the system.");
		return;
	}

	$conn = db_connect ();
	if ($conn == FALSE) {
		fault ("DB", "Failed to connect to the database.");
		return;
	}

	$xml = new DOMDocument ("1.0", "ISO-8859-15");
	$xml_client_number = $xml->createElement ("client_number", $clientnumber);
	$xml->appendChild ($xml_client_number);
	$xml_process_name = $xml->createElement ("process_name", $processname);
	$xml->appendChild ($xml_process_name);
	$xml_process_date = $xml->createElement ("process_date", $processdate);
	$xml->appendChild ($xml_process_date);

	$sql = "select a_id,ad_data";
	$sql .= " from alert,alert_data,client,client_process";
	$sql .= " where ad_a_id = a_id";
	$sql .= " and a_object = cp_object";
	$sql .= " and cp_c_id = c_id";
	$sql .= " and c_symbol = 'TFS'";
	$sql .= " and cp_name = 'downstream-daily'";
	$sql .= " and date(a_alerttime) = '2009-06-04'";
	$result = mysql_query ($sql, $conn);
 	if ($result === FALSE) {
		mysql_close ($conn);
		fault ("DB", "Failed to query the database.");
		return;
	}

	$xml_process_detail = $xml->createElement ("process_detail");
	while ($row = mysql_fetch_assoc ($result)) {
		$xml_process_item = $xml->createElement ("detail_entry", $row['ad_data']);
		$xml_process_detail->appendChild ($xml_process_item);
	}
	mysql_free_result ($result, $conn);
	$xml->appendChild ($xml_process_detail);

	mysql_close ($conn);
	return $xml->saveXML();
}


?>
