<?php


include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';
#include 'html.table.class.inc';

$wsdlfile = "netinfo-wspager.wsdl";

$GroupList = array ("IT" => "IT", "DBA" => "DBA");


if (isset($_GET['wsdl'])) {
	header ("Content-Type: text/xml");
	header ("Content-Length: text/xml" . filesize ($wsdlfile));
	ob_clean ();
	flush ();
	readfile ($wsdlfile);
	return 0;
}

#$conn = db_connect ();
#if ($conn == FALSE) {
#        print "<p>db_connect(): failed</p>\n";
#        return 2;
#}

ini_set("soap.wsdl_cache_enabled", "0"); 
$server = new SoapServer($wsdlfile); 
$server->addFunction("oncallRequest"); 
$server->handle(); 


function oncallRequest ($requestor, $group, $hostname, $servicename, $message)
{
	global $GroupList;

	# Sanity checks
	if ($message == "") {
		fault ("ARGUMENT", "The message field is required.\n");
		return;
	}
	if ($group == "") {
		fault ("ARGUMENT", "The group field is required.\n");
		return;
	}
	if (!isset($GroupList[$group])) {
		fault ("ARGUMENT", "The group field contains an invalid value.\n");
		return;
	}

	# Handle the request
	$file = "/var/spool/oncall/message-$group-$hostname-$servicename-" . time ();
	$data = "ONCALL_REQUEST:$group:$hostname:$servicename:$requestor:$message\n";
	$pfd = fopen ($file, "w");
	if ($pfd === FALSE) {
		fault ("ERROR", "Failed to open spool file. Contact a system administrator.\n");
		return;
	}
	fwrite ($pfd, $data);
	fclose($pfd);
	return "The oncall request has been accepted.";
}

?>
