<?php
/*
 * netinfo.php - Main source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'page-functions.php';
include 'netinfo-config-variables.php';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

if ($_SESSION['page'] == "alerts") {
	page_header (120);
} else {
	if ($_SESSION['page'] == "") {
		page_header (120);
	} else {
		page_header (300);
	}
}

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

$access = $_SESSION['accessrights'];

/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if ($_GET['view'] == "") {
		session_set_page ('alerts');
		display_navmenu ();
		display_alerts ();
		print "<p>page=" . $_SESSION['page'] . "</p>\n"; #DEBUG


	} else if ($_GET['view'] == "alerts") {
		session_set_page ('alerts');
		display_navmenu ();
		display_alerts ();
		print "<p>page=" . $_SESSION['page'] . "</p>\n"; #DEBUG

	} else if ($_GET['view'] == "alertdetail") {
		$_SESSION['a_id'] = $_GET['a_id'];
		display_navmenu ();
		display_alertdetail ();

	} else if ($_GET['view'] == "alertnotes") {
		$_SESSION['a_id'] = $_GET['a_id'];
		display_navmenu ();
		display_alertnotes ();

	} else if ($_GET['view'] == "alerthistory") {
		$_SESSION['a_id'] = $_GET['a_id'];
		display_navmenu ();
		#display_alerthistory ();

	} else if ($_GET['view'] == "preferences") {
		display_navmenu ();
		display_preferences ();

	} else if ($_GET['view'] == "configuration") {
		display_navmenu ();
		print "<tr><td><font color='white'><h4>This page is not finished yet.</h4></font></td></td>";

	} else if ($_GET['view'] == "help") {
		display_navmenu ();
		print "<tr><td><font color='white'><h4>This page is not finished yet.</h4></font></td></td>";

	} else if ($_GET['view'] == "logout") {
		session_end ();
		print "<tr><td><p>";
		print "<font color='white'>";
		print "You have been logged out.";
		print "</td></tr></p>";

	} else if ($_GET['view'] == "useraccesslist") {
		display_user_access_list ();

	} else {
		session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	#print "<p>" . print_r ($_POST) . "<br>page='" . $_SESSION['page'] . "'</p>";
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_create_cache ();
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	} else if ($_SESSION['page'] == "alertnotes") {
		if (isset ($_POST["add-alertnote"])) {
			session_set_page ('alertnoteadd');
			display_alertnote_add ();
		} else {
			display_navmenu ();
			display_alerts ();
		}

	} else if ($_SESSION['page'] == "alertdetail") {
		if (isset ($_POST["add-alertnote"])) {
			session_set_page ('alertnoteadd');
			display_alertnote_add ();
		} else if (isset ($_POST["alertack"]) && $access['Acknowledge'] == TRUE) {
			session_set_page ('alertacknowledge');
			display_alert_acknowledge ();
		} else if (isset ($_POST["alertresolve"]) && $access['Resolve'] == TRUE) {
			session_set_page ('alertresolve');
			display_alert_resolve ();
		} else if (isset ($_POST["alertdiagnose"])) {
			session_set_page ('alertdiagnose');
			display_alert_diagnose ();
		} else if (isset ($_POST["alertiterate"])) {
			iterate_alert ();
			session_set_page ('alertdetail');
			display_navmenu ();
			display_alertdetail ();
		} else {
			#session_set_page ('alertdetail');
			display_navmenu ();
			display_alertdetail ();
		}

	} else if ($_SESSION['page'] == "alertnoteadd") {
		if (isset ($_POST["savenote"])) {
			process_alertnote_add ();
		} else {
			session_set_page ('alerts');
			display_navmenu ();
			display_alerts ();
		}

	} else if ($_SESSION['page'] == "alertacknowledge") {
		if (isset ($_POST["acknowledge"])) {
			process_alert_acknowledge ();
		}
		session_set_page ('alertdetail');
		display_navmenu ();
		display_alertdetail ();

	} else if ($_SESSION['page'] == "alertresolve") {
		if (isset ($_POST["resolve"])) {
			process_alert_resolve ();
		}
		session_set_page ('alertdetail');
		display_navmenu ();
		display_alertdetail ();

	} else if ($_SESSION['page'] == "preferences") {
		if (isset ($_POST["prefcommit"])) {
			process_preferences ();
		}
		display_navmenu ();
		display_preferences ();

	} else if ($_SESSION['page'] == "alertdiagnose") {
			process_alert_diagnose ();

	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";


/*** Free resources */
mysql_close ($conn);

return 0;



/************************************************************************/
/* Render the Alert page						*/
/************************************************************************/
function display_alerts ()
{
	/*** Session Cache */
	session_create_cache ();
	$AlertClass = $_SESSION['AlertClass'];
	$AlertClassId = $_SESSION['AlertClassId'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$AlertSeverityId = $_SESSION['AlertSeverityId'];
	$AlertState = $_SESSION['AlertState'];
	$AlertStateId = $_SESSION['AlertStateId'];
	$Preference = $_SESSION['preferences'];

	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['AlertView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	/*** Alert Status Box ***/
	print "<tr>";
	print "<td align=left valign=top width=33%>";
	print "<TABLE CLASS='infoBox' BORDER=1 CELLSPACING=0 CELLPADDING=0>";
	print "<TR><TD CLASS='infoBox'>";
	print "<DIV CLASS='infoBoxTitle'>Current Alerts</DIV>";
	print "Last Updated: " . date("l, F j, Y g:i:s A T") . "<BR>";
	#print "Updated every 90 seconds<br>";
	print "</TD></TR>";
	print "</TABLE>";
	print "</td></tr>";

	print "<tr><td><p>&nbsp";
	print "</tr></td>";

	/*** Alert List ***/
	$sql = "select a_id,a_alerttime,a_class,a_severity,a_state,a_hostname,a_object,a_message ";
	$sql .= "from alert ";
	$sql .= "where 1 = 1 ";

	if (isset ($Preference['alert_view_display_state']) &&
       	    count ($Preference['alert_view_display_state']) > 0) {
		$slist = $Preference['alert_view_display_state'];
		$instr = "";
		foreach ($slist as $k) {
			if (isset ($AlertStateId[$k])) {
				if ($instr != "") {
					$instr .= ",";
				}
				$instr .= $AlertStateId[$k];
			}
		}
		$sql .= "and a_state in (" . $instr . ") ";
	} else {
		$sql .= "and a_state not in (5) ";
	}

	if (count ($Preference['alert_view_display_class']) > 0) {
		$slist = $Preference['alert_view_display_class'];
		$instr = "";
		foreach ($slist as $k) {
			if (isset ($AlertClassId[$k])) {
				if ($instr != "") {
					$instr .= ",";
				}
				$instr .= $AlertClassId[$k];
			}
		}
		$sql .= "and a_class in (" . $instr . ") ";
	}

	if (isset ($Preference['alert_view_display_severity']) &&
		$Preference['alert_view_display_severity'] != "") {
		$s = $Preference['alert_view_display_severity'];
		$severity = $AlertSeverityId[$s];
		$sql .= "and a_severity <= $severity ";
	}

	if (isset ($Preference['alert_view_display_state'])) {
		if ($Preference['alert_view_display_sort'] == 'Severity') {
			$sql .= "order by a_severity asc, a_id desc ";
		} else {
			$sql .= "order by a_id desc ";
		}
	} else {
		$sql .= "order by a_id desc ";
	}

	if ($Preference['alert_view_max_records'] > 0) {
		$sql .= " limit " . $Preference['alert_view_max_records'];
	}
	$result = mysql_query ($sql);
	if ($result) {
		print "<P>";
		print "<table class='tableList'>";
		print "<tr><th class='hostTitle' colspan='8'>Alerts</th></tr>\n";
		print "<tr>";
		print "<th class='hostHeader' width='40'>Actions</th>";
		print "<th class='hostHeader' width='110'>Timestamp</th>";
		print "<th class='hostHeader' width='50'>Class</th>";
		print "<th class='hostHeader' width='60'>Severity</th>";
		print "<th class='hostHeader' width='60'>State</th>";
		print "<th class='hostHeader' width='100'>Hostname</th>";
		print "<th class='hostHeader' width='80'>Object</th>";
		print "<th class='hostHeader' width='500'>Message</th></tr>\n";
		while ($row = mysql_fetch_row ($result)) {
			print "<tr>";
			$tclass = $AlertSeverity[$row[3]] . "Severity";
			$actionshtml = "<a class='$tclass' href='?view=alertdetail&a_id=" . $row[0] . "'>Details</a>";
			#$actionshtml .= "<a href='?view=alertnotes&a_id=" . $row[0] . "'>N</a>&nbsp";
			#$actionshtml .= "<a href='?view=alerthistory&a_id=" . $row[0] . "'>H</a>";
			print "<td class='" . $tclass . "'>" . $actionshtml . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[1] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertClass[$row[2]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertSeverity[$row[3]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $AlertState[$row[4]] . "</td>\n";
			$hostlink = "https://netscout2.asp.datascantech.com/nagios/cgi-bin/status.cgi?navbarsearch=1&host=" . $row[5];
			print "<td class='" . $tclass . "'><a class='$tclass' href='$hostlink'>" . $row[5] . "</a></td>\n";
			$perflink = "https://netscout2.asp.datascantech.com/nagios/cgi-bin/show.cgi?host=" . $row[5] . "&service=" . $row[6];
			print "<td class='" . $tclass . "'><a class='$tclass' href='$perflink'>" . $row[6] . "</a></td>\n";
			print "<td class='" . $tclass . "'>" . htmlentities ($row[7]) . "</td>\n";
			print "</tr>";
		}
		print "</table>\n";
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	session_set_page ("alerts");
	return;
}


/************************************************************************/
/* Render the AlertNotes page						*/
/************************************************************************/
function display_alertnotes ()
{
	global $AlertClass;
	global $AlertSeverity;
	global $AlertState;
	$adtid = $_SESSION['AlertDataTypeId'];
	$phppage = "netinfo.php";
	$aid = $_SESSION['a_id'];
	if (is_valid_integer ($aid) != 1) {
		session_error ();
		return;
	}
	$sql = "select ad_timestamp,ad_name,ad_type,ad_data from alert_data where ad_a_id = " . $aid;
	$sql .= " order by ad_id desc limit 100";
	$result = mysql_query ($sql);
	if ($result) {
		print "<P>";
		print "<form method='POST' action='" . $phppage . "'>";
		print "<table class='tableNote'>";
		print "<tr><th class='hostTitle' colspan='8'>Alert Data (limited to latest 100 entries)</th></tr>\n";
		print "<tr>";
		print "<th class='hostHeader' width='110'>Timestamp</th>";
		print "<th class='hostHeader' width='110'>Creator</th>";
		print "<th class='hostHeader' width='110'>Type</th>";
		print "<th class='hostHeader' width='600'>Message</th></tr>\n";
		$tclass = "textNote";
		while ($row = mysql_fetch_row ($result)) {
			print "<tr>";
			print "<td class='" . $tclass . "'>" . $row[0] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[1] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $adtid[$row[2]] . "</td>\n";
			print "<td class='" . $tclass . "'>" . str_replace ("\n", "<BR>", $row[3]) . "</td>\n";
			print "</tr>";
		}
		#print "<tr><td>&nbsp";
		#print "</tr></td>";
		print "<tr><td>";
		print "<input type='submit' name='add-alertnote' value='Add Entry'>";
		print "</tr></td>";
		print "</table>\n";
		mysql_free_result ($result);
		print "</form>";
		$_SESSION['a_id'] = $aid;
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
		return;
	}
	session_set_page ("alertnotes");
	return;
}


/************************************************************************/
/* Render the AlertNoteAdd page						*/
/************************************************************************/
function display_alertnote_add ()
{
	$phppage = "netinfo.php";
	/*** Navigation Menu ***/
	display_navmenu ();

	print "<form method='POST' action='" . $phppage . "'>";
	print "<table>";
	print "<tr><th class='hostTitle' colspan='8'>Alert Note Addition (for ID=" . $_SESSION['a_id'] . ")</th></tr>\n";
	print "<tr>";
	print "<td class='hostHeader' width='600'><textarea name='notetext' rows='20' cols='80'></textarea></td></tr>\n";
	print "</tr>";
	print "</table>";
	print "<p><input type='submit' name='savenote' value='Save Note'>&nbsp";
	print "<input type='submit' name='cancel' value='Cancel'></p>";
	print "</form>";
	session_set_page ("alertnoteadd");
	return;
}


/************************************************************************/
/* Process the AlertNoteAdd page					*/
/************************************************************************/
function process_alertnote_add ()
{
	$aid = $_SESSION['a_id'];
	$n = htmlentities($_POST['notetext']);
	
	$sql = sprintf ("insert into alert_data (ad_a_id,ad_name,ad_type,ad_data) values (%d,'%s',%d,'%s')",
			$aid,
			$_SESSION['username'],
			2,
			mysql_real_escape_string ($n));
	#print "<p><font color='red'>SQL: '" . $sql . "'</font></p>\n";
	$result = mysql_query ($sql);
	if ($result) {
		mysql_free_result ($result);
		alert_action ($aid, "Added alert note.");
		session_unregister('a_id');
		session_set_page ("alertnotes");
		display_navmenu ();
		display_alerts ();
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	return;
}


/************************************************************************/
/* Render the AlertHistory page						*/
/************************************************************************/
function display_alerthistory ()
{
	$aid = $_SESSION['a_id'];
	if (is_valid_integer ($aid) != 1) {
		session_error ();
		return;
	}
	/*** AlertHistory ***/
	$sql = "select aa_timestamp,aa_user,aa_info from alert_action where aa_a_id = " . $aid;
	$sql .= " order by aa_timestamp desc";
	$result = mysql_query ($sql);
	if ($result) {
		print "<P>";
		print "<table class='tableNote'>";
		print "<tr><th class='hostTitle' colspan='8'>Alert Actions (History)</th></tr>\n";
		print "<tr>";
		print "<th class='hostHeader' width='110'>Timestamp</th>";
		print "<th class='hostHeader' width='80'>Username</th>";
		print "<th class='hostHeader' width='600'>Message</th></tr>\n";
		$tclass = "textNote";
		while ($row = mysql_fetch_row ($result)) {
			print "<tr>";
			print "<td class='" . $tclass . "'>" . $row[0] . "</td>\n";
			print "<td class='" . $tclass . "'>" . $row[1] . "</td>\n";
			print "<td class='" . $tclass . "'>" . htmlentities ($row[2]) . "</td>\n";
			print "</tr>";
		}
		print "</table>\n";
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
	session_set_page ("alerthistory");
	return;
}



/************************************************************************/
/* Render the Preferences page						*/
/************************************************************************/
function display_preferences ()
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['PreferenceView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$AlertClass = $_SESSION['AlertClass'];
	$AlertState = $_SESSION['AlertState'];
	$phppage = "netinfo.php";
	$pref = $_SESSION['preferences'];
	$preflist = array ('alert_view_max_records' => "Maximum Alerts to Display",
			'alert_view_style' => "Alert Style");
	#$preflist = array ('alert_view_max_records' => "Maximum Alerts to Display",
	#		'alert_view_display_state' => "Alert States to Display (commalist)",
	#		'alert_view_display_class' => "Alert Classes to Display (commalist)");
	print "<p>";
	print "<form method='POST' action='" . $phppage . "'>";
	print "<table>";
	print "<tr>";
	print "<th class='hostHeader' width='120'>Preference</th>\n";
	print "<th class='hostHeader' width='300'>Value</th>\n";
	print "</tr>";
	
	foreach ($preflist as $key => $name) {
		print "<tr>";
		print "<th class='hostHeader' width='120'>" . $name . "</th>\n";
		print "<th class='textDetail'><input type='text' name='" . $key . "' value='" . $pref[$key] . "'></th>\n";
		print "</tr>";
	}

	print "<tr>";
	print "<th class='hostHeader' width='120'>Alert States to Display</th>\n";
	$a = $pref['alert_view_display_state'];
	#print_r ($a);
	print "<th class='textDetail'>" . html_multiselect_button('alert_view_display_state', $AlertState, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Alert Classes to Display</th>\n";
	$a = $pref['alert_view_display_class'];
	print_r ($a);
	print "<th class='textDetail'>" . html_multiselect_button('alert_view_display_class', $AlertClass, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th><input type='submit' name='prefcommit' value='Commit Changes'></th>\n";
	print "</tr>";

	print "</table>";
	print "</form>";
	print "</p>";
	session_set_page ("preferences");
	return;
}


/************************************************************************/
/* Render the AlertDetail page						*/
/************************************************************************/
function display_alertdetail ()
{
	$phppage = "netinfo.php";
	$aid = $_SESSION['a_id'];
	if (is_valid_integer ($aid) != 1) {
		session_error ();
		return;
	}

	$AlertClass = $_SESSION['AlertClass'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$AlertState = $_SESSION['AlertState'];

	print "<tr><td><p>&nbsp";
	print "</tr></td>";

	/*** Alert Detail ***/
	$sql = "select a_id,a_alerttime,a_lasttime,a_class,a_severity,a_state,a_uniqueid,a_hitcount,a_hostname,a_object,a_message,a_uniquestr from alert where a_id = ". $aid;
	$result = mysql_query ($sql);
	if ($result) {
		$row = mysql_fetch_row ($result);
		$tclass = $AlertSeverity[$row[4]] . "Severity";
		print "<P>";
		print "<form method='POST' action='" . $phppage . "'>";
		print "<table class='tableDetail'>";
		print "<tr><th class='hostTitle' colspan='2'>Alert Detail</th></tr>\n";
		print "<tr>";
		print "<td class='hostHeader' width='120'>Alert ID</td>";
		print "<td class='textDetail' width='600'>" . $row[0] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Hostname</td>";
		$hostlink = "https://netscout2.asp.datascantech.com/nagios/cgi-bin/status.cgi?navbarsearch=1&host=" . $row[8];
		print "<td class='textDetail'><a href='$hostlink'>" . $row[8] . "</a></td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Object</td>";
		$perflink = "https://netscout2.asp.datascantech.com/nagios/cgi-bin/show.cgi?host=" . $row[8] . "&service=" . $row[9];
		print "<td class='textDetail'><a href='$perflink'>" . $row[9] . "</a></td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Message</td>\n";
		print "<td class='textDetail'>" . $row[10] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Class</td>";
		print "<td class='textDetail'>" . $AlertClass[$row[3]] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Severity</td>";
		print "<td class='" . $tclass . "'>" . $AlertSeverity[$row[4]] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>State</td>";
		print "<td class='textDetail'>" . $AlertState[$row[5]] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Initial Event</td>";
		print "<td class='textDetail'>" . $row[1] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Last Event</td>";
		print "<td class='textDetail'>" . $row[2] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Hit Count</td>";
		print "<td class='textDetail'>" . $row[7] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Unique ID</td>";
		print "<td class='textDetail'>" . $row[6] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td class='hostHeader'>Unique Str</td>";
		print "<td class='textDetail'>" . $row[11] . "</td>\n";
		print "</tr>";
		print "<tr>";
		print "<td colspan='2'>";
		print "<table border='0' width='100%'><tr>";
		if ($AlertState[$row[5]] == "Acknowledged" ||
		    $AlertState[$row[5]] == "Resolved") {
			print "<td width='8%' align='left'><input type='submit' disabled name='alertack' value='Acknowledge'></td>";
		} else {
			print "<td width='8%' align='left'><input type='submit' name='alertack' value='Acknowledge'></td>";
		}
		print "&nbsp";
		if ($AlertState[$row[5]] == "Resolved") {
			print "<td width='8%' align='left'><input type='submit' disabled name='alertresolve' value='Resolve'></td>";
		} else {
			print "<td width='8%' align='left'><input type='submit' name='alertresolve' value='Resolve'></td>";
		}
		print "&nbsp";
		if ($AlertState[$row[5]] != "Resolved") {
			print "<td width='8%' align='left'><input type='submit' name='alertdiagnose' value='Diagnose'></td>";
		} else {
			print "<td width='8%' align='left'><input type='submit' disabled name='alertdiagnose' value='Diagnose'></td>";
		}
		print "</td>";

		print "<td width='25%' align='right'><input type='submit' name='alertiterate' value='Previous'></td>";
		print "<td width='8%' align='right'><input type='submit' name='alertiterate' value='Next'></td>";
		print "</tr></table>";
		print "</tr>";
		print "</table>\n";
		print "</form>";
		mysql_free_result ($result);
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}

	print "<tr><td><p>&nbsp";
	print "</tr></td>";
	display_alertnotes ();

	print "<tr><td><p>&nbsp";
	print "</tr></td>";
	#display_alerthistory ();

	session_set_page ("alertdetail");
	return;
}


/************************************************************************/
/* Process the Preferences page						*/
/************************************************************************/
function process_preferences ()
{
	$pref = $_SESSION['preferences'];
	$maxalerts = $_POST['alert_view_max_records'];
	if (is_valid_integer ($maxalerts) != 1) {
		print "<p><font color='red'>The 'Max Alerts' field must be an integer value.</font></p>\n";
		#session_error ();
		return;
	}
	$alertstates = $_POST['alert_view_display_state'];
	$alertclasses = $_POST['alert_view_display_class'];

	$pref['alert_view_max_records'] = $maxalerts;
	$pref['alert_view_display_state'] = $alertstates;
	$pref['alert_view_display_class'] = $alertclasses;
	$_SESSION['preferences'] = $pref;
	
/*
	$sql = "insert into alert_data (ad_a_id,ad_name,ad_data) values (" . $aid . ",'NOTE','" . $n . "')";
	print "<p><font color='red'>SQL: '" . $sql . "'</font></p>\n";
	$result = mysql_query ($sql);
	if ($result) {
		alert_action ($aid, "Added alert note.");
		session_unregister('a_id');
		session_set_page ("alertnotes");
		display_navmenu ();
		display_alerts ();
	} else {
		print "<font color='red'><P>mysql_query(): " . mysql_error () . "</p>\n";
		print "<P>SQL: '" . $sql . "'</p></font>\n";
	}
*/

	return;
}


function iterate_alert ()
{
	$aid = $_SESSION['a_id'];
	if (is_valid_integer ($aid) != 1) {
		session_error ();
		return;
	}
	$sql = "select a_id from alert " . alert_sql_generate_where_from_preferences ();
	if ($_POST['alertiterate'] == "Next") {
		$sql .= " and a_id > " . $aid . " order by 1 asc limit 1";	
	} else if ($_POST['alertiterate'] == "Previous") {
		$sql .= " and a_id < " . $aid . " order by 1 desc limit 1";	
	}
	$result = mysql_query ($sql);
	if ($result) {
		if (mysql_num_rows ($result) == 1) {
			$row = mysql_fetch_row ($result);
			$_SESSION['a_id'] = $row[0];
		}
		mysql_free_result ($result);
	}
	return;
}


function alert_sql_generate_where_from_preferences ()
{
	$AlertClass = $_SESSION['AlertClass'];
	$AlertClassId = $_SESSION['AlertClassId'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$AlertSeverityId = $_SESSION['AlertSeverityId'];
	$AlertState = $_SESSION['AlertState'];
	$AlertStateId = $_SESSION['AlertStateId'];
	$Preference = $_SESSION['preferences'];
	/*** Alert Where ***/
	$sql .= " where 1 = 1 ";
	if (isset ($Preference['alert_view_display_state']) &&
       	    count ($Preference['alert_view_display_state']) > 0) {
		$slist = $Preference['alert_view_display_state'];
		$instr = "";
		foreach ($slist as $k) {
			if (isset ($AlertStateId[$k])) {
				if ($instr != "") {
					$instr .= ",";
				}
				$instr .= $AlertStateId[$k];
			}
		}
		$sql .= "and a_state in (" . $instr . ") ";
	} else {
		$sql .= "and a_state not in (5) ";
	}
	if (count ($Preference['alert_view_display_class']) > 0) {
		$slist = $Preference['alert_view_display_class'];
		$instr = "";
		foreach ($slist as $k) {
			if (isset ($AlertClassId[$k])) {
				if ($instr != "") {
					$instr .= ",";
				}
				$instr .= $AlertClassId[$k];
			}
		}
		$sql .= "and a_class in (" . $instr . ") ";
	}
	if (isset ($Preference['alert_view_display_severity']) &&
		$Preference['alert_view_display_severity'] != "") {
		$s = $Preference['alert_view_display_severity'];
		$severity = $AlertSeverityId[$s];
		$sql .= "and a_severity <= $severity ";
	}
	$sql .= " ";
	return $sql;
}



?>

