<?php
/*
 * oncall.php - OnCall source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'netinfo-config-variables.php';
include 'html.table.class.inc';

include 'contact.dbtable.class.inc';
include 'oncallschedule.dbtable.class.inc';
include 'calendar.class.inc';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (-1);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}


display_navmenu ();


$pagemenu = array ();
if (user_has_access_right ('AdminOncallEdit') || user_has_access_right ('OncallView')) {
	$pagemenu['oncallcalendar'] = 'Oncall_Calendar';
	$pagemenu['oncallschedulelist'] = 'Oncall_Schedule';
	$pagemenu['contactlist'] = 'Contacts';
}
render_page_menu ($pagemenu);


/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if ($_GET['view'] == "") {
		#print "<tr><td><font color='white'><h4>";
		#print "This is the administration page.</h4></font></td></td>";
		display_oncall_calendar ();

	/* contact/oncall */
	} else if ($_GET['view'] == "contactlist") {
		unset ($_SESSION['c_id']);
		display_contact_list ();

	} else if ($_GET['view'] == "contactedit") {
		display_contact ("", "");

	} else if ($_GET['view'] == "contactdelete") {
		$rcr = delete_contact ();
		display_contact_list ();

	} else if ($_GET['view'] == "oncallcalendar") {
		display_oncall_calendar ();

	} else if ($_GET['view'] == "oncallschedulelist") {
		unset ($_SESSION['os_id']);
		display_oncall_schedule_list ("", "");

	} else if ($_GET['view'] == "oncallscheduleedit") {
		display_oncall_schedule ("", "");

	} else if ($_GET['view'] == "oncallscheduledelete") {
		$rcr = delete_oncall_schedule ();
		display_oncall_schedule_list ();

	/* unknown */
	} else {
		print "<tr><td><font color='white'><h4>";
		print "This page is not finished yet.</h4></font></td></td>";
		#session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	/* contacts */
	} else if ($_SESSION['page'] == "contactlist") {
		if (isset ($_POST["addcontact"])) {
			display_contact ("", "");
		} else {
			display_contact_list ();
		}

	} else if ($_SESSION['page'] == "contactedit") {
		$ctable = new ContactDbTableClass ();
		$data = $ctable->OnlyColumns ($_POST);
		if (isset ($_POST['addcontact'])) {
			unset ($data['c_id']);
			$rcr = $ctable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$rcr = $ctable->InsertRecord ($data);
				if ($rcr[0] == 0) {
					$data = $ctable->PostInsertSetPkey ($data);
					$_SESSION['c_id'] = $data['c_id'];
				}
			}
			display_contact ($data, $rcr);
		} else if (isset ($_POST['updatecontact']) && isset ($_SESSION['c_id'])) {
			if ($_SESSION['c_id'] != $_POST['c_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $ctable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$rcr = $ctable->UpdateRecord ($data);
					if ($rcr[0] == 0) {
						$_SESSION['c_id'] = $data['c_id'];
					}
				}
			}
			display_contact ($data, $rcr);
		} else {
			display_contact ();
		}

	} else if ($_SESSION['page'] == "oncallschedulelist") {
		if (isset ($_POST["addoncallschedule"])) {
			display_oncall_schedule ("", "");
		} else {
			display_oncall_schedule_list ("", "");
		}

	} else if ($_SESSION['page'] == "oncallscheduleedit") {
		$ostable = new OncallScheduleDbTableClass ();
		$data = $ostable->OnlyColumns ($_POST);
		if (isset ($_POST['addoncallschedule'])) {
			unset ($data['os_id']);
			$rcr = $ostable->ValidateValues ($data);
			if ($rcr[0] == 0) {
				$ctable = new ContactDbTableClass ();
				$ctable->SetWhere ("c_username = '" . $_POST['c_username'] . "'");
				$cdata = $ctable->GetPageData (1);
				$r = $cdata[0];
				if (isset ($r['c_id'])) {
					$data['os_c_id'] = $r['c_id'];
					$rcr = $ostable->InsertRecord ($data);
					if ($rcr[0] == 0) {
						$data = $ostable->PostInsertSetPkey ($data);
						$_SESSION['os_id'] = $data['os_id'];
					}
				} else {
					# No contact found
					$rcr[0] = 1;
					$rcr[1] = array ("That contact username is invalid. Try again.");
				}
			}
			display_oncall_schedule ($data, $rcr);
		} else if (isset ($_POST['updateoncallschedule']) && isset ($_SESSION['os_id'])) {
			if ($_SESSION['os_id'] != $_POST['os_id']) {
				$rcr[0] = 1;
				$rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
			} else {
				$rcr = $ostable->ValidateValues ($data);
				if ($rcr[0] == 0) {
					$ctable = new ContactDbTableClass ();
					$ctable->SetWhere ("c_username = '" . $_POST['c_username'] . "'");
					$cdata = $ctable->GetPageData (1);
					$r = $cdata[0];
					if (isset ($r['c_id'])) {
						$data['os_c_id'] = $r['c_id'];
						$rcr = $ostable->UpdateRecord ($data);
						if ($rcr[0] == 0) {
							$_SESSION['os_id'] = $data['os_id'];
						}
					} else {
						# No contact found
						$rcr[0] = 1;
						$rcr[1] = array ("That contact username is invalid. Try again.");
					}
				}
			}
			display_oncall_schedule ($data, $rcr);
		} else {
			display_oncall_schedule ("", "");
		}

	/* unknown */
	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";

/*** Free resources */
mysql_close ($conn);

return 0;



function display_contact_list ()
{
	if (user_check_access_right ('OncallView')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Contacts");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'c_group'));
	$t->AddColumn (array ('displayname' => 'Work#',
				'dataname' => 'c_workphone'));
	$t->AddColumn (array ('displayname' => 'Cell#',
				'dataname' => 'c_cellphone'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));
	$ctable = new ContactDbTableClass ();
	$rcr = $ctable->SetOrderBy ("c_username asc");
	$ctable->SetPageRows (75);
	$d = $ctable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$c_id = $row['c_id'];
		if (user_has_access_right ('AdminOncallEdit')) {
			$o = "<a href='?view=contactedit&c_id=$c_id'>Edit</a>";
			$o .= "&nbsp<a href='?view=contactdelete&c_id=$c_id'>Delete</a>";
			#$o .= "&nbsp<a href='?view=contactclone&c_id=$c_id'>Clone</a>";
		} else {
			$o = "";
		}
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	if (user_has_access_right ('AdminOncallEdit')) {
		print "<p><input type='submit' name='addcontact' value='Add Contact'>";
	}
	print "</form>";
	session_set_page ("contactlist");
	return;
}


function display_contact ($cdata, $errors)
{
	if (user_check_access_right ('OncallView')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr><td class='hostTitle'>";
	print "<b><a href='?view=contactlist'>Contact List</a></b>";
	print "</td></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['c_id']) && is_valid_integer ($_GET['c_id'])) {
			$c_id = $_GET['c_id'];
			$_SESSION['c_id'] = $c_id;
		} else {
			unset ($_SESSION['c_id']);
		}
	} else {
		if (isset ($_POST['addcontact'])) {
			if (isset ($cdata)) {
				$c_id = $cdata['c_id'];
			}
		} else if (isset ($_POST['updatecontact'])) {
				$c_id = $_SESSION['c_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($c_id)) {
		$title = "Contact (New)";
	} else {
		$title = "Contact (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'c_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Name',
				'dataname' => 'c_name'));
	$t->AddColumn (array ('displayname' => 'Email',
				'dataname' => 'c_email'));
	$t->AddColumn (array ('displayname' => 'Work Phone',
				'dataname' => 'c_workphone'));
	$t->AddColumn (array ('displayname' => 'Cell Phone',
				'dataname' => 'c_cellphone'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'c_group'));
	if (is_valid_integer ($c_id)) {
		$ctable = new ContactDbTableClass ();
		$ctable->SetWhere ("c_id = $c_id");
		$pd = $ctable->GetPageData (1);
		$d = $pd[0];
	} else {
		if (isset($cdata)) {
			$d = $cdata;
		} else {
			$d = array ();
		}
	}
	$row = contact_row_editable_render  ($d);
	if (user_has_access_right ('AdminOncallEdit')) {
		$o = "<a href='?view=contactedit&c_id=$c_id'>Edit</a>";
		$o .= "&nbsp<a href='?view=contactdelete&c_id=$c_id'>Delete</a>";
	} else {
		$o = "";
	}
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($c_id)) {
		print "<p align='left'><input type='submit' name='updatecontact' value='Update Contact'>";
	} else {
		print "<p align='left'><input type='submit' name='addcontact' value='Add Contact'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("contactedit");
	return;
}


function contact_row_editable_render ($row)
{
	$o = array ();
	$o['c_id'] = "<input type='text' name='c_id' size='10' readonly value='" . $row['c_id'] . "'>";
	$o['c_username'] = "<input type='text' name='c_username' size='64' value='" . $row['c_username'] . "'>";
	$o['c_name'] = "<input type='text' name='c_name' size='64' value='" . $row['c_name'] . "'>";
	$o['c_group'] = "<input type='text' name='c_group' size='32' value='" . $row['c_group'] . "'>";
	$o['c_email'] = "<input type='text' name='c_email' size='128' value='" . $row['c_email'] . "'>";
	$o['c_workphone'] = "<input type='text' name='c_workphone' size='20' value='" . $row['c_workphone'] . "'>";
	$o['c_cellphone'] = "<input type='text' name='c_cellphone' size='20' value='" . $row['c_cellphone'] . "'>";
	return $o;
}


function delete_contact ()
{
	$rcr = array (0, "");
	if (isset($_GET['c_id']) && is_valid_integer ($_GET['c_id'])) {
		$ctable = new ContactDbTableClass ();
		$rcr = $ctable->DeleteRecordByPkey ($_GET['c_id']);
	}
	return $rcr;
}


function display_oncall_schedule_list ()
{
	if (user_check_access_right ('OncallView')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Oncall Schedule");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'os_id'));
	$t->AddColumn (array ('displayname' => 'Username',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'os_group'));
	$t->AddColumn (array ('displayname' => 'Level',
				'dataname' => 'os_level'));
	$t->AddColumn (array ('displayname' => 'Start Date/Time',
				'dataname' => 'os_starttime'));
	$t->AddColumn (array ('displayname' => 'End Date/Time',
				'dataname' => 'os_endtime'));
	$t->AddColumn (array ('displayname' => 'Options',
				'dataname' => '_options'));

	$d = array ();
	$sql = "select os_id,c_username,os_group,os_level,os_starttime,os_endtime";
	$sql .= " from oncall_schedule, contact";
	$sql .= " where c_id = os_c_id";
	$sql .= " order by os_starttime desc";
	$sql .= " limit 50";
	$result = mysql_query ($sql);
	if ($result) {
		while ($row = mysql_fetch_assoc ($result)) {
			$d[] = $row;
		}
		mysql_free_result ($result);
	} else {
		print "<p>SQL failure: sql='$sql'</p>";
	}

	$td = array ();
	foreach ($d as $row) {
		$os_id = $row['os_id'];
		if (user_has_access_right ('AdminOncallEdit')) {
			$o = "<a href='?view=oncallscheduleedit&os_id=$os_id'>Edit</a>";
			$o .= "&nbsp<a href='?view=oncallscheduledelete&os_id=$os_id'>Delete</a>";
			#$o .= "&nbsp<a href='?view=oncallscheduleclone&os_id=$os_id'>Clone</a>";
		} else {
			$o = "";
		}
		$row['_options'] = $o;
		$td[] = $row;
	}
	$t->Render ($td);
	if (user_has_access_right ('AdminOncallEdit')) {
		print "<p><input type='submit' name='addoncallschedule' value='Add Oncall Schedule'>";
	}
	print "</form>";
	session_set_page ("oncallschedulelist");
	return;
}


function display_oncall_schedule ($cdata, $errors)
{
	if (user_check_access_right ('OncallView')) {
		access_denied_page();
		return 1;
	}

	print "<p>";
	print "<table><tr>";
	print "<td class='hostTitle'><b><a href='?view=oncallcalendar'>Oncall Calendar</a></b></td>";
	print "<td class='hostTitle'><b><a href='?view=oncallschedulelist'>Oncall Schedule</a></b></td>";
	print "></tr></table>\n";
	print "</p>";

	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (isset ($_GET['os_id']) && is_valid_integer ($_GET['os_id'])) {
			$os_id = $_GET['os_id'];
			$_SESSION['os_id'] = $os_id;
		} else {
			unset ($_SESSION['os_id']);
		}
	} else {
		if (isset ($_POST['addoncallschedule'])) {
			if (isset ($cdata)) {
				$os_id = $cdata['os_id'];
			}
		} else if (isset ($_POST['updateoncallschedule'])) {
				$os_id = $_SESSION['os_id'];
		}
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
	$t = new HtmlTableClass ();
	if (!is_valid_integer ($os_id)) {
		$title = "Oncall Schedule (New)";
	} else {
		$title = "Oncall Schedule (Edit)";
	}
	$t->SetTitle ($title);
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'width' => 130,
				'dataname' => 'os_id'));
	$t->AddColumn (array ('displayname' => 'Group',
				'dataname' => 'os_group'));
	$t->AddColumn (array ('displayname' => 'Contact',
				'dataname' => 'c_username'));
	$t->AddColumn (array ('displayname' => 'Level',
				'dataname' => 'os_level'));
	$t->AddColumn (array ('displayname' => 'Start Date/Time',
				'dataname' => 'os_starttime'));
	$t->AddColumn (array ('displayname' => 'End Date/Time',
				'dataname' => 'os_endtime'));
	if (is_valid_integer ($os_id)) {
		$sql = "select os_id,c_username,os_group,os_level,os_starttime,os_endtime";
		$sql .= " from oncall_schedule, contact";
		$sql .= " where c_id = os_c_id";
		$sql .= " and os_id = $os_id";
		$result = mysql_query ($sql);
		if ($result) {
			if ($row = mysql_fetch_assoc ($result)) {
				$d = $row;
			} else {
				$d = array ();
			}
			mysql_free_result ($result);
		} else {
			print "<p>SQL failure: sql='$sql'</p>";
		}
		#$ostable = new OncallScheduleDbTableClass ();
		#$ostable->SetWhere ("os_id = $os_id");
		#$pd = $ostable->GetPageData (1);
		#$d = $pd[0];
	} else {
		if (isset($cdata)) {
			$d = $cdata;
		} else {
			$d = array ();
		}
	}
	$row = oncall_schedule_row_editable_render  ($d);
	if (user_has_access_right ('AdminOncallEdit')) {
		$o = "<a href='?view=oncallscheduleedit&os_id=$os_id'>Edit</a>";
		$o .= "&nbsp<a href='?view=oncallscheduledelete&os_id=$os_id'>Delete</a>";
	} else {
		$o = "";
	}
	$row['_options'] = $o;
	$t->RenderVertical ($row);
	if (is_valid_integer ($os_id) && user_has_access_right ('AdminOncallEdit')) {
		print "<p align='left'><input type='submit' name='updateoncallschedule' value='Update Oncall Schedule'>";
	} else {
		print "<p align='left'><input type='submit' name='addoncallschedule' value='Add Oncall Schedule'>";
	}
	print "</form>";
	if (isset ($errors) && $errors[0] != 0) {
		print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
		foreach ($errors[1] as $e) {
			print "<li>$e</li>\n";
		}
		print "</ul></font></p>\n";
	}
	session_set_page ("oncallscheduleedit");
	return;
}


function oncall_schedule_row_editable_render ($row)
{
	$o = array ();
	$o['os_id'] = "<input type='text' name='os_id' size='10' readonly value='" . $row['os_id'] . "'>";
	$o['c_username'] = "<input type='text' name='c_username' size='64' value='" . $row['c_username'] . "'>";
	$o['os_group'] = "<input type='text' name='os_group' size='32' value='" . $row['os_group'] . "'>";
	$o['os_level'] = "<input type='text' name='os_level' size='3' value='" . $row['os_level'] . "'>";
	$o['os_starttime'] = "<input type='text' name='os_starttime' size='20' value='" . $row['os_starttime'] . "'>";
	$o['os_endtime'] = "<input type='text' name='os_endtime' size='20' value='" . $row['os_endtime'] . "'>";
	return $o;
}


function delete_oncall_schedule ()
{
	$rcr = array (0, "");
	if (isset($_GET['os_id']) && is_valid_integer ($_GET['os_id'])) {
		$ostable = new OncallScheduleDbTableClass ();
		$rcr = $ostable->DeleteRecordByPkey ($_GET['os_id']);
	}
	return $rcr;
}


function display_oncall_calendar ()
{
	if (user_check_access_right ('OncallView')) {
		access_denied_page();
		return 1;
	}

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";

	$cal = new Calendar ();
	$cal->set_class_title ("hostTitle");
	$cal->set_class_table ("tableList");
	$cal->set_class_table_header ("hostHeader");
	$cal->set_id_day_blank ("calendarDayBlank");
	$cal->set_id_day_unused ("calendarDayUnused");
	$cal->set_id_day_current ("calendarDayCurrent");

	if (isset ($_GET['month']) && isset ($_GET['year'])) {
		if (is_valid_integer ($_GET['month'])
			&& $_GET['month'] >= 1
			&& $_GET['month'] <= 12) {
			$month = $_GET['month'];
		}
		if (is_valid_integer ($_GET['year'])
			&& $_GET['year'] >= 1900) {
			$year = $_GET['year'];
		}
	} else {
		$lt = localtime (time (), TRUE);
		$month = $lt['tm_mon'] + 1;
		$year = $lt['tm_year'] + 1900;
	}
	
	$mt = mktime (0, 0, 0, $month, 1, $year);
	$month_days = date ("t", $mt);
	$month_name = date ("M", $mt);
	$cal->set_title ("$month_name $year");
	$data = array ();
	for ($i=1 ; $i<$month_days ; $i++) {
		$d = sprintf ("%04d-%02d-%02d", $year, $month, $i);
		$sql = "select os_id,c_username,os_level,os_group,os_starttime";
		$sql .= " from contact,oncall_schedule";
		$sql .= " where c_id = os_c_id";
		$sql .= " and date(os_starttime) <= '$d'";
		$sql .= " and date(os_endtime) >= '$d'";
		$sql .= " and dayofmonth(os_endtime) != $i";
		$sql .= " order by os_group,os_level,os_starttime asc";
		$result = mysql_query ($sql);
		if ($result) {
			$d = "";
			while ($row = mysql_fetch_assoc ($result)) {
				if (user_has_access_right ('AdminOncallEdit')) {
					$d .= "<a href='" . $_SERVER['PHP_SELF'] . "?view=oncallscheduleedit&os_id=" . $row['os_id'] . "'>";
				}
				$d .= $row['os_group'] . ":" . $row['c_username'] . " - Level " . $row['os_level'];
				$d .= "</a><br>";
				$data[$i] = $d;
			}
			mysql_free_result ($result);
		}
	}
	$py = $year;
	$pm = $month - 1;
	if ($pm == 0) {
		$pm = 12;
		$py -= 1;
	}
	$ny = $year;
	$nm = $month + 1;
	if ($nm == 13) {
		$nm = 1;
		$ny += 1;
	}
	$data['_backward_link'] = $_SERVER['PHP_SELF'] . "?view=oncallcalendar&year=$py&month=$pm";
	$data['_forward_link'] = $_SERVER['PHP_SELF'] . "?view=oncallcalendar&year=$ny&month=$nm";
	$cal->render_small ($month, $year, $data);
	print "</form>";
	session_set_page ("trapfilterlist");
	return;
}





?>


