<?php  


include 'common-functions.php';
include 'validate-functions.php';


$GroupList = array ('IT' => 'IT',
			'DBA' => 'DBA');


if (is_full_page ()) {
	print "<html>\n";
	print "<head><title>DST Oncall Pager Service</title></head>\n";
	print "<body>\n";
}


if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	display_oncall_form (array ());

} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	$rc = 0;
	$msg = array ();
	if ($_POST['requestor'] == "") {
		$msg[] = "* The requestor field must be contain a valid username.";
		$rc++;
	}
	$group = $_POST['group'];
	if ($GroupList[$group] != $group) {
		$msg[] = "* The group field must be filled with a valid group entry.";
		$rc++;
	}
	if ($_POST['message'] == "") {
		$msg[] = "* The message field must contain some content.";
		$rc++;
	}

	if ($rc != 0) {
		display_oncall_form ($msg);

	} else {
		submit_pager_callout ($_POST['requestor'],
					$_POST['group'],
					$_POST['message']);
		$msg[] = "Your oncall request was submitted.";
		display_oncall_form ($msg);
	}
}

if (is_full_page ()) {
	print "</body>\n";
	print "</html>\n";
}



function display_oncall_form ($msg)
{
	global $GroupList;
	
	print "<div style='font-size: 12pt; font-weight: bold; color: black; background: #d2d2d2; border: thin solid black; padding: 0; width: 400px; '>\n";
	print "<div style='padding: 0px; width: 400px; background: #727272; color: black; border-bottom: thin solid black; '>DST Oncall Request</div>";

	print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>\n";

	print "<div style='padding: 5px; width: 160px; float: left; '>Requestor: ";
	#print "<div style='padding: 5px; width: 160px; float: left; '>";
	print "<input name='requestor' size='20' value='" . $_POST['requestor'] . "'>";
	#print "</div>\n";
	print "</div>\n";

	print "<div style='padding: 5px; width: 240px; '>Group: ";
	print html_select_button ("group", $GroupList, $_POST['group']);
	print "</div>\n";

	print "<div style='padding-top: 10px; padding-left: 5px; '>Message:";
	print "</div> <div style='font-size: 12pt; color: black; padding-left: 5px;'><textarea name='message' rows='5' cols='46'>" . $_POST['message'] . "</textarea></div>\n";

	print "<div style='padding: 10px; '><input type='submit' name='submit-oncall' value='Submit'></div>\n";

	print "<div style='font-size: 12pt; color: red; padding: 5px; '>";
	foreach ($msg as $m) {
		print $m . "<br>\n";
	}
	print "</div>\n";

	print "</form>\n";

	print "</div>\n";

	return;
}


function is_full_page ()
{
	if ($_GET['view'] == "portal") {
		return 0;
	}
	if ($_POST['view'] == "portal") {
		return 0;
	}
	return 1;
}


function submit_pager_callout ($requestor, $group, $message)
{
	ini_set("soap.wsdl_cache_enabled", "0");
	$c = new SoapClient("https://netscout2.asp.datascantech.com/netinfo/netinfo-webservices.php?WSDL",
				array ('trace' => 1));
	$response = $c->oncallRequest($requestor,
					$group,
					"",
					"",
					$message);
	return;
}


?>
