<?php
/*
 * preferences.php - Preferences source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'page-functions.php';
include 'netinfo-config-variables.php';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (-1);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

display_navmenu ();
if (user_check_access_right ('PreferenceView')) {
        return 1;
}


/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if (!isset($_GET['view']) || $_GET['view'] == "") {
		display_preferences ();

	} else if ($_GET['view'] == "preferences") {
		display_preferences ();

	} else {
		session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	#print "<p>" . print_r ($_POST) . "<br>page='" . $_SESSION['page'] . "'</p>";
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	} else if ($_SESSION['page'] == "preferences") {
		if (isset ($_POST["prefcommit"])) {
			process_preferences ();
		}
		display_preferences ();

	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";


/*** Free resources */
mysql_close ($conn);

return 0;



/************************************************************************/
/* Render the Preferences page						*/
/************************************************************************/
function display_preferences ()
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['PreferenceView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$AlertClass = $_SESSION['AlertClass'];
	$AlertState = $_SESSION['AlertState'];
	$AlertSeverity = $_SESSION['AlertSeverity'];
	$SortList = array ('AlertId', 'Severity');
	$SkinList = array ('TAC', 'Blues', 'Muted');
	$IconList = array_keys ($GLOBALS['icon_sets']);
	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	$pref = $_SESSION['preferences'];
	$preflist = array ('alert_view_max_records' => "Maximum Alerts to Display",
			'alert_view_style' => "Alert Style");
	#$preflist = array ('alert_view_max_records' => "Maximum Alerts to Display",
	#		'alert_view_display_state' => "Alert States to Display (commalist)",
	#		'alert_view_display_class' => "Alert Classes to Display (commalist)");
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";
	print "<form method='POST' action='" . $phppage . "'>";
	print "<table>";
	print "<tr>";
	print "<th class='hostHeader' width='120'>Preference</th>\n";
	print "<th class='hostHeader' width='300'>Value</th>\n";
	print "</tr>";
	
	foreach ($preflist as $key => $name) {
		print "<tr>";
		print "<th class='hostHeader' width='120'>" . $name . "</th>\n";
		print "<th class='textDetail'><input type='text' name='" . $key . "' value='" . $pref[$key] . "'></th>\n";
		print "</tr>";
	}

	print "<tr>";
	print "<th class='hostHeader' width='120'>Alert States to Display</th>\n";
	$a = $pref['alert_view_display_state'];
	print "<th class='textDetail'>" . html_multiselect_button('alert_view_display_state', $AlertState, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Alert Classes to Display</th>\n";
	$a = $pref['alert_view_display_class'];
	print "<th class='textDetail'>" . html_multiselect_button('alert_view_display_class', $AlertClass, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Severity Threshold</th>\n";
	$a = $pref['alert_view_display_severity'];
	print "<th class='textDetail'>" . html_select_button('alert_view_display_severity', $AlertSeverity, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Alert Sorting</th>\n";
	$a = $pref['alert_view_display_sort'];
	print "<th class='textDetail'>" . html_select_button('alert_view_display_sort', $SortList, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Theme</th>\n";
	$a = $pref['alert_view_display_skin'];
	print "<th class='textDetail'>" . html_select_button('alert_view_display_skin', $SkinList, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th class='hostHeader' width='120'>Icons</th>\n";
	$a = $pref['icon_set'];
	print "<th class='textDetail'>" . html_select_button('icon_set', $IconList, $a) . "</th>\n";
	print "</tr>";

	print "<tr>";
	print "<th><input type='submit' name='prefcommit' value='Commit Changes'></th>\n";
	print "</tr>";

	print "</table>";
	print "</form>";
	print "</p>";
	session_set_page ("preferences");
	return;
}


/************************************************************************/
/* Process the Preferences page						*/
/************************************************************************/
function process_preferences ()
{
	$pref = $_SESSION['preferences'];
	$SeverityId = $_SESSION['AlertSeverityID'];
	$maxalerts = $_POST['alert_view_max_records'];
	if (is_valid_integer ($maxalerts) != 1) {
		print "<p><font color='red'>The 'Max Alerts' field must be an integer value.</font></p>\n";
		#session_error ();
		return;
	}
	$alertstates = $_POST['alert_view_display_state'];
	$alertclasses = $_POST['alert_view_display_class'];
	$alertseverity = $_POST['alert_view_display_severity'];
	$alertsort = $_POST['alert_view_display_sort'];
	$alertskin = $_POST['alert_view_display_skin'];
	$iconset = $_POST['icon_set'];

	$pref['alert_view_max_records'] = $maxalerts;
	$pref['alert_view_display_state'] = $alertstates;
	$pref['alert_view_display_class'] = $alertclasses;
	$pref['alert_view_display_severity'] = $alertseverity;
	$pref['alert_view_display_sort'] = $alertsort;
	$pref['alert_view_display_skin'] = $alertskin;
	$pref['icon_set'] = $iconset;
	$_SESSION['preferences'] = $pref;

	$pref['alert_view_display_state'] = implode (',', $alertstates);
	$pref['alert_view_display_class'] = implode (',', $alertclasses);
	$uatable = new UserAttributeDbTableClass ();
	$username = $_SESSION['username'];
	$rcr = $uatable->SetAttributes ($username, $pref);
	return;
}


?>

