<?php
/*
 * reports.php - Reports source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'page-functions.php';
include 'netinfo-config-variables.php';

include 'alert.dbtable.class.inc';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (-1);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

display_navmenu ();
if (user_check_access_right ('ReportView')) {
	return 1;
}

$pagemenu = array ( 'reportalertconfiguration' => 'Alert_Report',
			'reportalertgraphs' => 'Alert_Graphs',
			'reportsecuritygraphs' => 'Security_Graphs');
render_page_menu ($pagemenu);


/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	$report_start_date = date ("Y-m-d", time());
	$report_end_date = $report_start_date;
	if (!isset($_GET['view']) || $_GET['view'] == "") {
		#print "<p>Report generation</p>\n";

	} else if ($_GET['view'] == "reportalertconfiguration") {
		display_reportalertconfiguration ();

	} else if ($_GET['view'] == "reportalertgraphs") {
		display_reportalertgraphs ($report_start_date,
					$report_end_date);

	} else if ($_GET['view'] == "reportsecuritygraphs") {
		display_reportsecuritygraphs ($report_start_date,
					$report_end_date);

	} else {
		session_error ();
	}
} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if (isset($_POST['reportstartdate'])) {
		if (is_valid_date ($_POST['reportstartdate'])) {
			$report_start_date = $_POST['reportstartdate'];
		} else {
			session_error ();
		}
	} else {
		$report_start_date = date ("Y-m-d", time());
	}
	if (isset($_POST['reportenddate'])) {
		if (is_valid_date ($_POST['reportenddate'])) {
			$report_end_date = $_POST['reportenddate'];
		} else {
			session_error ();
		}
	} else {
		$report_end_date = $report_start_date;
	}
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	} else if ($_SESSION['page'] == "reportalertconfiguration") {
		if (isset ($_POST["executereport"])) {
			process_reportalert ();
		}

	} else if ($_SESSION['page'] == "reportalertgraphs") {
		if (isset ($_POST["executegraph"])) {
			display_reportalertgraphs ($report_start_date,
						$report_end_date);
		}

	} else if ($_SESSION['page'] == "reportsecuritygraphs") {
		if (isset ($_POST["executegraph"])) {
			display_reportsecuritygraphs ($report_start_date,
						$report_end_date);
		}

	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";


/*** Free resources */
mysql_close ($conn);

return 0;



/************************************************************************/
/* Render the alert report configuration page				*/
/************************************************************************/
function display_reportalertconfiguration ()
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['ReportView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$class = $_SESSION['AlertClass'];
	$state = $_SESSION['AlertState'];
	$sev = $_SESSION['AlertSeverity'];

	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";

	print "<form method='POST' action='" . $phppage . "'>";
	print "<table>";
	print "<tr>";
	print "<th class='hostHeader' width='80'>Start Date</th>\n";
	print "<th class='hostHeader' width='80'>End Date</th>\n";
	print "<th class='hostHeader' width='80'>Class</th>\n";
	print "<th class='hostHeader' width='80'>State</th>\n";
	print "<th class='hostHeader' width='80'>Severity</th>\n";
	print "</tr>";
	print "<tr>";
	print "<td class='textDetail'><input name='startdate' size='10'></td>\n";
	print "<td class='textDetail'><input name='enddate' size='10'></td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_class', $class) . "</td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_state', $state) . "</td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_severity', $sev) . "</td>\n";
	print "</tr>";
	print "<tr>";
	print "<td><input type='submit' name='executereport' value='Execute Report'></td>\n";
	print "</tr>";
	print "</table>";
	print "</form>";
	print "</p>";

	session_set_page ("reportalertconfiguration");
	return;
}


/************************************************************************/
/* Process the ReportAlert page						*/
/************************************************************************/
function process_reportalert ()
{
	$class = $_SESSION['AlertClass'];
	$state = $_SESSION['AlertState'];
	$sev = $_SESSION['AlertSeverity'];
	$classid = $_SESSION['AlertClassId'];
	$stateid = $_SESSION['AlertStateId'];
	$sevid = $_SESSION['AlertSeverityId'];

	$startdate = $_POST['startdate'];
	$enddate = $_POST['enddate'];
	$states = $_POST['alert_state'];
	$classes = $_POST['alert_class'];
	$severities = $_POST['alert_severity'];

	$rcm = array ();
	if (!is_valid_date ($startdate)) {
		$rcm[] = "Invalid start date.";
	}
	if (!is_valid_date ($enddate)) {
		$rcm[] = "Invalid end date.";
	}
	$rcr = count($rcm);
	if ($rcr != 0) {
		return array (rcr, rcm);
	}

	$list = array ();
	foreach ($states as $i) {
		$list[] = $stateid[$i];
	}
	$statelist = implode (',', $list);

	$list = array ();
	foreach (classes as $i) {
		$list[] = $classid[$i];
	}
	$classlist = implode (',', $list);

	$list = array ();
	foreach ($severities as $i) {
		$list[] = $sevid[$i];
	}
	$sevlist = implode (',', $list);

	print "<tr><td>&nbsp</td></tr>";
	print "<p>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("24-hour Alert Report");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'a_id'));
	$t->AddColumn (array ('displayname' => 'Hostname',
				'dataname' => 'a_hostname'));
	$t->AddColumn (array ('displayname' => 'Object',
				'dataname' => 'a_object'));
	$t->AddColumn (array ('displayname' => 'Class',
				'dataname' => 'a_class'));
	$t->AddColumn (array ('displayname' => 'State',
				'dataname' => 'a_state'));
	$t->AddColumn (array ('displayname' => 'Severity',
				'dataname' => 'a_severity'));
	$t->AddColumn (array ('displayname' => 'Alert Time',
				'dataname' => 'a_alerttime'));
	$t->AddColumn (array ('displayname' => 'Last Time',
				'dataname' => 'a_lasttime'));
	$t->AddColumn (array ('displayname' => 'Information',
				'dataname' => 'a_message'));
	$atable = new AlertDbTableClass ();

	$where = "date(a_alerttime) between '$startdate' and '$enddate' ";
	if ($statelist != "") {
		$where .= " and a_state in ($statelist) ";
	}
	if ($classlist != "") {
		$where .= " and a_class in ($classlist) ";
	}
	if ($sevlist != "") {
		$where .= " and a_severity in ($sevlist) ";
	}
	$rcr = $atable->SetWhere ($where);
	$rcr = $atable->SetOrderBy ("a_id desc");
	$atable->SetPageRows (100);

	$d = $atable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$row['a_state'] = $state[$row['a_state']];
		$row['a_class'] = $class[$row['a_class']];
		$row['a_severity'] = $sev[$row['a_severity']];
		$td[] = $row;
	}
	$t->Render ($td);
	print "</p>";

	return;
}


/************************************************************************/
/* Render the alert report graphs page					*/
/************************************************************************/
function display_reportalertgraphs ($start_date, $end_date)
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['ReportView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";

	print "<form method='POST' action='" . $phppage . "'>";
	print "<table cellpadding='5' cellspacing='5'><tr>";
	print "<td><font color='white'>Report Dates:</font></td>";
	print "<td><input name='reportstartdate' value='$start_date' size='10'></td>";
	print "<td><font color='white'>to</font></td>";
	print "<td><input name='reportenddate' value='$end_date' size='10'></td>";
	print "<td><input type='submit' name='executegraph' value='Graph'></td>\n";
	print "</tr></table>";
	print "</form>";

	print "<table cellpadding='0' cellspacing='0'>";

	print "<tr>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertsbyclass&reportstartdate=$start_date&reportenddate=$end_date'></td>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertsbystate&reportstartdate=$start_date&reportenddate=$end_date'></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertsbyclass&reportstartdate=$start_date&reportenddate=$end_date'><font color='white'>Data</a></font></td>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertsbystate&reportstartdate=$start_date&reportenddate=$end_date'><font color='white'>Data</font></a></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertsbyseverity&reportstartdate=$start_date&reportenddate=$end_date'></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertsbyseverity&reportstartdate=$start_date&reportenddate=$end_date'><font color='white'>Data</font></a></td>";
	print "</tr>";

	print "</table>";
	print "</p>";
	
	session_set_page ("reportalertgraphs");
	return;
}


/************************************************************************/
/* Render the security alert graphs page				*/
/************************************************************************/
function display_reportsecuritygraphs ($start_date, $end_date)
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['ReportView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";

	print "<form method='POST' action='" . $phppage . "'>";
	print "<table cellpadding='10' cellspacing='10'><tr>";
	print "<td><font color='white'>Report Dates:</font></td>";
	print "<td><input name='reportstartdate' value='$start_date' size='10'></td>";
	print "<td><font color='white'>to</font></td>";
	print "<td><input name='reportenddate' value='$end_date' size='10'></td>";
	print "<td><input type='submit' name='executegraph' value='Graph'></td>\n";
	print "</tr></table>";
	print "</form>";

	print "<table cellpadding='0' cellspacing='0'>";

	print "<tr>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASP-FWSM'></td>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASA-5540'></td>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=MGMT-ASA'></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASP-FWSM'><font color='white'>Data</a></font></td>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASA-5540'><font color='white'>Data</a></font></td>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertstopscanbyaddress&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=MGMT-ASA'><font color='white'>Data</a></font></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertstopscanbytcpport&reportstartdate=$start_date&reportenddate=$end_date'></td>";
	print "<td style='width: 450px; height: 260px;' align='center'><img src='netinfo-image.php?imagename=alertstopscanbyudpport&reportstartdate=$start_date&reportenddate=$end_date'></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertstopscanbytcpport&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASP-FWSM'><font color='white'>Data</a></font></td>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center'><a href='netinfo-imagedata-sladev.php?imagename=alertstopscanbyudpport&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASA-5540'><font color='white'>Data</a></font></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='width: 450px; height: 260px;' align='center' colspan='3'><img src='netinfo-image-sladev.php?imagename=alertdaterangebyday&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASA-5540'></td>";
	print "</tr>";

	print "<tr>";
	print "<td style='height: 50px; color: #ffffff;' valign='top' align='center' colspan='3'><a href='netinfo-imagedata-sladev.php?imagename=alertdaterangebyday&reportstartdate=$start_date&reportenddate=$end_date&reporthostname=ASP-FWSM'><font color='white'>Data</a></font></td>";
	print "</tr>";

	print "</table>";
	print "</p>";
	
	session_set_page ("reportsecuritygraphs");
	return;
}


?>
