<?php
/*
 * reports-sla.php - SLA Reporting source file
*/


/************************************************************************/
/* main entry point							*/
/************************************************************************/

/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'page-functions.php';
include 'netinfo-config-variables.php';

include 'alert.dbtable.class.inc';
include 'slareportoutageitem.dbtable.class.inc';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
	return 0;
}

page_header (-1);

$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

display_navmenu ();
if (user_check_access_right ('SlaReportView')) {
	access_denied_page();
	return 1;
}


/*
 * TODO: This (hardcoded stuff) needs to be dynamic
*/



$truefalse = array (0 => 'False', 1 => 'True');
$truefalseid = array ('False' => 0, 'True' => 1);


$pagemenu = array ( 
		'report_slareport' => 'SLA_Reports');
render_page_menu ($pagemenu);



/*** Display the requested page */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if (!isset($_GET['view']) || $_GET['view'] == "") {
		#print "<p>Report generation</p>\n";

	} else if ($_GET['view'] == "report_slareport") {
		display_slareport ($sla_report_id);

	} else if ($_GET['view'] == "edit_outage_item") {
		$rcr = array ();
		display_slareport_outage_item ($soi_id, $rcr);

	} else if ($_GET['view'] == "delete_outage_item") {
		delete_slareport_outage_item ($soi_id);

	} else {
		session_error ();
	}

} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	if ($_SESSION['page'] == "logon") {
		#if ($_POST['username'] == "tshadburn" && $_POST['password'] == "test123") {
		if (authenticate_user ($_POST['username'], $_POST['password']) == 1) {
			$_SESSION['authenticated'] = "yes";
			$_SESSION['username'] = $_POST['username'];
			session_set_page ('alerts');
			page_header (1);
		} else {
			display_logon ("You entered an invalid username or password.");
		}

	} else if (isset($_POST['slareport_id'])) {
		if (is_valid_integer ($_POST['slareport_id'])) {
			$slareport_id = $_POST['slareport_id'];
		} else {
			/* TODO: session_error (); */
		}	$slareport_id = 1;

        } else if ($_SESSION['page'] == "edit_outage_item") {
                $soitable = new SlareportOutageItemDbTableClass ();
                $data = $soitable->OnlyColumns ($_POST);
		$data['soi_visible'] = $truefalseid[$data['soi_visible']];
                if (isset ($_POST['add_slareport_outage_item'])) {
                        unset ($data['soi_id']);
                        $rcr = $soitable->ValidateValues ($data);
                        if ($rcr[0] == 0) {
                                $rcr = $soitable->InsertRecord ($data);
                                if ($rcr[0] == 0) {
                                        $data = $soitable->PostInsertSetPkey ($data);
                                        $_SESSION['soi_id'] = $data['soi_id'];
                                }
                        }
                        display_slareport_outage_item ($data, $rcr);
                } else if (isset ($_POST['update_slareport_outage_item']) && isset ($_SESSION['soi_id'])) {
                        if ($_SESSION['soi_id'] != $_POST['soi_id']) {
                                $rcr[0] = 1;
                                $rcr[1] = array ("Maybe you should try something cool next time (wanabee)");
                        } else {
                                $rcr = $soitable->ValidateValues ($data);
                                if ($rcr[0] == 0) {
                                        $rcr = $soitable->UpdateRecord ($data);
                                        if ($rcr[0] == 0) {
                                                $_SESSION['soi_id'] = $data['soi_id'];
                                        }
                                }
                        }
                        display_slareport_outage_item ($data, $rcr);
                } else {
			$data = array ();
			$rcr = array ();
                        display_slareport_outage_item ($data, $rcr);
                }

	} else {
		session_error ();
	}
}


/*** Page Footer */
print "</td></tr>";
print "</table>";
print "</body>";
print "</html>";


/*** Free resources */
mysql_close ($conn);

return 0;



/************************************************************************/
/* Render the alert report configuration page				*/
/************************************************************************/
function display_reportalertconfiguration ()
{
	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['ReportView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$class = $_SESSION['AlertClass'];
	$state = $_SESSION['AlertState'];
	$sev = $_SESSION['AlertSeverity'];

	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";

	print "<form method='POST' action='" . $phppage . "'>";
	print "<table>";
	print "<tr>";
	print "<th class='hostHeader' width='80'>Start Date</th>\n";
	print "<th class='hostHeader' width='80'>End Date</th>\n";
	print "<th class='hostHeader' width='80'>Class</th>\n";
	print "<th class='hostHeader' width='80'>State</th>\n";
	print "<th class='hostHeader' width='80'>Severity</th>\n";
	print "</tr>";
	print "<tr>";
	print "<td class='textDetail'><input name='startdate' size='10'></td>\n";
	print "<td class='textDetail'><input name='enddate' size='10'></td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_class', $class) . "</td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_state', $state) . "</td>\n";
	print "<td class='textDetail'>" . html_multiselect_button('alert_severity', $sev) . "</td>\n";
	print "</tr>";
	print "<tr>";
	print "<td><input type='submit' name='executereport' value='Execute Report'></td>\n";
	print "</tr>";
	print "</table>";
	print "</form>";
	print "</p>";

	session_set_page ("reportalertconfiguration");
	return;
}


/************************************************************************/
/* Process the ReportAlert page						*/
/************************************************************************/
function process_reportalert ()
{
	$class = $_SESSION['AlertClass'];
	$state = $_SESSION['AlertState'];
	$sev = $_SESSION['AlertSeverity'];
	$classid = $_SESSION['AlertClassId'];
	$stateid = $_SESSION['AlertStateId'];
	$sevid = $_SESSION['AlertSeverityId'];

	$startdate = $_POST['startdate'];
	$enddate = $_POST['enddate'];
	$states = $_POST['alert_state'];
	$classes = $_POST['alert_class'];
	$severities = $_POST['alert_severity'];

	$rcm = array ();
	if (!is_valid_date ($startdate)) {
		$rcm[] = "Invalid start date.";
	}
	if (!is_valid_date ($enddate)) {
		$rcm[] = "Invalid end date.";
	}
	$rcr = count($rcm);
	if ($rcr != 0) {
		return array (rcr, rcm);
	}

	$list = array ();
	foreach ($states as $i) {
		$list[] = $stateid[$i];
	}
	$statelist = implode (',', $list);

	$list = array ();
	foreach (classes as $i) {
		$list[] = $classid[$i];
	}
	$classlist = implode (',', $list);

	$list = array ();
	foreach ($severities as $i) {
		$list[] = $sevid[$i];
	}
	$sevlist = implode (',', $list);

	print "<tr><td>&nbsp</td></tr>";
	print "<p>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("24-hour Alert Report");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'ID',
				'dataname' => 'a_id'));
	$t->AddColumn (array ('displayname' => 'Hostname',
				'dataname' => 'a_hostname'));
	$t->AddColumn (array ('displayname' => 'Object',
				'dataname' => 'a_object'));
	$t->AddColumn (array ('displayname' => 'Class',
				'dataname' => 'a_class'));
	$t->AddColumn (array ('displayname' => 'State',
				'dataname' => 'a_state'));
	$t->AddColumn (array ('displayname' => 'Severity',
				'dataname' => 'a_severity'));
	$t->AddColumn (array ('displayname' => 'Alert Time',
				'dataname' => 'a_alerttime'));
	$t->AddColumn (array ('displayname' => 'Last Time',
				'dataname' => 'a_lasttime'));
	$t->AddColumn (array ('displayname' => 'Information',
				'dataname' => 'a_message'));
	$atable = new AlertDbTableClass ();

	$where = "date(a_alerttime) between '$startdate' and '$enddate' ";
	if ($statelist != "") {
		$where .= " and a_state in ($statelist) ";
	}
	if ($classlist != "") {
		$where .= " and a_class in ($classlist) ";
	}
	if ($sevlist != "") {
		$where .= " and a_severity in ($sevlist) ";
	}
	$rcr = $atable->SetWhere ($where);
	$rcr = $atable->SetOrderBy ("a_id desc");

	$d = $atable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$row['a_state'] = $state[$row['a_state']];
		$row['a_class'] = $class[$row['a_class']];
		$row['a_severity'] = $sev[$row['a_severity']];
		$td[] = $row;
	}
	$t->Render ($td);
	print "</p>";

	return;
}


/************************************************************************/
/* Render the alert report graphs page					*/
/************************************************************************/
function display_slareport ($slareport_id)
{
	$truefalse = array (0 => 'False', 1 => 'True');
	$truefalseid = array ('False' => 0, 'True' => 1);

	/*** Check access rights  */
	$right = $_SESSION['accessrights'];
	if ($right['SlaReportView'] != TRUE) {
		print "<tr><td><font color='white'><h4>";
		print "You don't have authority to access this page.";
		print "</h4></font></td></td>";
		return 1;
	}

	$phppage = array_pop (explode ('/', $_SERVER['PHP_SELF']));
	print "<tr><td>&nbsp</td></tr>";
	print "<p>";

	print "<table cellpadding='5' cellspacing='5'>";
	print "<tr>";
	print "<td><font color='white'><b>SLA Report</b></font></td>";
	print "<td></td>\n";
	print "<td></td>\n";
	print "</tr>";
	print "</table>\n";
	print "</p>";

	print "<p>";
	print "<table cellpadding='10' cellspacing='10'>";
	print "<tr>";
	#print "<td><img src='netinfo-image-sladev.php?imagename=slareport_monthly&slareport_id=$slareport_id'></td>";
	print "<td><img src='netinfo-image-sladev.php?imagename=slareport_monthly&slareport_id=1'></td>";
	print "</tr>";
	print "</table>\n";
	print "</p>";

	print "<p>";
	$t = new HtmlTableClass ();
	$t->SetTitle ("Outages:");
	$t->SetTitleClass ("hostTitle");
	$t->SetTableClass ("tableList");
	$t->SetHeaderClass ("hostHeader");
	$t->SetFieldClass ("textNote");
	$t->AddColumn (array ('displayname' => 'Actions',
                                'width' => 60,
				'dataname' => '_actions'));
	$t->AddColumn (array ('displayname' => 'Visible',
                                'width' => 40,
				'dataname' => 'soi_visible'));
	$t->AddColumn (array ('displayname' => 'Start Time',
                                'width' => 80,
				'dataname' => 'soi_starttime'));
	$t->AddColumn (array ('displayname' => 'System',
                                'width' => 60,
				'dataname' => 'soi_a_id'));
	$t->AddColumn (array ('displayname' => 'Reason',
                                'width' => 300,
				'dataname' => 'soi_reason'));
	$t->AddColumn (array ('displayname' => 'Action',
                                'width' => 300,
				'dataname' => 'soi_action'));
	$t->AddColumn (array ('displayname' => 'Downtime',
                                'width' => 60,
                                'align' => 'right',
				'dataname' => 'soi_seconds'));
	$t->AddColumn (array ('displayname' => 'Resolution',
                                'width' => 300,
				'dataname' => 'soi_resolution'));
				
	$atable = new SlareportOutageItemDbTableClass ();
	#$where = "soi_sr_id = $slareport_id ";
	#$rcr = $atable->SetWhere ($where);
	$rcr = $atable->SetOrderBy ("soi_starttime asc");

	$d = $atable->GetPageData (1);
	if (!is_array ($d)) {
		$d = array ();
	}
	$td = array ();
	foreach ($d as $row) {
		$row['soi_seconds'] = sprintf ("%0.2f", $row['soi_seconds'] / 60);
		$soi_id = $row['soi_id'];
		if ($row['soi_visible'] != TRUE) {
			$row['_class'] = "textNoteGray";
		}
		$row['soi_visible'] = $truefalse[$row['soi_visible']];
		$row['_actions'] = "<a href='?view=edit_outage_item&soi_id=$soi_id'>Edit</a>";
		$row['_actions'] .= "&nbsp<a href='?view=delete_outage_item&soi_id=$soi_id'>Delete</a>";
		$td[] = $row;
	}
	$t->Render ($td);
	print "</p>";
	
	session_set_page ("report_slareport");
	return;
}


function delete_slareport_outage_item ()
{
        $rcr = array (0, "");
        if (isset($_GET['soi_id']) && is_valid_integer ($_GET['soi_id'])) {
                $soitable = new SlareportOutageItemDbTableClass ();
                $rcr = $soitable->DeleteRecordByPkey ($_GET['soi_id']);
        }
        return $rcr;
}


function display_slareport_outage_item ($filterdata, $errors)
{
        if (user_check_access_right ('SlaReportView')) {
		access_denied_page();
                return 1;
        }

        print "<p>";
        print "<table><tr><td class='hostTitle'>";
        $sr_id = $_SESSION['sr_id'];
        print "<b><a href='?view=report_slareport&slareport_id=$sr_id'>Back To SLA report</a></b>";
        print "</td></tr></table>\n";
        print "</p>";

        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                if (isset ($_GET['soi_id']) && is_valid_integer ($_GET['soi_id'])) {
                        $soi_id = $_GET['soi_id'];
                        $_SESSION['soi_id'] = $soi_id;
                } else {
                        unset ($_SESSION['soi_id']);
                }
        } else {
                if (isset ($_POST['add_slareport_outage_item'])) {
                        if (isset ($filterdata)) {
                                $soi_id = $filterdata['soi_id'];
                        }
                } else if (isset ($_POST['update_slareport_outage_item'])) {
                                $soi_id = $_SESSION['soi_id'];
                }
        }

        print "<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>";
        $t = new HtmlTableClass ();
        if (!is_valid_integer ($soi_id)) {
                $title = "Outage Item (New)";
        } else {
                $title = "Outage Item (Edit)";
        }
        $t->SetTitle ($title);
        $t->SetTitleClass ("hostTitle");
        $t->SetTableClass ("tableList");
        $t->SetHeaderClass ("hostHeader");
        $t->SetFieldClass ("textNote");

	$t->AddColumn (array ('displayname' => 'ID',
                                'width' => 60,
				'dataname' => 'soi_id'));
	$t->AddColumn (array ('displayname' => 'Visible',
                                'width' => 40,
				'dataname' => 'soi_visible'));
	$t->AddColumn (array ('displayname' => 'Start Time',
                                'width' => 120,
				'dataname' => 'soi_starttime'));
	$t->AddColumn (array ('displayname' => 'End Time',
                                'width' => 120,
				'dataname' => 'soi_endtime'));
	$t->AddColumn (array ('displayname' => 'System',
                                'width' => 60,
				'dataname' => 'soi_a_id'));
	$t->AddColumn (array ('displayname' => 'Reason',
                                'width' => 300,
				'dataname' => 'soi_reason'));
	$t->AddColumn (array ('displayname' => 'Action',
                                'width' => 300,
				'dataname' => 'soi_action'));
	$t->AddColumn (array ('displayname' => 'Downtime',
                                'width' => 60,
				'dataname' => 'soi_seconds'));
	$t->AddColumn (array ('displayname' => 'Resolution',
                                'width' => 300,
				'dataname' => 'soi_resolution'));

        if (is_valid_integer ($soi_id)) {
                $soitable = new SlareportOutageItemDbTableClass ();
                $soitable->SetWhere ("soi_id = $soi_id");
                $pd = $soitable->GetPageData (1);
                $d = $pd[0];
        } else {
                if (isset($filterdata)) {
                        $d = $filterdata;
                } else {
                        $d = array ();
                }
        }
        #$fid = $row['tf_id'];
        $row = slareport_outage_item_row_editable_render  ($d);
	#$o = "<a href='?view=edit_outage_item&soi_id=$soi_id'>Edit</a>";
	#$o .= "&nbsp<a href='?view=delete_slareport_outage_item&soi_id=$soi_id'>Delete</a>";
	#$row['_options'] = $o;
        $t->RenderVertical ($row);
        if (is_valid_integer ($soi_id)) {
                print "<p align='left'><input type='submit' name='update_slareport_outage_item' value='Update Outage Item'>";
        } else {
                print "<p align='left'><input type='submit' name='add_slareport_outage_item' value='Add Outage Item'>";
        }
        print "</form>";
        if (isset ($errors) && $errors[0] != 0) {
                print "<div align='left'><p><font color='red'><b>Error:</b><br><ul>\n";
                foreach ($errors[1] as $e) {
                        print "<li>$e</li>\n";
                }
                print "</ul></font></p>\n";
        }
        session_set_page ("edit_outage_item");
        return;
}


function slareport_outage_item_row_editable_render ($row)
{
	$truefalse = array (0 => 'False', 1 => 'True');
	$truefalseid = array ('False' => 0, 'True' => 1);
        $o = array ();
        $o['soi_id'] = "<input type='text' name='soi_id' size='10' readonly value='" . $row['soi_id'] . "'>";
	$o['soi_visible'] = html_select_button ('soi_visible', $truefalse, $truefalse[$row['soi_visible']]);
        $o['soi_starttime'] = "<input type='text' name='soi_starttime' size='20' readonly value='" . $row['soi_starttime'] . "'>";
        $o['soi_endtime'] = "<input type='text' name='soi_endtime' size='20' readonly value='" . $row['soi_endtime'] . "'>";
        $o['soi_reason'] = "<input type='text' name='soi_reason' size='64' value='" . $row['soi_reason'] . "'>";
        $o['soi_action'] = "<input type='text' name='soi_action' size='64' value='" . $row['soi_action'] . "'>";
        $o['soi_resolution'] = "<input type='text' name='soi_resolution' size='64' value='" . $row['soi_resolution'] . "'>";
        $o['soi_seconds'] = "<input type='text' name='soi_seconds' size='10' value='" . $row['soi_seconds'] . "'>";
        return $o;
}


?>




