#!/usr/bin/php
<?php

/*** Setup the session */
session_start ();

include '../common-functions.php';
include '../validate-functions.php';
include '../page-functions.php';
include '../netinfo-config-variables.php';


# Defaults
$match_age = 86400;
$time_diff_secs = 3600;
$min_hits = 5;
$hit_fudge = 2;
$search_class = "";
$search_severity = "";
$search_state = "";
$search_object = "";
$search_hostname = "";
$verbosity = 0;
$noncleared = 0;
$alerts_processed = 0;

/*** Arguments Parsing */
$type = "";
$opts = getopt ('A:c:F:hH:No:rs:S:T:v');
foreach (array_keys($opts) as $opt) {
	switch ($opt) {
		case 'A':
			if (!is_valid_integer($opts['A'])) {
				print "The argument for -A must be an integer value.\n";
				return 1;
			}
			$match_age = $opts['A'];
			break;
		case 'c':
			if ($opts['c'] == "" || (!is_string($opts['c']))) {
				print "The argument for -c must be a valid class name.\n";
				return 1;
			}
			$search_class = $opts['c'];
			break;
		case 'C':
			if (!is_valid_integer($opts['C'])) {
				print "The argument for -C must be an integer value.\n";
				return 1;
			}
			$min_hits = $opts['C'];
			break;
		case 'F':
			if (!is_valid_integer($opts['F'])) {
				print "The argument for -F must be an integer value.\n";
				return 1;
			}
			$hit_fudge = $opts['F'];
			break;
		case 'h':
			print "Usage: alert-resolve-by-diagnosis.php [options]\n";
			print "Options:\n";
			print "  -A count	Set the record match age, in seconds.\n";
			print "  -c class	Limit the search to the specified class type.\n";
			print "  -C count	Set the minimum hit count.\n";
			print "  -F count	Set the fudge factor to the specified value.\n";
			print "  -h		This command usage help text.\n";
			print "  -H hostname	Limit the search to the specified host.\n";
			print "  -N 		Limit the search to non-cleared events.\n";
			print "  -o object	Limit the search to the specified object.\n";
			print "  -r		Actually resolve matched alert records.\n";
			print "  -s severity	Limit the search to the specified severity type.\n";
			print "  -T count	Set the time difference value, in seconds.\n";
			print "  -v		Increase debug output level (with each occurance).\n";
			print "\n";
			return 0;
			break;
		case 'H':
			if (!is_string($opts['H'])) {
				print "The argument for -H must be a hostname.\n";
				return 1;
			}
			$search_hostname = $opts['H'];
			break;
		case 'N':
			$noncleared = 1;
			break;
		case 'o':
			if (!is_string($opts['o'])) {
				print "The argument for -o must be a valid object name.\n";
				return 1;
			}
			$search_object = $opts['o'];
			break;
		case 'r':
			$type = 'Resolved';
			print "Alerts will be resolved, if possible.\n";
			break;
		case 's':
			if ($opts['s'] == "" || (!is_string($opts['s']))) {
				print "The argument for -s must be a valid severity name.\n";
				return 1;
			}
			$search_severity = $opts['s'];
			break;
		case 'S':
			if ($opts['S'] == "" || (!is_string($opts['S']))) {
				print "The argument for -S must be a valid state name.\n";
				return 1;
			}
			$search_state = $opts['S'];
			break;
		case 'T':
			if (!is_valid_integer($opts['T'])) {
				print "The argument for -T must be an integer value.\n";
				return 1;
			}
			$time_diff_secs = $opts['T'];
			break;
		case 'v':
			$verbosity++;
			break;
		default:
			print "Invalid switch used. Verify the specified parameters.\n";
			return 1;
	}
}

/*** Database Connection */
$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}
/*** Session Cache */
session_create_cache ();
$AlertClass = $_SESSION['AlertClass'];
$AlertClassId = $_SESSION['AlertClassId'];
$AlertSeverity = $_SESSION['AlertSeverity'];
$AlertSeverityId = $_SESSION['AlertSeverityId'];
$AlertState = $_SESSION['AlertState'];
$AlertStateId = $_SESSION['AlertStateId'];
$_SESSION['username'] = "SYSTEM";


/* Post cache-creation argument validation */
if ($search_class != "" && (!isset ($AlertClassId[$search_class]))) {
	print "The argument for -c must be a valid class name.\n";
	return 1;
}
if ($search_severity != "" && (!isset ($AlertSeverityId[$search_severity]))) {
	print "The argument for -s must be a valid severity name.\n";
	return 1;
}
if ($search_state != "" && (!isset ($AlertStateId[$search_state]))) {
	print "The argument for -s must be a valid state name.\n";
	return 1;
}



/* Get the list of 'cleared' alerts */
$alerts = array ();
$sql = "select a_id, a_hostname, a_object, a_class, a_severity, a_uniquestr,";
$sql .= " a_alerttime, time_to_sec(time(a_alerttime)) as a_ftime,";
$sql .= " a_lasttime, time_to_sec(time(a_lasttime)) as a_ltime,";
$sql .= " dayofweek(date(a_alerttime)) as a_weekday,";
$sql .= " a_message";
$sql .= " from alert";
$sql .= " where 1 = 1";

#$sql .= " and a_object not in ('HOST')";

$sql .= " and (unix_timestamp(NOW()) - unix_timestamp(a_lasttime)) > " . $match_age;

if ($search_class != "") {
	$sql .= " and a_class = " . $AlertClassId[$search_class];
}

if ($search_severity != "") {
	$sql .= " and a_severity = " . $AlertSeverityId[$search_severity];
}

if ($search_state != "") {
	$sql .= " and a_state = " . $AlertStateId[$search_state];
} else {
	if ($noncleared == 1) {
		print "WARNING: You specified that non-cleared alerts are available for resolving.\n";
		$sql .= " and a_state in (1,2)";
	} else {
		$sql .= " and a_state = 4";
	}
}

if ($search_hostname != "") {
	$sql .= " and a_hostname = '" . $search_hostname . "'";
}

if ($search_object != "") {
	$sql .= " and a_object = '" . $search_object . "'";
}

$sql .= " and a_object != 'NAGIOS'";
$sql .= " and a_object not like 'DR%'";
$sql .= " and a_object not like 'DY%'";

#$sql .= " and a_class = 5";

debug (1, "SQL='$sql'");
$result = mysql_query ($sql);
if ($result) {
	while ($row = mysql_fetch_assoc ($result)) {
		$alerts[] = $row;
	}
	mysql_free_result ($result);
} else {
	print "mysql_query(): " . mysql_error () . "\n";
	print "SQL: '" . $sql . "'\n";
	return 5;
}

/* Perform diagnosis on each alert */
foreach ($alerts as $a) {
	$weekday_match = 1;
	$result = alert_find_matching_resolution ($a, $time_diff_secs, $min_hits, 1);
	if ($result === FALSE) {
		# If we didn't find a match for the weekday...
		# try to find one without the weekday, but with a greater min_hits
		$weekday_match = 0;
		$result = alert_find_matching_resolution ($a,
							$time_diff_secs,
							$min_hits + $hit_fudge,
							0);
	}
	if ($result !== FALSE) {
		print "Alert:\n";
		#print_r ($a);
		printf ("%-12s => %s\n", "ID", $a['a_id']);
		printf ("%-12s => %s\n", "Hostname", $a['a_hostname']);
		printf ("%-12s => %s\n", "Object", $a['a_object']);
		printf ("%-12s => %s\n", "Class", $AlertClass[$a['a_class']]);
		printf ("%-12s => %s\n", "Severity", $AlertSeverity[$a['a_severity']]);
		printf ("%-12s => %s\n", "UniqueStr", $a['a_uniquestr']);
		printf ("%-12s => %s\n", "AlertTime", $a['a_alerttime']);
		printf ("%-12s => %s\n", "FTime", $a['a_ftime']);
		printf ("%-12s => %s\n", "LastTime", $a['a_lasttime']);
		printf ("%-12s => %s\n", "LTime", $a['a_ltime']);
		printf ("%-12s => %s\n", "WeekDay", $a['a_weekday']);
		printf ("%-12s => %s\n", "Message", $a['a_message']);
		print "Would be resolved with:\n";
		print "ResolutionText: " . stripslashes ($result['ad_data']) . "\n";
		print "Count: " . $result['count'] . "\n";
		print "WeekdayMatch: " . $weekday_match . "\n";

		# If '-r' was specified on the commandline, then actually resolve the alert
		if ($type == "Resolved") {
			$rc = alter_alert ($a['a_id'], "Resolved", stripslashes ($result['ad_data']));
			if ($rc != 0) {
				print "AlterAlert: Failed rc=$rc\n";
			} else {
				print "AlterAlert: Succeeded\n";
			}
		}

		print "\n\n";
	}
}
printf ("Alerts processed: %d\n", $alerts_processed);
mysql_close ($conn);
return 0;



function alert_find_matching_resolution ($alert, $time_diff_secs, $min_hits, $match_weekday)
{
	/* Validate parameters */
	if (!isset($alert['a_hostname']))
		return FALSE;
	if (!isset($alert['a_object']))
		return FALSE;
	if (!isset($alert['a_uniquestr']))
		return FALSE;
	if (!isset($alert['a_severity']))
		return FALSE;
	if (!isset($alert['a_ftime']))
		return FALSE;

	/* Find resolved alerts that occured within the same timeframe as this one */
	$low_secs = $alert['a_ftime'] - $time_diff_secs;
	if ($low_secs < 0) {
		#$low_secs += 86400;
		$low_secs = 0;
	}
	$hi_secs = $alert['a_ftime'] + $time_diff_secs;
	if ($hi_secs > 86400) {
		#$hi_secs -= 86400;
		$hi_secs = 86400;
	}
	if ($hi_secs < $low_secs) {
		$secs = $low_secs;
		$low_secs = $hi_secs;
		$hi_secs = $secs;
	}
	
	/* Search for a matching, resolved alert */
	$sql = "select ad_data, count(1) as count";
	$sql .= " from alert,alert_data";
	$sql .= " where ad_a_id = a_id";
	$sql .= " and a_hostname = '" . $alert['a_hostname'] . "'";
	$sql .= " and a_object = '" . $alert['a_object'] . "'";
	$sql .= " and a_uniquestr = '" . $alert['a_uniquestr'] . "'";
	$sql .= " and a_severity = " . $alert['a_severity'];
	$sql .= " and ad_type = 5";
	
	# Don't accept any resolutions that contains 'RFC' (specific issues)
	$sql .= " and ad_data not like '%RFC%'";
	
	# Don't accept any resolutions that contains ' maintenance ' (maintenance window)
	$sql .= " and ad_data not like '%maintenance%'";

	# Don't accept any resolutions that contains ' reboot '
	$sql .= " and ad_data not like '%reboot%'";

	# Don't accept any resolutions that contains ' hours' (has alert record aging requirements)
	$sql .= " and ad_data not like '% hours%'";

	# Don't accept any resolutions that are non-descriptive
	$sql .= " and ad_data not like 'Alert resolved%'";

	# Don't accept any resolutions that are RAC specific
	$sql .= " and ad_data not like '%RAC%'";

	# Don't accept any resolutions that are failure related
	$sql .= " and ad_data not like '%failure%'";

	# Don't accept any resolutions that were auto-closed
	$sql .= " and ad_data not like 'AUTOCLOSE:%'";

	# Don't accept any resolutions that were created by a SQL mistake
	$sql .= " and ad_data not like 'Port scan attack from GE%'";

	# Don't accept any resolutions that were created by an old resolution comment
	$sql .= " and ad_data not like 'This alert is a common occurrence%'";

	# Don't accept any resolutions that were created by an old resolution comment
	$sql .= " and ad_data not like '%monitoring script%'";


	if ($match_weekday == 1) {
		$sql .= " and dayofweek(date(a_alerttime)) = " . $alert['a_weekday'];
	}
	$sql .= " and time_to_sec(time(a_alerttime)) between $low_secs and $hi_secs";
	$sql .= " group by ad_data order by count desc limit 1";
	debug (1, "SQL='$sql'");
	$result = mysql_query ($sql);
	if ($result) {
		/* Did we find a row? */
		if (mysql_num_rows ($result) == 1) {
			$row = mysql_fetch_assoc ($result);
			mysql_free_result ($result);
			/* We want at least 'min_hits' matches ... to be sure */
			if ($row['count'] >= $min_hits) {
				return $row;
			}
		}
	} else {
		print "mysql_query(): " . mysql_error () . "\n";
		print "SQL: '" . $sql . "'\n";
	}
	return FALSE;
}


function alter_alert ($aid, $type, $message)
{
	global $alerts_processed;
	$AlertState = $_SESSION['AlertState'];
	$AlertStateId = $_SESSION['AlertStateId'];
	/*** Check the AlertID */
	$sql = sprintf ("select a_id,a_state from alert where a_id = %d",
			$aid);
	$result = mysql_query ($sql);
	if ($result) {
		$row = mysql_fetch_row ($result);
		$aid = $row[0];
		$astate = $row[1];
		mysql_free_result ($result);
	} else {
		print ("That AlertID could not be located.\n");
		return 3;
	}
	if ($aid == 0) {
		print ("That AlertID could not be located.\n");
		return 3;
	}
	if ($AlertState[$astate] != "Cleared"
	    && $AlertState[$astate] != "Acknowledged"
	    && $AlertState[$astate] != "New"
	    && $AlertState[$astate] != "New(Dups)") {
		printf ("That alert is not in the correct state for this operation (%s).\n",
			$AlertState[$astate]);
		return 4;
	}

	/*** Change the alert */
	# BEGIN TRANSACTION
	$sql = sprintf ("update alert set a_state = %d where a_id = %d",
			$AlertStateId[$type],
			$aid);
	debug (3, "SQL='$sql'");
	$result = mysql_query ($sql);
	if ($result == FALSE) {
		print "mysql_query(): " . mysql_error () . "\n";
		print "SQL: '" . $sql . "'\n";
		# ROLLBACK TRANSACTION
		return 5;
	} else {
		$adt = $_SESSION['AlertDataType'];
		if ($type == "Resolved") {
			$rc = alert_note ($aid, $adt['Resolved'], $message);
			if ($rc != 0) {
				print ("alert_note(): Failed\n");
				# ROLLBACK TRANSACTION
				return $rc;
			}
		}
	}
	# COMMIT TRANSACTION
	$alerts_processed++;
	return 0;
}


function debug ($level, $message)
{
	global $verbosity;
	if ($verbosity >= $level) {
		print $message . "\n";
	}
	return;
}


?>
