#!/usr/bin/php
<?php


/*** Setup the session */
session_start ();

include '../common-functions.php';
include '../validate-functions.php';
include '../page-functions.php';
include '../netinfo-config-variables.php';


/*** Arguments Parsing */
$type = "";
$message = "";
$username = "";
$count = 0;
$countids = false;
$opts = getopt ('acf:i:m:rsu:');
foreach (array_keys($opts) as $opt) {
	switch ($opt) {
		case 'a':
			$type = 'Acknowledged';
			break;
		case 'c':
			$countids = true;
			break;
		case 'f':
			$idfile = $opts['f'];
			break;
		case 'i':
			$aid = $opts['i'];
			break;
		case 'm':
			$message = $opts['m'];
			break;
		case 'r':
			$type = 'Resolved';
			break;
		case 'u':
			$username = $opts['u'];
			break;
	}
}
if ( ($aid == "" || $aid == 0) && $idfile == "") {
	print "You must specify the -i argument followed by an AlertID,";
	print "or the -f argument followed by a filename which contains ";
	print "the alerts which will be altered.\n";
	return 1;
}
if ($aid != "" && $aid != 0 && !is_valid_integer ($aid)) {
	print "The AlertID you specified is invalid.\n";
	return 1;
}
if ($type == "") {
	print "You must specify either the -a or -r argument.\n";
	return 1;
}
if ($message == "") {
	print "You must specify the -m argument followed by a message.\n";
	return 1;
}
if ($username == "") {
	print "You must specify the -u argument followed by your username.\n";
	return 1;
}
$_SESSION['username'] = $username;


/*** Database Connection */
$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}

/*** Session Cache */
session_create_cache ();
#$AlertClass = $_SESSION['AlertClass'];
#$AlertClassId = $_SESSION['AlertClassId'];
#$AlertSeverity = $_SESSION['AlertSeverity'];
$AlertState = $_SESSION['AlertState'];
$AlertStateId = $_SESSION['AlertStateId'];
#$Preference = $_SESSION['preferences'];


if ($aid != "" && $aid != 0) {
	$rc = alter_alert ($aid, $type, $message);
	return $rc;
} else if ($idfile != "") {
	$fh = fopen ($idfile, "r");
	while (!feof ($fh)) {
		$line = fgets ($fh);
		$aid = rtrim($line, "\n");
		if (is_valid_integer ($aid)) {
			$rc = alter_alert ($aid, $type, $message);
		} else {
			printf ("'%s' is not a valid AlertID, skipping.\n", $line);
		}
		$count++;
		if ($countids == true) {
			if ($count % 10) {
				printf ("Altered %d alerts.\n", $count);
			}
		}
	}
	fclose ($fh);
} else {
	printf ("Missing an ID or idfile.\n");
	return 1;
}

return 0;



function alter_alert ($aid, $type, $message)
{
	$AlertState = $_SESSION['AlertState'];
	$AlertStateId = $_SESSION['AlertStateId'];
	/*** Check the AlertID */
	$sql = sprintf ("select a_id,a_state from alert where a_id = %d",
			$aid);
	$result = mysql_query ($sql);
	if ($result) {
		$row = mysql_fetch_row ($result);
		$aid = $row[0];
		$astate = $row[1];
		mysql_free_result ($result);
	} else {
		print ("That AlertID could not be located.\n");
		return 3;
	}
	if ($aid == 0) {
		print ("That AlertID could not be located.\n");
		return 3;
	}
	if ($AlertState[$astate] != "Cleared"
	    && $AlertState[$astate] != "Acknowledged"
	    && $AlertState[$astate] != "New"
	    && $AlertState[$astate] != "New(Dups)") {
		printf ("That alert is not in the correct state for this operation (%s).\n",
			$AlertState[$astate]);
		return 4;
	}

	/*** Change the alert */
	$sql = sprintf ("update alert set a_state = %d where a_id = %d",
			$AlertStateId[$type],
			$aid);
	$result = mysql_query ($sql);
	if ($result == FALSE) {
		print "mysql_query(): " . mysql_error () . "\n";
		print "SQL: '" . $sql . "'\n";
		return 5;
	} else {
		$adt = $_SESSION['AlertDataType'];
		if ($type == "Acknowledged") {
			$rc = alert_note ($aid, $adt['Acknowledged'], $message);
			if ($rc != 0) {
				print ("alert_note(): Failed\n");
				return $rc;
			}
		} else if ($type == "Resolved") {
			$rc = alert_note ($aid, $adt['Resolved'], $message);
			if ($rc != 0) {
				print ("alert_note(): Failed\n");
				return $rc;
			}
		}
		#$rc = alert_action ($aid, $message);
		#if ($rc != 0) {
		#		print ("alert_action(): Failed\n");
		#	return $rc;
		#}
	}
	return 0;
}




?>
