#!/usr/bin/php
<?php

$version = "0.0.1";

/*** Setup the session */
session_start ();

include '../common-functions.php';
include '../validate-functions.php';
#include '../page-functions.php';
include '../netinfo-config-variables.php';

/*** Arguments Parsing */
$classname = "";
$date = "";
$hitcount = 0;
$count = 0;
$countids = false;
$opts = getopt ('c:d:H:hV');
foreach (array_keys($opts) as $opt) {
	switch ($opt) {
		case 'c':
			$classname = $opts['c'];
			break;
		case 'd':
			$date = $opts['d'];
			break;
		case 'H':
			$hitcount = $opts['H'];
			break;
		case 'h':
			print "Usage:\n";
			print "security-alert-report-24hour.php [options]\n";
			print "   -d date           Specify the date to query\n";
			print "   -c class          Specify the object class to query\n";
			return 0;
			break;
		case 'V':
			print "security-alert-report-24hour.php - Version $version\n";
			return 0;
			break;
	}
}
if ($date == "") {
	print "You must specify the -d argument followed by a date.\n";
	return 1;
}
if (!is_valid_date ($date)) {
	print "You must specify a valid date for the -d argument.\n";
	return 1;
}

/*** Database Connection */
$conn = db_connect ();
if ($conn == FALSE) {
	print "db_connect(): failed\n";
	return 2;
}

# AlertClass mapping hashes
$sql = "select ac_id, ac_name from alert_class";
$result = mysql_query ($sql);
if ($result) {
	while ($row = mysql_fetch_row ($result)) {
		$AlertClass[$row[0]] = $row[1];
		$AlertClassId[$row[1]] = $row[0];
	}
	mysql_free_result ($result);
} else {
	print "mysql_query(): " . mysql_error () . "\n";
	print "SQL: '" . $sql . "'\n";
	return 5;
}


if (!isset ($AlertClassId[$classname])) {
	print "The class you specified is invalid. Please select from the classes listed below:\n";
	print_r ($AlertClassId);
	return 3;
}
$class = $AlertClassId[$classname];
$sql = sprintf ("select a_id as 'AlertID',a_hostname as 'Detect Host',a_alerttime as 'Detect Time',a_hitcount as 'Hits',a_message as 'Message' from alert where date(a_alerttime) = '%s' and a_class = %d", $date, $class);
if ($hitcount > 0) {
	$sql .= sprintf (" and a_hitcount >= %d", $hitcount);
}
$result = mysql_query ($sql);
if ($result == FALSE) {
	print "mysql_query(): " . mysql_error () . "\n";
	print "SQL: '" . $sql . "'\n";
	return 5;
}

printf ("\n%s Alert Report for %s\n\n",
		$classname,
		$date);

printf ("%-10s %-20s %-20s %-5s %s\n",
	"AlertID",
	"Detect Host",
	"Detect Time",
	"Hits",
	"Message");
printf ("------------------------------------------------------------------------------\n");
while ($row = mysql_fetch_row ($result)) {
	printf ("%-10s %-20s %-20s %-5s %s\n",
		$row[0],
		$row[1],
		$row[2],
		$row[3],
		rtrim ($row[4]));
}
mysql_free_result ($result);

return 0;


?>

