#!/bin/sh
#
# daily-graph-client-process-runtimes.sh
#


# The first date we known we have good data
STARTDATE="2009-08-18"

REPORTDIR=/var/www/html/reports/client-process-runtimes
INDEXFILE=$REPORTDIR/index.html
AVERAGEFILE=$REPORTDIR/average.html

OCD=`pwd`
cd /var/www/netinfo/scripts

CPLISTFILE=./client-process.list

cat >$INDEXFILE << EOF
<html>
<head><title>Client Process Runtimes since 2009-08-18 (The beginning of time)<title></head>
<body>
EOF

cat >$AVERAGEFILE << EOF
<html>
<head><title>Client Process Runtime 30 day average<title></head>
<body>
EOF

./client-process-list.php >$CPLISTFILE

for LN in `cat $CPLISTFILE` ; do
	TYPE=`echo $LN|cut -d':' -f1`
	NAME=`echo $LN|cut -d':' -f2`
	sh ./graph-process-steps-data.sh $TYPE $NAME 2009-08-18
	echo "<p>" >>$INDEXFILE
	echo "<img src='/reports/client-process-runtimes/process-runtimes-$TYPE-$NAME.png'>" >>$INDEXFILE
	echo "<a href='/reports/client-process-runtimes/process-runtimes-$TYPE-$NAME.data'>Data</a>" >>$INDEXFILE
	echo "</p>" >>$INDEXFILE

	echo "<p>" >>$AVERAGEFILE
	AVG=`cat $REPORTDIR/process-runtimes-$TYPE-$NAME.data|tail -n 30|awk '{print $4}'|average`
	echo "$TYPE.$NAME.average=$AVG" >>$AVERAGEFILE
	echo "</p>" >>$AVERAGEFILE
done

cat >>$INDEXFILE << EOF
<body>
</html>
EOF

cat >>$AVERAGEFILE << EOF
<body>
</html>
EOF


mv -f *.data *.png $REPORTDIR
cp -p $REPORTDIR/index.html $REPORTDIR/index.php
rm -f $CPLISTFILE

exit 0

