#!/bin/sh
#
#
#

PTYPE=$1
PROCESS=$2
SDT=$3


DT=`date '+%y-%m-%d'`
OUTFILE=./process-runtimes-$PTYPE-$PROCESS.data
PNGFILE=./process-runtimes-$PTYPE-$PROCESS.png

/var/www/netinfo/scripts/process-steps-calculate-averages.php -t $PTYPE -o $PROCESS -s $SDT |grep runtime >$OUTFILE

# Now generate the graphs
gnuplot << EOF
set terminal png
set output '$PNGFILE'
set title '$PROCESS runtime data since $SDT'
set xlabel 'Date'
set timefmt "%Y-%m-%d"
set xdata time
#set xrange ["00:00":"23:59"]
#set format x "%H"
set ylabel 'Minutes'
#set yrange [0:100]
set size 1.5,0.50
plot '$OUTFILE' using 1:4 t 'Runtime' with lines
EOF
