#!/usr/bin/perl
# nagios-list-objects.pl - List Nagios objects in the file specified.

$ARGS = @ARGV;
if ($ARGS < 1) {
	print "Missing argument.\n";
	exit 1;
}

$ufields = 0;
if ($ARGV[1] ne "") {
	@ofields = split (',', $ARGV[1]);
	$ufields = 1;
}

open (OF, $ARGV[0]) || die "Failed to open object file.\n";
while ( <OF> ) {
	$line = $_;
	chomp $line;
	if ($line =~ /^define /) {
		($junk,$objtype) = split (' ', $line);
		$objtype =~ s/{//;
		$inhost = 1;
		next;
	}
	$line =~ s/^[\t ]+//g;
	$line =~ s/[\t ]+/ /g;
	if ($line =~ /^#/) {
		next;
	}
	if ($line =~ /}/) {
		$oline = "objtype=" . $objtype;
		if ($ufields == 1) {
			@fields = @ofields;
		} else {
			@fields = keys %object;
		}
		foreach $key (@fields) {
			$oline .= ";";
			$oline .= $key . "=" . $object{$key};
		}
		print $oline . "\n";
		$inhost = 0;
		%object = ();
	}
	if ($inhost == 1) {
		($name,$value) = split (' ', $line, 2);
		$object{$name} = $value;
	}
}
close (OF);

exit 0;

