#!/bin/sh
#
# netinfo-regular-alert-cleanup.sh - Execute alert cleanup tasks
#

db_user="netinfou"
db_pass="!N3t1nF0%"


# Cleanup weekly scheduled reboot items
echo "select a_id from alert where a_state in (4) and a_object in ('CITRIXXML','CITRIXHCA','PING') and time(a_alerttime) between '22:00:00' and '23:59:59' and dayofweek(a_alerttime) = 7"|mysql --user=${db_user} --password=${db_pass} netinfo >id.weeklyreboot
echo "WeeklyReboot: Found `wc -l id.weeklyreboot` alerts to resolve."
php ./alert-resolve.php -u tshadburn -r -f id.weeklyreboot -m "This alert occurred during the weekly scheduled reboot timeframe."

# Resolve DST/JM internal system port access failures
echo "select a_id from alert where a_state in (1,2) and a_object in ('multiservice-directed','service-scan') and a_hitcount < 20 and a_message like '% 10.%'" |mysql --user=${db_user} --password=${db_pass} netinfo >id.internal
echo "Internal port attempt: Found `wc -l id.internal` alerts to resolve."
php ./alert-resolve.php -u tshadburn -r -f id.internal -m "Failed port access attempts from a DST/JM internal system."

# Resolve DST DR system port access failures
echo "select a_id from alert where a_state in (1,2) and a_object = 'multiservice-directed' and a_hitcount < 8 and a_message like '% 192.168.60.%'" |mysql --user=${db_user} --password=${db_pass} netinfo >id.dstdr
echo "DR port attempt: Found `wc -l id.dstdr` alerts to resolve."
php ./alert-resolve.php -u tshadburn -r -f id.dstdr -m "Failed port access attempts from a DST DR system."

# Resolve external system port access failures
echo "select a_id from alert where a_state in (1,2) and a_object = 'multiservice-directed' and a_hitcount < 8" |mysql --user=${db_user} --password=${db_pass} netinfo >id.external
echo "External port attempt: Found `wc -l id.external` alerts to resolve."
php ./alert-resolve.php -u tshadburn -r -f id.external -m "Failed port access attempts from an unknown origin."

# Resolve external system port access failures (low hit count)
echo "select a_id from alert where a_state in (1,2) and a_object in ('service-directed','service-scan') and a_hitcount < 3" |mysql --user=${db_user} --password=${db_pass} netinfo >id.external2
echo "External port attempt: Found `wc -l id.external2` alerts to resolve."
php ./alert-resolve.php -u tshadburn -r -f id.external2 -m "Failed port access attempts from an unknown origin."

exit 0

