-- MySQL dump 10.10
--
-- Host: localhost    Database: netinfo
-- ------------------------------------------------------
-- Server version	5.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `alert`
--

DROP TABLE IF EXISTS `alert`;
CREATE TABLE `alert` (
  `a_id` bigint(20) NOT NULL auto_increment,
  `a_alerttime` timestamp NULL default NULL,
  `a_lasttime` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `a_class` int(11) NOT NULL,
  `a_severity` int(11) NOT NULL,
  `a_state` int(11) NOT NULL,
  `a_uniqueid` int(11) NOT NULL,
  `a_hitcount` int(11) NOT NULL default '1',
  `a_hostname` varchar(64) NOT NULL,
  `a_object` varchar(64) NOT NULL,
  `a_uniquestr` varchar(64) NOT NULL,
  `a_message` varchar(255) NOT NULL,
  PRIMARY KEY  (`a_id`),
  KEY `i_a_hostobject` (`a_hostname`,`a_object`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_action`
--

DROP TABLE IF EXISTS `alert_action`;
CREATE TABLE `alert_action` (
  `aa_id` bigint(20) NOT NULL auto_increment,
  `aa_a_id` bigint(20) NOT NULL,
  `aa_timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `aa_user` varchar(64) default NULL,
  `aa_info` text,
  PRIMARY KEY  (`aa_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_class`
--

DROP TABLE IF EXISTS `alert_class`;
CREATE TABLE `alert_class` (
  `ac_id` int(11) NOT NULL,
  `ac_name` varchar(32) NOT NULL,
  PRIMARY KEY  (`ac_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_data`
--

DROP TABLE IF EXISTS `alert_data`;
CREATE TABLE `alert_data` (
  `ad_id` bigint(20) NOT NULL auto_increment,
  `ad_a_id` bigint(20) NOT NULL,
  `ad_timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `ad_type` int(11) NOT NULL,
  `ad_name` varchar(32) NOT NULL,
  `ad_data` blob,
  PRIMARY KEY  (`ad_id`),
  KEY `i_ad_a_id` (`ad_a_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_history`
--

DROP TABLE IF EXISTS `alert_history`;
CREATE TABLE `alert_history` (
  `ah_id` bigint(20) NOT NULL,
  `ah_alerttime` timestamp NOT NULL default '0000-00-00 00:00:00',
  `ah_lasttime` timestamp NOT NULL default '0000-00-00 00:00:00',
  `ah_class` int(11) NOT NULL,
  `ah_severity` int(11) NOT NULL,
  `ah_state` int(11) NOT NULL,
  `ah_uniqueid` int(11) NOT NULL,
  `ah_hostname` varchar(64) NOT NULL,
  `ah_object` varchar(64) NOT NULL,
  `ah_message` varchar(255) NOT NULL,
  PRIMARY KEY  (`ah_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_severity`
--

DROP TABLE IF EXISTS `alert_severity`;
CREATE TABLE `alert_severity` (
  `as_id` int(11) NOT NULL,
  `as_name` varchar(32) NOT NULL,
  PRIMARY KEY  (`as_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `alert_state`
--

DROP TABLE IF EXISTS `alert_state`;
CREATE TABLE `alert_state` (
  `ast_id` int(11) NOT NULL,
  `ast_name` varchar(32) NOT NULL,
  PRIMARY KEY  (`ast_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `object`
--

DROP TABLE IF EXISTS `object`;
CREATE TABLE `object` (
  `o_id` int(11) NOT NULL auto_increment,
  `o_otid` int(11) NOT NULL,
  `o_name` varchar(32) NOT NULL,
  PRIMARY KEY  (`o_id`),
  KEY `i_o_name` (`o_name`),
  KEY `c_o_otid` (`o_otid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `objectattr`
--

DROP TABLE IF EXISTS `objectattr`;
CREATE TABLE `objectattr` (
  `oa_id` int(11) NOT NULL auto_increment,
  `oa_oid` int(11) NOT NULL,
  `oa_oadid` int(11) NOT NULL,
  `oa_value` blob NOT NULL,
  PRIMARY KEY  (`oa_id`),
  KEY `c_oa_oid` (`oa_oid`),
  KEY `c_oa_oadid` (`oa_oadid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `objectattrdata`
--

DROP TABLE IF EXISTS `objectattrdata`;
CREATE TABLE `objectattrdata` (
  `oad_id` int(11) NOT NULL auto_increment,
  `oad_name` varchar(32) NOT NULL,
  `oad_description` varchar(255) NOT NULL,
  `oad_valuetype` char(8) NOT NULL,
  PRIMARY KEY  (`oad_id`),
  KEY `i_oad_name` (`oad_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `objectattrprop`
--

DROP TABLE IF EXISTS `objectattrprop`;
CREATE TABLE `objectattrprop` (
  `oap_id` int(11) NOT NULL auto_increment,
  `oap_otid` int(11) NOT NULL,
  `oap_oadid` int(11) NOT NULL,
  `oap_required` int(11) NOT NULL default '0',
  PRIMARY KEY  (`oap_id`),
  KEY `c_oap_otid` (`oap_otid`),
  KEY `c_oap_oadid` (`oap_oadid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `objecttype`
--

DROP TABLE IF EXISTS `objecttype`;
CREATE TABLE `objecttype` (
  `ot_id` int(11) NOT NULL auto_increment,
  `ot_name` varchar(32) NOT NULL,
  `ot_description` varchar(255) NOT NULL,
  PRIMARY KEY  (`ot_id`),
  KEY `i_ot_name` (`ot_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `system_group`
--

DROP TABLE IF EXISTS `system_group`;
CREATE TABLE `system_group` (
  `sg_id` bigint(20) NOT NULL auto_increment,
  `sg_groupname` varchar(32) NOT NULL,
  `sg_groupdesc` varchar(64) NOT NULL,
  PRIMARY KEY  (`sg_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `system_group_user`
--

DROP TABLE IF EXISTS `system_group_user`;
CREATE TABLE `system_group_user` (
  `sgu_id` bigint(20) NOT NULL auto_increment,
  `sgu_su_id` bigint(20) NOT NULL,
  `sgu_sg_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`sgu_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `system_parameter`
--

DROP TABLE IF EXISTS `system_parameter`;
CREATE TABLE `system_parameter` (
  `sp_id` bigint(20) NOT NULL auto_increment,
  `sp_name` varchar(64) NOT NULL,
  `sp_value` text NOT NULL,
  PRIMARY KEY  (`sp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `system_user`
--

DROP TABLE IF EXISTS `system_user`;
CREATE TABLE `system_user` (
  `su_id` bigint(20) NOT NULL auto_increment,
  `su_username` varchar(32) NOT NULL,
  `su_authdata` varchar(128) NOT NULL,
  `su_fullname` varchar(64) NOT NULL,
  `su_email` varchar(64) NOT NULL,
  `su_workphone` varchar(24) NOT NULL,
  `su_cellphone` varchar(24) NOT NULL,
  PRIMARY KEY  (`su_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `trap_filter`
--

DROP TABLE IF EXISTS `trap_filter`;
CREATE TABLE `trap_filter` (
  `tf_id` bigint(20) NOT NULL auto_increment,
  `tf_class` int(11) NOT NULL,
  `tf_severity` int(11) NOT NULL,
  `tf_uniqueid` int(11) NOT NULL,
  `tf_markrecover` int(11) NOT NULL,
  `tf_name` varchar(64) NOT NULL,
  `tf_desc` varchar(128) NOT NULL,
  `tf_trapoid` varchar(128) NOT NULL,
  `tf_object` varchar(64) NOT NULL,
  `tf_msg` varchar(255) NOT NULL,
  `tf_unique` int(11) NOT NULL default '0',
  `tf_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`tf_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `trap_filter_match`
--

DROP TABLE IF EXISTS `trap_filter_match`;
CREATE TABLE `trap_filter_match` (
  `tfm_id` bigint(20) NOT NULL auto_increment,
  `tfm_tf_id` bigint(20) NOT NULL,
  `tfm_oid` varchar(64) NOT NULL,
  `tfm_comparator` varchar(16) NOT NULL,
  `tfm_value` varchar(64) NOT NULL,
  PRIMARY KEY  (`tfm_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `user_attribute`
--

DROP TABLE IF EXISTS `user_attribute`;
CREATE TABLE `user_attribute` (
  `ua_id` bigint(20) NOT NULL auto_increment,
  `ua_username` varchar(32) NOT NULL,
  `ua_attribute` varchar(32) NOT NULL,
  `ua_value` varchar(128) NOT NULL,
  PRIMARY KEY  (`ua_id`),
  KEY `i_ua_username` (`ua_username`),
  KEY `i_ua_attribute` (`ua_attribute`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



--
-- Table structure for table `alert_rule_match`
--

DROP TABLE IF EXISTS `alert_rule_match`;
CREATE TABLE `alert_rule_match` (
  `arm_id` bigint(20) NOT NULL auto_increment,
  `arm_ar_id` bigint(20) NOT NULL,
  `arm_order` smallint(6) NOT NULL,
  `arm_type` smallint(6) NOT NULL,
  `arm_item` varchar(64) NOT NULL,
  `arm_comparator` varchar(8) NOT NULL,
  `arm_value` varchar(128) NOT NULL,
  PRIMARY KEY  (`arm_id`),
  KEY `i_arm_ar_id` (`arm_ar_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `alert_rule`
--

DROP TABLE IF EXISTS `alert_rule`;
CREATE TABLE `alert_rule` (
  `ar_id` bigint(20) NOT NULL,
  `ar_name` varchar(32) NOT NULL,
  `ar_desc` varchar(64) NOT NULL,
  `ar_active` smallint(6) NOT NULL default '0',
  `ar_order` int(11) NOT NULL default '1',
  PRIMARY KEY  (`ar_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- Table structure for table `alert_rule_action`
--

DROP TABLE IF EXISTS `alert_rule_action`;
CREATE TABLE `alert_rule_action` (
  `ara_id` bigint(20) NOT NULL auto_increment,
  `ara_ar_id` bigint(20) NOT NULL,
  `ara_order` smallint(6) NOT NULL,
  `ara_type` smallint(6) NOT NULL,
  `ara_item` varchar(64) NOT NULL,
  `ara_value` varchar(128) NOT NULL,
  PRIMARY KEY  (`ara_id`),
  KEY `i_ara_ar_id` (`ara_ar_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

