#!/usr/bin/php
<?php

$version = "0.0.1";

/*** Setup the session */
session_start ();

include '../common-functions.php';
#include '../validate-functions.php';
#include '../page-functions.php';
include '../netinfo-config-variables.php';

/*** Arguments Parsing */
$type = "";
$message = "";
$username = "";
$count = 0;
$countids = false;
$opts = getopt ('ho:p:t:V');
foreach (array_keys($opts) as $opt) {
	switch ($opt) {
		case 'o':
			$objname = $opts['o'];
			break;
		case 'p':
			$propname = $opts['p'];
			break;
		case 't':
			$objtype = $opts['t'];
			break;
		case 'h':
			print "Usage:\n";
			print "object-get-property.php [options] objectname\n";
			print "   -o objectname     Specify the object to query\n";
			print "   -p propname       Specify the object property to query\n";
			print "   -t objecttype     Specify the object type to query\n";
			return 0;
			break;
		case 'V':
			print "object-get-property.php - Version $version\n";
			return 0;
			break;
	}
}
if ( ($aid == "" || $aid == 0) && $idfile == "") {
	print "You must specify the -i argument followed by an AlertID,";
	print "or the -f argument followed by a filename which contains ";
	print "the alerts which will be altered.\n";
	return 1;
}
if ($aid != "" && $aid != 0 && !is_valid_integer ($aid)) {
	print "The AlertID you specified is invalid.\n";
	return 1;
}

/*** Database Connection */
$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}


if ($idfile != "") {
	$fh = fopen ($idfile, "r");
	while (!feof ($fh)) {
		$line = fgets ($fh);
		$aid = rtrim($line, "\n");
		if (is_valid_integer ($aid)) {
			$sql = sprintf ("update alert_data set ad_type = %d where ad_id = %d",
					4,
					$aid);
			$result = mysql_query ($sql);
			if ($result == FALSE) {
				print "mysql_query(): " . mysql_error () . "\n";
				print "SQL: '" . $sql . "'\n";
				return 5;
			}
		} else {
			printf ("'%s' is not a valid AlertID, skipping.\n", $line);
		}
		$count++;
		if ($countids == true) {
			if ($count % 10) {
				printf ("Altered %d alert_data records.\n", $count);
			}
		}
	}
	fclose ($fh);
} else {
	printf ("Missing an ID or idfile.\n");
	return 1;
}

return 0;


?>

