#
#    object-model.sql - An object-model database schema
#    Copyright (C) 2006,2008 Todd Shadburn
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#


##########################################################################
# Object Model tables
##########################################################################
DROP TABLE IF EXISTS `object_type`;
create table object_type (
	ot_id		int(11) not null primary key auto_increment,
	ot_parent_ot_id	int(11) not null,
	ot_name		varchar(32) not null,
	ot_description	varchar(255) not null
) ENGINE=InnoDB;


# Used for multi-parent type relationships
DROP TABLE IF EXISTS `object_type_relationship`;
create table object_type_relationship (
	otr_id		int(11) not null primary key auto_increment,
	otr_src_ot_id	int(11) not null,
	otr_tgt_ot_id	int(11) not null,
	constraint c_otr_src_ot_id foreign key (otr_src_ot_id) references object_type (ot_id),
	constraint c_otr_tgt_ot_id foreign key (otr_tgt_ot_id) references object_type (ot_id)
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object`;
create table object (
	o_id		int(11) not null primary key auto_increment,
	o_otid		int(11) not null,
	o_name		varchar(32) not null,
	index i_o_name (o_name),
	constraint c_o_otid foreign key (o_otid) references object_type (ot_id)
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object_attribute_type`;
create table object_attribute_type (
	oat_id		int(11) not null primary key auto_increment,
	oat_name	varchar(32) not null,
	oat_description	varchar(255) not null,
	oat_valuetype	char(8) not null
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object_attribute`;
create table object_attribute (
	oa_id		int(11) not null primary key auto_increment,
	oa_o_id		int(11) not null,
	oa_oat_id	int(11) not null,
	oa_value	blob not null,
	index i_oa_o_id (oa_o_id),
	index i_oa_oat_id (oa_oat_id),
	constraint c_oa_oid foreign key (oa_o_id) references object (o_id),
	constraint c_oa_oatid foreign key (oa_oat_id) references object_attribute_type (oat_id)
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object_attribute_property`;
create table object_attribute_property (
	oap_id		int(11) not null primary key auto_increment,
	oap_ot_id	int(11) not null,
	oap_oat_id	int(11) not null,
	oap_required	int(11) not null default '0',
	constraint c_oap_otid foreign key (oap_ot_id) references object_type (ot_id),
	constraint c_oap_oatid foreign key (oap_oat_id) references object_attribute_type (oat_id)
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object_relationship`;
create table object_relationship (
	or_id		int(11) not null primary key auto_increment,
	or_layer_id	int(11) not null default '0',
	or_src_o_id	int(11) not null,
	or_tgt_o_id	int(11) not null,
	index i_or_src_o_id (or_src_o_id),
	index i_or_tgt_o_id (or_tgt_o_id),
	constraint c_or_src_o_id foreign key (or_src_o_id) references object (o_id),
	constraint c_or_tgt_o_id foreign key (or_tgt_o_id) references object (o_id)
) ENGINE=InnoDB;


DROP TABLE IF EXISTS `object_change`;
create table object_change (
	oc_id		int(11) not null primary key auto_increment,
	oc_o_id		int(11) not null,
	oc_oa_id	int(11) not null,
	oc_timestamp	timestamp NULL default NULL,
	oc_info		varchar(255) not null,
	index i_oc_o_id (oc_o_id),
	constraint c_oc_o_id foreign key (oc_o_id) references object (o_id),
	constraint c_oc_oa_id foreign key (oc_oa_id) references object_attribute (oa_id)
) ENGINE=InnoDB;
	

##########################################################################
# Basic Model
##########################################################################
# create base object_type records
insert into object_type (ot_id,ot_parent_ot_id,ot_name,ot_description) values (1, 0, "host", "An instance of a physical or logical host.");
insert into object_type (ot_id,ot_parent_ot_id,ot_name,ot_description) values (2, 1, "service", "An instance of a service.");
insert into object_type (ot_id,ot_parent_ot_id,ot_name,ot_description) values (3, 0, "client", "An instance of a client.");
insert into object_type (ot_id,ot_parent_ot_id,ot_name,ot_description) values (4, 0, "application", "An instance of an application.");
insert into object_type (ot_id,ot_parent_ot_id,ot_name,ot_description) values (5, 2, "schema", "An instance of a database schema.");

# create base object_attribute_type records
insert into object_attribute_type values (1, "parent", "An object's parent object.", "string");
insert into object_attribute_type values (2, "hostname", "An object's hostname.", "string");
insert into object_attribute_type values (3, "ipaddress", "An object's IP address.", "string");
insert into object_attribute_type values (4, "description", "An object's description.", "string");
insert into object_attribute_type values (5, "serialnumber", "An object's serial number.", "string");
insert into object_attribute_type values (6, "assettag", "An object's asset tag.", "string");
insert into object_attribute_type values (7, "manufacturer", "An object's manufacturer.", "string");
insert into object_attribute_type values (8, "model", "An object's model.", "string");
insert into object_attribute_type values (9, "sid", "An object's SID.", "string");
insert into object_attribute_type values (10, "key", "An object's key.", "string");
insert into object_attribute_type values (11, "parenttype", "An object's parent object type.", "string");

# create object_attribute_property: host
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 1, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 2, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 3, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 4, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 5, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 6, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 7, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 8, 1);
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (1, 11, 0);

# create object_attribute_property: service
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (2, 1, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (2, 4, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (2, 11, 0);

# create object_attribute_property: client
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (3, 1, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (3, 4, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (3, 11, 0);

# create object_attribute_property: application
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (4, 1, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (4, 4, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (4, 10, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (4, 11, 0);

# create object_attribute_property: schema
#insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (5, 1, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (5, 4, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (5, 9, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (5, 10, 1);
insert into object_attribute_property (oap_ot_id,oap_oat_id,oap_required) values (5, 11, 0);


