#!/usr/bin/php
<?php

/*** Setup the session */
session_start ();

include '../common-functions.php';
include '../validate-functions.php';
include '../page-functions.php';
include '../netinfo-config-variables.php';



# Defaults
$verbosity = 0;
$search_object = "";
$process_type= array ();


/* No user serviceable parts below this line */

$process_info = array (
	'daily' => array (
			"begin_ident" => "Daily Processing Beginning",
			"end_ident" => "processing completed successfully",
			"fail_ident" => "failed",
			),
	'dateroll' => array (
			"begin_ident" => "Signon Process Beginning",
			"end_ident" => "Signon Completed",
			"fail_ident" => "Not Complete",
			),
	);


/*** Arguments Parsing */
$type = "";
$opts = getopt ('e:ht:o:s:v');
foreach (array_keys($opts) as $opt) {
	switch ($opt) {
		#case 'A':
		#	if (!is_valid_integer($opts['A'])) {
		#		print "The argument for -A must be an integer value.\n";
		#		return 1;
		#	}
		#	$match_age = $opts['A'];
		#	break;
		case 'e':
			if (!is_valid_date($opts['e'])) {
				print "The argument for -e must be a valid date (yyyy-mm-dd).\n";
				return 1;
			}
			$search_enddate = $opts['e'];
			break;
		case 's':
			if (!is_valid_date($opts['s'])) {
				print "The argument for -s must be a valid date (yyyy-mm-dd).\n";
				return 1;
			}
			$search_startdate = $opts['s'];
			break;
		case 'o':
			if (!is_string($opts['o'])) {
				print "The argument for -o must be a valid object name.\n";
				return 1;
			}
			$search_object = $opts['o'];
			break;
		case 't':
			if (!array_key_exists ($opts['t'], $process_info)) {
				print "The argument for -t must be a valid process type.\n";
				return 1;
			}
			$process_type = $process_info[$opts['t']];
			break;
		case 'h':
			print "Usage: process-steps-calculate-averages.php [options]\n";
			print "Options:\n";
			print "\n";
			return 0;
			break;
		case 'v':
			$verbosity++;
			break;
		default:
			print "Invalid switch used. Verify the specified parameters.\n";
			return 1;
	}
}

if ($search_object == "") {
	print "You must use the -o option.\n";
	return 1;
}

/*** Database Connection */
$conn = db_connect ();
if ($conn == FALSE) {
	print "<p>db_connect(): failed</p>\n";
	return 2;
}
/*** Session Cache */
/*
session_create_cache ();
$AlertClass = $_SESSION['AlertClass'];
$AlertClassId = $_SESSION['AlertClassId'];
$AlertSeverity = $_SESSION['AlertSeverity'];
$AlertSeverityId = $_SESSION['AlertSeverityId'];
$AlertState = $_SESSION['AlertState'];
$AlertStateId = $_SESSION['AlertStateId'];
$_SESSION['username'] = "SYSTEM";
*/

/* Post cache-creation argument validation */
#if ($search_class != "" && (!isset ($AlertClassId[$search_class]))) {
#	print "The argument for -c must be a valid class name.\n";
#	return 1;
#}


$sql = "select";
$sql .= "   date(ad_timestamp) as 'date',";
$sql .= "   a_id as 'a_id',";
$sql .= "   ad_type as 'ad_type',";
$sql .= "   time_to_sec(time(ad_timestamp)) as 'asecs',";
$sql .= "   ad_data as 'data'";
$sql .= " from alert_data, alert";
$sql .= " where ad_a_id = a_id";
$sql .= "   and a_object = '" . $search_object . "'";
if ($search_startdate != "") {
	$sql .= "   and date(a_alerttime) >= '" . $search_startdate . "'";
}
if ($search_enddate != "") {
	$sql .= "   and date(a_alerttime) <= '" . $search_enddate . "'";
}
#$sql .= "   and ad_data like '% at %'";
$sql .= " order by ad_id,ad_type asc";

debug (1, "SQL='$sql'");
$result = mysql_query ($sql);
if ($result) {
	$date = "";
	$st = 0;
	$se = 0;
	while ($row = mysql_fetch_assoc ($result)) {

		#if ($row['date'] != $date) {
			#$date = $row['date'];
			if ($row['ad_type'] == 1) {
				$st = $row['asecs'];
			}
		#} else {
			if ($row['ad_type'] == 4 || $row['ad_type'] == 21) {
				$se = $row['asecs'];
				if ($se < $st) {
					$se += 86400;
				}
				printf ("%s runtime is %7.2f minutes.\n", $row['date'], ($se - $st)/60);
				#$date = "";
				$st = 0;
				$se = 0;
			}
			if ($row['ad_type'] == 22) {
				$se = $row['asecs'];
				if ($se < $st) {
					$se += 86400;
				}
				printf ("%s runtime is %7.2f minutes. (Process failed!)\n", $row['date'], ($se - $st)/60);
				#$date = "";
				$st = 0;
				$se = 0;
			}
		#}
	}
	mysql_free_result ($result);
} else {
	print "mysql_query(): " . mysql_error () . "\n";
	print "SQL: '" . $sql . "'\n";
	mysql_close ($conn);
	return 5;
}
mysql_close ($conn);
return 0;


function debug ($level, $message)
{
	global $verbosity;
	if ($verbosity >= $level) {
		print $message . "\n";
	}
	return;
}


?>
