#!/bin/bash
#
# resolve-common.sh - Resolve common alerts
#

RESOLVE_USER=tshadburn

# Manually entered password
#stty -echo
#echo -n "Enter a database access password: "
#read PSWD
#stty echo
#if [ "x$PSWD" = "x" ] ; then
#	echo "You have to type a password."
#	exit 1;
#fi

# Auto password
PSWD=""

ODIR=`pwd`
cd /var/www/netinfo/scripts
rm -f ./id.weeklyreboot ./id.backup1 ./id.backup2 ./id.exports ./id.clouseau ./id.scan-attack-info

# Scheduled weekly system reboot.
SQL="select a_id from alert where a_state = 4 and DAYOFWEEK(a_alerttime) = 7 and time(a_alerttime) between '22:00:00' and '22:45:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.weeklyreboot
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.weeklyreboot -m "Scheduled weekly system reboot."

# Scheduled weekly system reboot.
SQL="select a_id from alert where a_object = 'interface' and a_state = 2 and DAYOFWEEK(a_alerttime) = 7 and time(a_alerttime) between '22:00:00' and '22:45:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.weeklyreboot
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.weeklyreboot -m "Scheduled weekly system reboot."

# This alert occurred because a DAS ASP script failed to return within 10 minutes. This is a DAS application design flaw.
SQL="select a_id from alert where a_state in (1,2) and a_class = 6 and a_object = 'APPEVENTLOG' and a_message = '' and unix_timestamp(NOW()) - unix_timestamp(a_lasttime) > 43200 and a_message like '%Script timed out%'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.appevlog-dastimeout
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.appevlog-dastimeout -m "This alert occurred because a DAS ASP script failed to return within 10 minutes. This is a DAS application design flaw."

# This alert is a common occurrence, and is not an indication of a problem. This alert was closed after 12 hours.
SQL="select a_id from alert where a_state in (1,2) and a_class = 6 and a_object = 'APPEVENTLOG' and a_message = '' and unix_timestamp(NOW()) - unix_timestamp(a_lasttime) > 43200"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.appevlog-blank
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.appevlog-blank -m "This alert is a common occurrence, and is not an indication of a problem. This alert was closed after 12 hours."

# High utilization caused by antivirus scan processes
SQL="select a_id from alert where a_state = 4 and a_object = 'SYSCPU' and a_hostname in ('bea1-rh-dst','xmpp02-rh-dst','r4alesqa-rh-dst') and HOUR(a_alerttime) in (02,03)"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.avscan
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.avscan -m "High utilization caused by antivirus scan processes."

# High utilization caused by backup processes.
SQL="select a_id from alert where a_state = 4 and a_object = 'C:MOUNT' and a_hostname in ('r4starteam','xmkm01-w2k3-dst') and HOUR(a_alerttime) in (21,22,23,00)"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.backup-utilization
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.backup-utilization -m "High utilization caused by backup processes."

# High utilization caused by backup processes.
SQL="select a_id from alert where a_state = 4 and a_object in ('SYSCPU','CPUTOTAL') and time(a_alerttime) between '00:00:00' and '04:00:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.backup1
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.backup1 -m "High utilization caused by backup processes."

# High utilization caused by backup processes.
SQL="select a_id from alert where a_state = 4 and a_object in ('SYSCPU','CPUTOTAL') and time(a_alerttime) between '22:00:00' and '23:59:59'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.backup2
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.backup2 -m "High utilization caused by backup processes."

# High utilization caused by weekly, full backup processes.
SQL="select a_id from alert where a_state = 4 and a_object in ('SYSCPU','CPUTOTAL') and DAYOFWEEK(a_alerttime) = 1"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.backup1
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.backup1 -m "High utilization caused by weekly, full backup processes."

# High utilization caused by export processes.
SQL="select a_id from alert where a_state = 4 and a_object in ('CPU') and time(a_alerttime) between '00:00:00' and '04:00:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.exports
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.exports -m "High utilization caused by export processes."

# High utilization caused by date-roll processes.
SQL="select a_id from alert where a_state = 4 and a_object in ('CPU','SYSCPU') and time(a_alerttime) between '04:00:00' and '08:00:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.exports
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.exports -m "High utilization caused by date-roll processes."

# High utilization caused by printer mapping in a user session (winlogon.exe). Once the printers were mapped in the user's session, CPU utilization returned to normal.
SQL="select a_id from alert where a_state = 4 and a_object = 'CPUSYSTEM' and unix_timestamp(a_lasttime) - unix_timestamp(a_alerttime) < 600 and (a_hostname like '%ctx%' or a_hostname like '%CTX%')"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.errantuserprinters
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.errantuserprinters -m "High utilization caused by printer mapping in a user session (winlogon.exe). Once the printers were mapped in the user's session, CPU utilization returned to normal."

# High utilization caused by errant user session (winlogon.exe). Once the user logged off, CPU utilization returned to normal.
SQL="select a_id from alert where a_state = 4 and a_object = 'CPUSYSTEM' and unix_timestamp(a_lasttime) - unix_timestamp(a_alerttime) < 5400 and (a_hostname like '%ctx%' or a_hostname like '%CTX%')"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.errantusershort
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.errantusershort -m "High utilization caused by errant user session (winlogon.exe). Once the user logged off, CPU utilization returned to normal."

# High utilization caused by errant user session (winlogon.exe). Once the user's session was logged off, CPU utilization returned to normal.
SQL="select a_id from alert where a_state = 4 and a_object = 'CPUSYSTEM' and unix_timestamp(a_lasttime) - unix_timestamp(a_alerttime) > 5400 and (a_hostname like '%ctx%' or a_hostname like '%CTX%')"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.errantuserlong
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.errantuserlong -m "High utilization caused by errant user session (winlogon.exe). Once the user's session was logged off, CPU utilization returned to normal."

# Non-issue, internal system only. This service crashes (and it automatically restarted) occasionally when a user connects to this system.
SQL="select a_id from alert where a_state = 4 and a_hostname = 'CLOUSEAU' and a_object = 'CITRIXIMA'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.clouseau
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.clouseau -m "Non-issue, internal system only. This service crashes (and it automatically restarted) occasionally when a user connects to this system."

# Commented out by Todd on 2009-07-02 - These alerts are used as a part of the client process screens now.
# This is a normal exit code for this application.
#SQL="select a_id from alert where a_state in (1,2) and a_message like '%completed with non fatal error%'"
#echo "$SQL" | mysql --password=$PSWD netinfo >./id.argentjobs
#php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.argentjobs -m "This is a normal exit code for this application."

# Daily Wofco portal JVM reboots, prior to running daily
SQL="select a_id from alert where a_state in (1,4) and a_hostname = 'xmwlp03-rh-asp.asp.datascantech.com' and a_object like 'WOFCO%' and time(a_alerttime) between '16:00:00' and '17:00:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.wofcoportal
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.wofcoportal -m "Daily Wofco portal JVM reboots, prior to running daily."

# This type of network attack is a common occurrence, and can safely be ignored. It is an attack against ports/services that are not used on our network.
SQL="select a_id from alert where a_state in (1,2) and a_object like '%service-scan%' and a_severity > 4"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.scan-attack-info
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.scan-attack-info -m "This type of network attack is a common occurrence, and can safely be ignored. It is an attack against a port/service that is not used on our network."

# >48 hours: This type of network attack is a common occurrence, and can safely be ignored. It is an attack against ports/services that are not used on our network. This record was closed because it was greater than 48 hours old.
SQL="select a_id from alert where a_class = 4 and a_state in (1,2) and a_object like '%service-%' and a_severity > 3 and unix_timestamp() - unix_timestamp(a_lasttime) > 172800;"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.scan-attack-old
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.scan-attack-old -m "This type of network attack is a common occurrence, and can safely be ignored. It is an attack against a port/service that is not used on our network. This record was closed because it was greater than 48 hours old."

# High utilization caused by application processes.
SQL="select a_id from alert where a_object =  'SYSCPU' and a_state = 4 and time(a_lasttime) between '05:00:00' and '22:00:00' and unix_timestamp(a_lasttime) - unix_timestamp(a_alerttime) < 600"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.highutilapp
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.highutilapp -m "High utilization caused by application processes."

# >48 hours: This switch interface bounced and can probably be safely ignored. This record was closed because it was greater than 48 hours old.
SQL="select a_id from alert where a_class = 2 and a_state in (1,2) and a_object like 'interface' and a_message like 'Line protocol on interface%' and unix_timestamp() - unix_timestamp(a_lasttime) > 172800;"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.switchinterface
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.switchinterface -m "This switch interface bounced and can probably be safely ignored. This record was closed because it was greater than 48 hours old."

# This alert was generated by a login failure on the D/R proxy server, most likely an FTP brute-force attack. This individual alert was resolved in favor of a corrolation alert.
SQL="select a_id from alert where a_state = 1 and a_hostname = 'drproxy01-rh-asp.asp.datascantech.com' and a_object = 'SECURITY'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.login-failure
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.login-failure -m "This alert was generated by a login failure on the D/R proxy server, most likely an FTP brute-force attack. This individual alert was resolved in favor of a corrolation alert."

# This alert was generated by a daily Wofco JVM restart prior to running daily.
SQL="select a_id from alert where a_state in (1,2,4) and a_hostname = 'xmwlp03-rh-asp.asp.datascantech.com' and a_object like 'WOFCO%' and time (a_alerttime) between '16:45:00' and '18:00:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.jvm-wofco-pre
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.jvm-wofco-pre -m "This alert was generated by a daily Wofco JVM restart prior to running daily."

# This alert was generated by a daily Wofco JVM restart after running daily.
SQL="select a_id from alert where a_state in (1,2,4) and a_hostname = 'xmwlp03-rh-asp.asp.datascantech.com' and a_object like 'WOFCO%' and time (a_alerttime) between '22:00:00' and '23:15:00'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.jvm-wofco-post
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.jvm-wofco-post -m "This alert was generated by a daily Wofco JVM restart after running daily."

# This alert was generated by a mail bounce for this user. This is not critical, but indicates that the sending application should be corrected.
SQL="select a_id from alert where a_state in (1,2) and a_object = 'MAIL' and timestampdiff(DAY,a_lasttime,NOW()) >= 1"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.mail-bounce
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.mail-bounce -m "This alert was generated by a mail bounce for this user. This is not critical, but indicates that the sending application should be corrected."

# High utilization caused by application processes.
SQL="select a_id from alert where a_class = 5 and a_state = 4 and time(a_lasttime) between '05:00:00' and '22:00:00' and unix_timestamp(a_lasttime) - unix_timestamp(a_alerttime) < 900"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.highutilperf
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.highutilperf -m "High utilization caused by application processes."

# This alert was generated by a process that was consuming more resources than it should have been. This alert was closed because the process resource consumption has returned to normal levels.
SQL="select a_id from alert where a_state in (1,2) and a_object = 'PROCESS' and (timestampdiff(HOUR,a_lasttime,NOW()) >= 12 or timestampdiff(DAY,a_alerttime,NOW()) >= 1)"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.process-perf
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.process-perf -m "This alert was generated by a process that was consuming more resources than it should have been. This alert was closed because the process resource consumption has returned to normal levels."

# This alert was generated by a DataScan application process that was consuming more resources than it should have been. This alert was closed because the process resource consumption has returned to normal levels.
SQL="select a_id from alert where a_state in (1,2) and a_object = 'PROCESS' and timestampdiff(HOUR,a_lasttime,NOW()) >= 1 and a_message like 'wms.exe:%'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.process-perf-wms
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.process-perf-wms -m "This alert was generated by a DataScan application process that was consuming more resources than it should have been. This alert was closed because the process resource consumption has returned to normal levels."

# Ongoing DFS production environment setup.
SQL="select a_id from alert where a_state = 4 and a_hostname = '10.64.10.66' and a_object = 'interface'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.dfsprodbuild
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.dfsprodbuild -m "Ongoing DFS production environment setup."

# 4x application issue. This alert was generated by the 4x application. This issue was marked resolved, as no other actions have been taken on this alert within the given amount of time.
SQL="select a_id from alert where a_state in (1,2) and a_class = 6 and a_uniqueid = 70 and unix_timestamp(NOW()) - unix_timestamp(a_alerttime) > 86400"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.app-portal-traps
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.app-portal-traps -m "4x application issue. This alert was generated by the 4x application. This issue was marked resolved, as no other actions have been taken on this alert within the given amount of time."

# This security alert was generated by the 4x application. This issue was marked resolved, as no other actions have been taken on this alert within the given amount of time.
SQL="select a_id from alert where a_state in (1,2) and a_class = 4 and a_uniqueid = 71 and unix_timestamp(NOW()) - unix_timestamp(a_alerttime) > 86400"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.app-portal-traps
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.app-portal-traps -m "This security alert was generated by the 4x application. This issue was marked resolved, as no other actions have been taken on this alert within the given amount of time."

# This Weblogic JVM was restarted. In production environments, this is most often due to reboot because of design flaws in the application. In internal environments, this is most often due to application redeployment.
SQL="select a_id from alert where a_class = 6 and (a_state = 4 and a_message = 'Weblogic Server Started\n') or (a_state = 2 and a_message = 'Weblogic Server Shutdown\n\n')"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.wlsrestart
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.wlsrestart -m "This Weblogic JVM was restarted. In production environments, this is most often due to reboot because of design flaws in the application. In internal environments, this is most often due to application redeployment."

# Short-lived interface bounce on an internal user's workstation/phone. The most likely cause of this issue is a speed/duplex negotiation mismatch. The device connected to this port should have it's speed/duplex settings verified.
SQL="select a_id from alert where a_state = 4 and a_class = 2 and unix_timestamp(a_alerttime) - unix_timestamp(a_lasttime) <= 2 and a_hostname like '10.96.10.2%'"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.network-speed-duplex
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.network-speed-duplex -m "Short-lived interface bounce on an internal user's workstation/phone. The most likely cause of this issue is a speed/duplex negotiation mismatch. The device connected to this port should have it's speed/duplex settings verified."

# This alert was generated by the execution of a client (automation) process. This alert was resolved after it had been in the cleared state for longer than 96 hours
SQL="select a_id from alert where a_class = 6 and a_state = 4 and a_object in (select cp_object from client_process) and unix_timestamp(NOW()) - unix_timestamp(a_alerttime) > 345600"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.client-automation-process
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.client-automation-process -m "This alert was generated by the execution of a client (automation) process. This alert was resolved after it had been in the cleared state for longer than 96 hours."

# This alert was generated by a process execution job. This alert was closed because the job was marked completed more than 48 hours ago.
SQL="select a_id from alert where a_class = 6 and a_state = 4 and a_object like 'D%' and a_hostname like '%sched%' and unix_timestamp(now()) - unix_timestamp(a_lasttime) > 172800"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.application-process-old
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.application-process-old -m "This alert was generated by a process execution job. This alert was closed because the job was marked completed more than 48 hours ago."

# >48 hours: This type of application alert is a common occurrence, and can safely be ignored. This alert was closed because it was greater than 48 hours old.
SQL="select a_id from alert where a_class = 6 and a_state in (1,2) and a_severity > 4 and unix_timestamp() - unix_timestamp(a_lasttime) > 172800"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.application-old
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.application-old -m "This type of application alert is a common occurrence, and can safely be ignored. This alert was closed because it was greater than 48 hours old."

# This alert was generated by a Weblogic server restart. This alert was closed because it was greater than 48 hours old.
SQL="select a_id from alert where a_class = 6 and a_state = 4 and a_uniqueid = 20 and unix_timestamp() - unix_timestamp(a_lasttime) > 172800"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.wls-restart
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.wls-restart -m "This alert was generated by a Weblogic server restart. This alert was closed because it was greater than 48 hours old."

# This alert was closed because there was no activity on it after 14 days.
SQL="select a_id from alert where a_state in (1,2) and unix_timestamp(NOW()) - unix_timestamp(a_lasttime) > 1209600"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.old-no-activity
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.old-no-activity -m "This alert was closed because there was no activity on it after 14 days."

# This type of alert is generated when the interface is being used for packet capturing. This could indicate a compromised host, if the action was not performed by a system administrator. This alert was marked resolved, because the interface state has not changed in 96 hours.
SQL="select a_id from alert where a_class = 4 and a_state = 4 and a_object = 'SYSEVENT' and a_message like '%promiscuous mode%' and unix_timestamp(NOW()) - unix_timestamp(a_lasttime) > 345600"
echo "$SQL" | mysql --password=$PSWD netinfo >./id.promiscuous-interface
php ./alert-resolve.php -u $RESOLVE_USER -r -f ./id.promiscuous-interface -m "This type of alert is generated when the interface is being used for packet capturing. This could indicate a compromised host, if the action was not performed by a system administrator. This alert was marked resolved, because the interface state has not changed in 96 hours."


cd $ODIR
exit 0

