#!/usr/bin/php
<?php

$logfile = "/var/log/snmptrap-processor-ni.log";
$trapspooldir = "/var/spool/snmp-trap-ni";
$alertdir = "/var/spool/nagios/alerts";
$interval = 15;

$persisttype = "alert";
$notifications = TRUE;

$dbhost = "localhost:3306";
$dbname = "netinfo";
$dbuser = "netinfou";
$dbpass = "!N3t1nF0%";


$AlertSeverity = array ();
$AlertSeverityId = array ();


$lfd = fopen ($logfile, "a");

if (!is_dir ($trapspooldir)) {
	log_message ("Error: '" . $trapspooldir . "' is not a directory.");
	fclose ($lfd);
	return 1;
}
$conn = mysql_connect ($dbhost, $dbuser, $dbpass);
if (!$conn) {
	log_message ("mysql_connect(): " . mysql_error ());
	fclose ($lfd);
	return 2;
}
if (!mysql_select_db ($dbname)) {
	log_message ("mysql_select_db(): " . mysql_error ());
	mysql_close ($conn);
	fclose ($lfd);
	return 2;
}


$rc = initialize_cache ();
if ($rc != 0) {
	log_message ("initialize_cache(): failed.");
	mysql_close ($conn);
	fclose ($lfd);
	return 2;
}



while (1) {
	$dh = opendir ($trapspooldir);
	while (($file = readdir ($dh)) !== false) {
		if (strncmp ($file, "trap-", 5) != 0) {
			continue;
		}
		$filepath = $trapspooldir . "/" . $file;
		#print "DEBUG: filepath=" . $filepath . "\n";
		$rc = process_trap_file ($filepath);
	}
	closedir ($dh);
	sleep ($interval);
}

fclose ($lfd);
return 0;


function process_trap_file ($filepath) {
	#log_message ("Processing '" . $filepath);
	# Read in the contents of the trap file
	$fh = fopen ($filepath, "r");
	if ($fh == false) {
		log_message ("Warning: Failed to open '" . $filepath);
		return 1;
	}
	unset($trap);
	$lastoid = "";
	while (!feof ($fh)) {
		$line = fgets ($fh, 4096);
		$line = rtrim ($line);
		#log_message ("DEBUG line='" . $line . "'");
		if (strncmp ($line, "HOST:", 5) == 0) {
			$f = explode (" ", $line, 3);
			$host = $f[1];
			$trap['hostname'] = $host;
		} else if (strncmp ($line, "TIMESTAMP:", 10) == 0) {
			$f = explode (" ", $line, 3);
			$timestamp = $f[1];
			$trap['timestamp'] = $timestamp;
		} else if (strncmp ($line, "TRAP:", 5) == 0) {
			$f = explode (" ", $line, 3);
			if (strstr ($f[1], "::") !== FALSE) {
				$f[2] = ltrim(rtrim($f[2], "\""), "\"");
				$trap[$f[1]] = $f[2];
				$lastoid = $f[1];
			} else if (strncmp ($f[1], "netinfo.", 8) == 0 ||
		    	    strncmp ($f[1], "nagios.", 7) == 0) {
				$f[2] = ltrim(rtrim($f[2], "\""), "\"");
				$trap[$f[1]] = $f[2];
				$lastoid = $f[1];
			} else {
				$trap[$lastoid] .= $f[1] . " " . $f[2] . " ";
			}
		} else {
			# nothing
		}
	}
	fclose ($fh);
	unlink ($filepath);

	# DEBUG
	#print "DEBUG: host=" . $host . "\n";
	#print "DEBUG: timestamp=" . $timestamp . "\n";
	#log_message ("Trap:\n" . print_r ($trap));

	# Perform processing of the trap information (alerts, etc)
	#$trapoid = $trap['.1.3.6.1.6.3.1.1.4.1.0'];
	$trapoid = $trap['SNMPv2-MIB::snmpTrapOID.0'];
	$sql = sprintf ("select tf_id from trap_filter " .
			" where tf_trapoid = '%s' order by tf_order asc",
			$trapoid);
	#log_message ("DEBUG: sql='" . $sql . "'");
	$result = mysql_query ($sql);
	if ($result) {
		$tfilter = array();
		while ($row = mysql_fetch_row ($result)) {
			$tfilter[] = $row[0];
		}
		mysql_free_result ($result);
	}

	#if (count($tfliter) == 0) {
	#	log_message ("DEBUG: No trap filter for trapoid = '$trapoid'\n");
	#}
	$handled = 0;

	foreach ($tfilter as $tfid) {
		$sql = sprintf ("select tfm_oid,tfm_comparator,tfm_value " .
				" from trap_filter_match " .
				" where tfm_tf_id = %d",
				$tfid);
		#log_message ("DEBUG: sql='" . $sql . "'");
		$result = mysql_query ($sql);
		if ($result) {
			$matched = 0;
			$matchrows = 0;
			while ($row = mysql_fetch_row ($result)) {
				$matchrows++;
				if (trap_matches ($trap, $row) == TRUE) {
					$matched++;
				}
			}
			mysql_free_result ($result);
			#print "DEBUG: finished match testing\n";
			if ($matched == $matchrows) {
				#log_message ("DEBUG: trap passed all matches!");
				# The trap matched all criteria
				$rc = trap_handle_match ($host, $trap, $tfid);
				$handled = 1;
				break; # Stop at the first filter matched
			}
		}
	}

	# Log the unhandled trap
	if ($handled == 0) {
		log_message ("**********************************************************************");
		log_message ("DEBUG: Unhandled: trapoid = '$trapoid'");
		log_message ("       hostname = $host");
		foreach ($trap as $k => $v) {
			log_message ("       $k = $v");
		}
	}

	return 0;
}


function trap_matches ($trap, $match)
{
	$matched = 1;
	$foid = "/" . $match[0] . "/";
	$comp = $match[1];
	$value = $match[2];

	#print "DEBUG: match=\n" . print_r ($match) . "trap = \n" . print_r($trap) . "\n";

	# Use regex to match OIDs
	$oid = "";
	$tkeys = array_keys ($trap);
	foreach ($tkeys as $key) {
		if (preg_match ($foid, $key, $matches) == 1) {
			$oid = $matches[0];
			break;
		}
	}
	if (strlen ($oid) == 0) {
		#log_message ("trap_matches: zero-length OID.");
		return 0;
	}
	if (!isset ($trap[$oid])) {
		#log_message ("trap_matches: oid($oid) not found in trap.");
		return 0;
	}

	switch ($comp) {
		case "=":
			if ($trap[$oid] == $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case "!=":
			if ($trap[$oid] != $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case ">=":
			if ($trap[$oid] >= $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case "<=":
			if ($trap[$oid] <= $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case ">":
			if ($trap[$oid] > $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case "<":
			if ($trap[$oid] < $value) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case "regex":
			$mval = "/" . $value . "/";
			if (preg_match ($mval, $trap[$oid]) == 1) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		case "!regex":
			$mval = "/" . $value . "/";
			if (preg_match ($mval, $trap[$oid]) == 0) {
				$matched = 1;
			} else {
				$matched = 0;
			}
			break;
		default:
			$matched = 0;
	}
	return $matched;
}


function trap_handle_match ($host, $trap, $tfid)
{
	global $alertdir;
#       log_message ("MATCH - TRAP:\n" . print_r ($trap));
	$sql = sprintf ("select * from trap_filter " .
			"where tf_id = %d",
			$tfid);
	$result = mysql_query ($sql);
	if ($result) {
		$tfrow = mysql_fetch_row ($result);
#	       log_message ("MATCH - TRAP FILTER:\n" . print_r ($tfrow));
		mysql_free_result ($result);
	} else {
		log_message ("trap_handle_match(): sql='" . $sql . "'");
		log_message ("mysql_query(): " . mysql_error ());
		return 1;
	}

	/* Fix the characters that were escaped by mysql_real_escape_string() */
	$tfrow[9] = stripslashes ($tfrow[9]);

	$action = nvstring_to_array ($tfrow[9], ";");
	if ($GLOBALS['notifications'] == TRUE && $action['notify'] != "") {
		$rc = emit_notification ($host, $action['notify'], $action, $trap);
	}

	if ($action['action'] == "drop") {
		# The trap should be dropped, just return (successful)
		# notifications are still sent (above), but the alert
		# will not be persisted (below).
		#log_message ("Dropping trap per filter id# $tfid.");
		return 0;
	}

	$rc = trap_handler_trap2alert ($host, $trap, $tfrow, $action);

	return 0;
}


function find_key_regex_match ($array, $keymatch)
{
	$foid = "/" . $keymatch . "/";
	$akeys = array_keys ($array);
	foreach ($akeys as $key) {
		if (preg_match ($foid, $key, $matched) == 1) {
			return $matched[0];
		}
	}
	return FALSE;
}


function nvstring_to_array ($string, $pairdelim)
{
	$r = array ();
	$a = explode ($pairdelim, $string);
	foreach ($a as $p) {
		#log_message ("DEBUG: nvstring_to_array(): p='" . $p . "'");
		$b = explode ("=", $p, 2);
		#log_message ("DEBUG: nvstring_to_array(): n='" . $b[0] . "' v='" . $b[1] . "'");
		$r[$b[0]] = $b[1];
	}
	return $r;
}


function log_message ($msg)
{
	global $lfd;
	$lt = localtime();
	fprintf ($lfd,
		"%04d-%02d-%02d %02d:%02d:%02d %s\n",
		$lt[5]+1900,
		$lt[4]+1,
		$lt[3],
		$lt[2],
		$lt[1],
		$lt[0],
		$msg);
	return;
}


function trap_handler_trap2alert ($host, $trap, $tfrow, $action)
{
	$aid = 0;
	global $AlertSeverity;
	global $AlertSeverityId;

	# Build a datatime/timestamp from the unix timestamp in the trap
	if (isset ($trap['timestamp']) && $trap['timestamp'] > 0) {
		$timestamp = date ("Y-m-d H:i:s", $trap['timestamp']);
	} else {
		$timestamp = date ("Y-m-d H:i:s");
	}
	
	##################################################################
	# uniquestr building/parsing:
	# uniquestr_oid = Specifies the OID to run the regex against
	# uniquestr_regex = The regex to execute, the matches will be
	# stored as oids named: 'unique.match.n', where n >= 0
	##################################################################
	if (isset ($action['uniquestr_oid']) &&
	    isset ($action['uniquestr_regex'])) {
		$a = array ();

		#log_message ("DEBUG: uniquestr start\n");
		#log_message ("DEBUG: uniquestr_oid = '" . $action['uniquestr_oid'] . "'\n");
		#log_message ("DEBUG: uniquestr_regex = '" . $action['uniquestr_regex'] . "'\n");
		#log_message ("DEBUG: uniquestr = '" . $action['uniquestr'] . "'\n");
	
		#$o = $action['uniquestr_oid'];
		$o = find_key_regex_match ($trap, $action['uniquestr_oid']);

		$ov = $trap[$o];
		$re = "/" . $action['uniquestr_regex'] . "/";
		$rc = preg_match ($re, $ov, $a);
		if ($rc == 1) {
			#log_message ("DEBUG: uniquestring_regex passed\n");
			$i = 0;
			foreach ($a as $v) {
				$onn = "unique.match.$i";
				#log_message ("DEBUG: uniquestring onn='" . $onn . "'  v='" . $v . "'\n");
				$trap[$onn] = $v;
				$i++;
			}
		}
		#log_message ("DEBUG: uniquestr end\n");
	}

	# Build the uniquestr, if it's configured
	$uniquestr = "";
	if (isset ($action['uniquestr'])) {
		$uniquestr = format_string_from_trap ($action['uniquestr'],
					$trap);
		# DEBUG
		if ($uniquestr == "") {
			log_message ("ERROR: The uniquestr action was set, but it resulted in an empty string.");
			log_message ("ERROR: tf_id=" . $tfrow[0] . " trapoid=" . $trap['SNMPv2-MIB::snmpTrapOID.0']);
			#print "uniquestr=''\ntrap=\n" . print_r($trap);
		}
		# DEBUG
	}
	
	# TODO: The database field is currently only 64 characters wide :(
	$uniquestr = substr ($uniquestr, 0, 64);

	#####################################################################
	# Moved from above uniquestr handling, to allow the objectoid/msgoid
	# to be generated from the uniquestr regex
	#####################################################################
	# Get the objectname from either a TRAP OID (if configured) or
	# from trap_filter.tf_object
	if ($action['objectoid'] != "") {
		$oid = find_key_regex_match ($trap, $action['objectoid']);
		#$object = $trap[$oid] . "\n";
		$object = $trap[$oid];
	} else {
		$object = $tfrow[8];
	}
	# Build the message from any configured 'msgoid' or 'message' settings
	$message = "";
	if (isset($action['message']) && $action['message'] != "") {
		$message .= $action['message'];
	}
	if (isset ($action['msgoid']) && $action['msgoid'] != "") {
		$oid = find_key_regex_match ($trap, $action['msgoid']);
		if ($message != "") {
			$message .= " - ";
		}
		$message .= $trap[$oid];
	}
	if (isset ($action['msgoid2']) && $action['msgoid2'] != "") {
		$oid = find_key_regex_match ($trap, $action['msgoid2']);
		if ($message != "") {
			$message .= " - ";
		}
		$message .= $trap[$oid];
	}



	# TODO: Add changes for any configured trap_filter_fixup records
	# TODO: Add changes for any configured trap_filter_fixup records

	# If this filter is not flaged as 'unique',
	# check for an already exiting alert record
	if ($tfrow[10] == 0) {
		# See if there is an existing (non-Cleared, non-Resolved) alert
		$sql = sprintf ("select %s from alert where a_hostname = '%s' and a_object = '%s' and a_class = %d and a_state not in (4,5) ",
			"a_id,a_state,a_hitcount",
			$host,
			mysql_real_escape_string ($object),
			$tfrow[1]);
		if ($uniquestr != "") {
			$sql .= sprintf (" and a_uniquestr = '%s' ",
				mysql_real_escape_string ($uniquestr));
		}
		if ($tfrow[3] != 0) {
			$sql .= sprintf (" and a_uniqueid = %d ",
				$tfrow[3]);
		}
		$sql .= " order by a_id desc";

		#log_message ("DEBUG: sql='" . $sql . "'");
		$result = mysql_query ($sql);
		if ($result) {
			$row = mysql_fetch_row ($result);
			$aid = $row[0];
			$astate = $row[1];
			$ahitcount = $row[2];
			mysql_free_result ($result);
		} else {
			log_message ("trap_handler_trap2alert(): sql='" . $sql . "'");
			log_message ("mysql_query(): " . mysql_error ());
		}
	}

	if ($aid != 0) {
		$sql_field_updates = "";
		#mysql_begin_transaction ();
		# If 'appendevent' is set in the trap_filter, append an event
		# record to the existing alert.
		if (isset ($action['appendevent']) && $action['appendevent'] >= 1) {
			# Only append if this is not a 'Clearing' event
			if ($astate >= 1 && $astate <= 3 && $tfrow[4] != 1) {
				# insert an alert_data(Event) record
				alert_add_data ($aid,
						$action['appendevent'],
						$message);
			}
		}

		/* Update the alert severity, if requested */
		if (isset ($action['severity'])) {
			$sevname = $action['severity'];
			$sevid = $AlertSeverityId[$sevname];
			if (is_valid_integer ($sevid) && $sevid != 0) {
				$sql_field_updates .= ", a_severity = $sevid ";
				log_message ("Updating severity to '$sevname' for alert# $aid");
			}
		}
		
		# update the existing alert record
		if ($astate == 3) {
			# If the existing alert is 'Ackd', leave it that way
			$state = $astate;
			# Increment the hitcount for the existing alert
			$ahitcount++;
		} else {
			# If the existing alert is not 'ack'd', then...
			# If this is a 'recover' trap...
			if ($tfrow[4] == 1) {
				# Mark the existing alert as 'Cleared'
				$state = 4;
				# insert the alert_data(Cleared) record
				alert_add_data ($aid, $state, $message);
				# Dont increment the hitcount for a 'clear' event
			} else {
				# Mark the existing alert as a Dup(licate)
				$state = 2;
				# Increment the hitcount for the existing alert
				$ahitcount++;
			}
		}

		$sql = sprintf ("update alert set a_lasttime = '%s', a_state = %d, a_hitcount = %d, a_message = '%s' %s where a_id = %d",
			$timestamp,
			$state,
			$ahitcount,
			mysql_real_escape_string ($message),
			$sql_field_updates,
			$aid);
		#log_message ("DEBUG: sql='" . $sql . "'");
		$result = mysql_query ($sql);
		if (!$result) {
			log_message ("trap_handler_trap2alert(): sql='" . $sql . "'");
			log_message ("mysql_query(): " . mysql_error ());
			#mysql_rollback ();
		}
		#mysql_commit ();
	} else {
		if ($tfrow[4] == 1) {
			# This is a 'markrecover' filter, but there was no
			# existing alert. Log it, but don't add an alert.
			log_message ("trap_handler_trap2alert():");
			log_message ("The following 'recover' event was processed, but no matching alert record was found:");
			log_message ("TrapFilter='" . $tfrow[6] . "'");
			log_message ("TrapData:");
			foreach ($trap as $k => $v) {
				log_message ($k . " = " . $v);
			}
			return;
		}
		# insert the new alert record
		#mysql_begin_transaction ();
		$sql = sprintf ("insert into alert (%s) values ('%s', '%s', %d, %d, %d, %d, '%s', '%s', '%s', '%s', %d) ",
				"a_alerttime,a_lasttime,a_class,a_severity,a_state,a_uniqueid,a_hostname,a_object,a_uniquestr,a_message,a_hitcount",
				$timestamp,
				$timestamp,
				$tfrow[1],
				$tfrow[2],
				1,
				$tfrow[3],
				$host,
				mysql_real_escape_string ($object),
				mysql_real_escape_string ($uniquestr),
				mysql_real_escape_string ($message),
				1);
		#log_message ("DEBUG: sql='" . $sql . "'");
		$result = mysql_query ($sql);
		if ($result) {
			$aid = mysql_insert_id ();
		} else {
			log_message ("trap_handler_trap2alert(): sql='" . $sql . "'");
			log_message ("mysql_query(): " . mysql_error ());
			#mysql_rollback ();
			return;
		}
		if ($aid != 0) {
			# The alert creation succeeded, add the alert_data records
			$traptext = "";
			foreach ($trap as $k => $v) {
				$traptext .= $k . " " . $v . "\n";
			}
			#$traptext .= "\n\n" . $message . "\n";
			# insert the alert_data(Data) record (the trap content)
			alert_add_data ($aid, 6, $traptext);
			# insert the alert_data(Event) record
			alert_add_data ($aid, 1, $message);
		}
		#mysql_commit ();

		# Send a notification for the new alert, if requested
		if ($GLOBALS['notifications'] == TRUE && $action['notifynew'] != "") {
			$notify = fixup_notify_groups ($host, $object, $action['notifynew']);
			$rc = emit_notification ($host, $notify, $action, $trap);
			#$rc = emit_notification ($host, $action['notifynew'], $action, $trap);
		}

		# DST SPECIFIC: Put the most recent a_id in the client_process table record, if requested
		if (isset ($action['cp_update']) && $action['cp_update'] == 1) {
			client_process_update_latest_a_id ($aid, $object);
		}

	}
	return;
}


function alert_add_data ($aid, $type, $message)
{
	if ($aid <= 0 || $type < 1 || $message == "") {
		return 1;
	}
	$sql = sprintf ("insert into alert_data (%s) values (%d, NOW(), %d, '%s','%s');",
		"ad_a_id,ad_timestamp,ad_type,ad_name,ad_data",
		$aid,
		$type,
		"SYSTEM",
		mysql_real_escape_string ($message));
	#log_message ("DEBUG: sql='" . $sql . "'");
	$result = mysql_query ($sql);
	if (!$result) {
		log_message ("trap_handler_trap2alert(): sql='" . $sql . "'");
		log_message ("mysql_query(): " . mysql_error ());
		#mysql_rollback ();
		return 2;
	}
	return 0;
}


#
# format_string_from_trap - Format the given string from trap contents
#			   {variable} is replaced with 'variable' contents
#			    from the trap
#
function format_string_from_trap ($format, $oidlist)
{
	$out = "";
	$a = preg_split ("/({[\w\d\.\(\)]+})/",
			$format,
			-1,
			PREG_SPLIT_DELIM_CAPTURE);
	foreach ($a as $i) {
		if (strpos ($i, "{") !== FALSE) {
			$i = trim ($i, "{}");
			$out .= $oidlist[$i];
		} else {
			$out .= $i;
		}
	}
	return $out;
}


#
# emit_notification - Emit a notification for the given trap
#
function emit_notification ($host, $notify, $action, $trap)
{
	global $alertdir;
	# Format the basic alert fields
	$s = "TYPE TRAP\n";
	$s .= "HOST " . $host . "\n";
	$s .= "SUBJECT TRAP " . $host . "\n";
	$s .= "CONTACT reporter\n";
	$s .= "ALERTGROUPS " . $notify . "\n";
	$s .= "Subject: TRAP " . $host . "\n";

	# Additions to satisfy epager formatting
	$s .= "Host: $host\n";
	if ($action['message'] != "") {
		$s .= "Info: " . $action['message'] . "\n";
	}

	# Additional trap information
	if ($action['message'] != "") {
		$s .= $action['message'] . "\n";
	}
	if ($action['msgoid'] != "") {
		$oid = find_key_regex_match ($trap, $action['msgoid']);
		$s .= $trap[$oid] . "\n";
	}
	if ($action['msgoid2'] != "") {
		$oid = find_key_regex_match ($trap, $action['msgoid2']);
		$s .= $trap[$oid] . "\n";
	}

	# Write the alert file into the spool directory
	$afile = $alertdir . "/alert-" . time() . "-trap";
	$fd = fopen ($afile, "w");
	if ($fd != FALSE) {
		fprintf ($fd, $s);
		fclose ($fd);
	} else {
		log_message ("Failed to open alert spool file.");
	}
	return;
}


function fixup_notify_groups ($host, $object, $notify)
{
	$newnotify = "";
	if ($host == "" || $object == "" || $notify == "") {
		return "";
	}
	$sql = sprintf ("select %s from trap_filter_notify where tfn_hostname ='%s' and tfn_object = '%s'",
		"tfn_notifygroups",
		$host,
		$object);
	#log_message ("DEBUG: sql='" . $sql . "'");
	$result = mysql_query ($sql);
	if (!$result) {
		log_message ("trap_handler_trap2alert(): sql='" . $sql . "'");
		log_message ("mysql_query(): " . mysql_error ());
		#mysql_rollback ();
		return $notify;
	}
	$rowcount = mysql_num_rows($result);
	if ($rowcount >= 1) {
		$row = mysql_fetch_assoc ($result);
		$newnotify = $row['tfn_notifygroups'];
	} else {
		$newnotify = $notify;
	}
	mysql_free_result ($result);
	return $newnotify;
}


#
# DST SPECIFIC: Put the most recent a_id in the client_process table record
#
function client_process_update_latest_a_id ($aid, $object)
{
	if ($aid <= 0 || $object == "") {
		return 1;
	}
	$sql = sprintf ("update client_process set cp_latest_a_id = %lu where cp_object = '%s'",
		$aid,
		addslashes ($object));
	#log_message ("DEBUG: sql='" . $sql . "'");
	$result = mysql_query ($sql);
	if (!$result) {
		log_message ("client_process_update_latest_a_id(): sql='" . $sql . "'");
		log_message ("mysql_query(): " . mysql_error ());
		#mysql_rollback ();
		return 2;
	}
	return 0;
}


function initialize_cache ()
{
	global $AlertSeverity;
	global $AlertSeverityId;

	$sql = "select as_id, as_name from alert_severity";
	$result = mysql_query ($sql);
	if (!$result) {
		log_message ("initialize_cache(): sql='" . $sql . "'");
		log_message ("mysql_query(): " . mysql_error ());
		return 1;
	}
	while ($row = mysql_fetch_row ($result)) {
		$AlertSeverity[$row[0]] = $row[1];
		$AlertSeverityId[$row[1]] = $row[0];
	}
	mysql_free_result ($result);
	return 0;
}


function is_valid_integer ($value)
{
        return preg_match ("/^\d+$/", $value);
}


function is_valid_date ($value)
{
        return preg_match ("/^\d\d\d\d-\d\d-\d\d$/", $value);
}


function is_valid_time ($value)
{
        return preg_match ("/^\d\d:\d\d:\d\d$/", $value);
}


function is_valid_timestamp ($value)
{
        return preg_match ("/^\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d$/", $value);
}


?>
