<?php



/*** Setup or restore the session data */
session_start ();

include 'common-functions.php';
include 'validate-functions.php';
include 'page-functions.php';
include 'netinfo-config-variables.php';

/*** If not authenticated, display the login page */
$rc = session_validate ();
if ($rc != TRUE) {
		return 0;
}

#if ($_SESSION['page'] == "alerts") {
#		page_header (120);
#} else {
#		page_header (-1);
#}

$conn = db_connect ();
if ($conn == FALSE) {
		print "<p>db_connect(): failed</p>\n";
			return 2;
}

$access = $_SESSION['accessrights'];


$refresh_interval = 120;

$page_width = 80;
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	if ($_GET['width'] == "wide") {
		$page_width = 132;
	}
}

$dt = date (time ());
$load_avg = array (0.0, 0.0, 0.0, "0/0");
#$fd = fopen ("/proc/loadavg", "r");
#$line = fgets ($fd);
#fclose ($fd);
#$load_avg = explode (" ", $line);

$objtype = 0;
$hosts_up = 0;
$hosts_down = 0;
$hosts_unreachable = 0;
$services_okay = 0;
$services_warning = 0;
$services_critical = 0;
$services_unknown = 0;
$fd = fopen ("/var/log/nagios/status.dat", "r");
while (!feof ($fd)) {
	$line = fgets ($fd);
	$f = explode (" ", ltrim ($line));
	if (strpos ($line, "{") !== FALSE) {
		$objtype = $f[0];
	} else if (strpos ($line, "}") !== FALSE) {
		$objtype = "";
	} else {
		if (strpos ($line, "current_state") !== FALSE) {
			$nv = explode ("=", $line, 2);
			if ($objtype == "host") {
				if ($nv[1] == 0) {
					$hosts_up++;
				} else if ($nv[1] == 1) {
					$hosts_down++;
				} else {
					$hosts_unreachable++;
				}
			} else if ($objtype == "service") {
				if ($nv[1] == 0) {
					$services_okay++;
				} else if ($nv[1] == 1) {
					$services_warning++;
				} else if ($nv[1] == 2) {
					$services_critical++;
				} else {
					$services_unknown++;
				}
			}
		}
	}
}
fclose ($fd);

print "<html>\n";
print "<head>\n";
print "<title>System Monitoring Telemetry</title>\n";
print "<META HTTP-EQUIV=Refresh CONTENT='" . $refresh_interval . "'>\n";
print "</head>\n";
print "<body bgcolor='black' color='green'>\n";

print "<font color='green' size='+1'>\n";

print "<p>\n";
print "<pre>\n";
printf ("%-16s %-16s %-16s ETS=%d\n",
	"SMT",
	"CH",
	"MISSION",
	time ());
printf ("%-16s %-16s %-16s CTS=%s\n",
	"",
	"IT",
	"LOCK-IN",
	date ("c"));
print "</pre>\n";
print "</p>\n";

print "<p>\n";
print "<pre>\n";
printf ("+-Hosts---------------------+  +-Services------------------+  +-Perf-----------+\n");
printf ("| %-18s  %5d |  | %-18s  %5d |  | %-8s %-5s |\n",
	"Up",
	$hosts_up,
	"Okay",
	$services_okay,
	"Apids",
	$load_avg[3]);
printf ("| %-18s  %5d |  | %-18s  %5d |  | %-8s %-5s |\n",
	"Down",
	$hosts_down,
	"Warning",
	$services_warning,
	"Lavg",
	$load_avg[1]);
printf ("| %-18s  %5d |  | %-18s  %5d |  | %-8s %-5s |\n",
	"Unreachable",
	$hosts_unreachable,
	"Critical",
	$services_critical,
	"Hdly",
	"0.135");
printf ("| %-18s  %5s |  | %-18s  %5d |  | %-8s %-5s |\n",
	"",
	"",
	"Unknown",
	$services_unknown,
	"Sdly",
	"0.326");
printf ("+---------------------------+  +---------------------------+  +----------------+\n");
print "</pre>\n";
print "</p>\n";


$data_width = $page_width - 30;
print "<p>\n";
print "<pre>\n";
printf ("+-Alerts---------------------" . str_pad ("", $data_width, "-") . "+\n");
$sql = "select a_hostname,a_object,as_name,a_message ";
$sql .= "from alert,alert_severity ";
$sql .= "where as_id = a_severity ";
$sql .= "and a_state in (1,2) ";
$sql .= "and a_severity <= 4 ";
$sql .= "order by a_id desc limit 20";
$result = mysql_query ($sql);
if ($result) {
	while ($row = mysql_fetch_assoc ($result)) {
		if (strpos($row['a_hostname'], "com") !== FALSE) {
			$h = explode ('.', $row['a_hostname']);
		} else {
			$h = array ($row['a_hostname'], "");
		}
		$fmt = "| %-20s %-5s %-" . $data_width . "s|\n";
		#printf ("| %-20s %-5s %-50s|\n",
		printf ($fmt,
			$h[0],
			substr ($row['as_name'], 0, 4),
			strip_tags (substr ($row['a_message'], 0, $data_width-1)));
	}
	mysql_free_result ($result);
}
printf ("|" . str_pad ("", $page_width-2, " ") . "|\n");
printf ("+----------------------------" . str_pad ("", $data_width, "-") . "+\n");
print "</pre>\n";
print "</p>\n";

print "<p>\n";
print "</p>\n";

print "</font>\n";

print "</body>\n";
print "</html>\n";

/*** Free resources */
mysql_close ($conn);

?>
